/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMetaMock
implements ItemMeta,
Damageable,
Repairable {
    private String displayName = null;
    private List<String> lore = null;
    private int damage = 0;
    private int repairCost = 0;
    private Map<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
    private Set<ItemFlag> hideFlags = EnumSet.noneOf(ItemFlag.class);
    private PersistentDataContainerMock persistentDataContainer = new PersistentDataContainerMock();
    private boolean unbreakable = false;
    private Integer customModelData = null;

    public ItemMetaMock() {
    }

    public ItemMetaMock(@NotNull ItemMeta meta) {
        this.unbreakable = meta.isUnbreakable();
        this.enchants = new HashMap<Enchantment, Integer>(meta.getEnchants());
        this.customModelData = meta.hasCustomModelData() ? Integer.valueOf(meta.getCustomModelData()) : null;
        this.hideFlags.addAll(meta.getItemFlags());
        if (meta.hasDisplayName()) {
            this.displayName = meta.getDisplayName();
        }
        if (meta.hasLore()) {
            this.lore = meta.getLore();
        }
        if (meta instanceof Damageable) {
            this.damage = ((Damageable)meta).getDamage();
        }
        if (meta instanceof Repairable) {
            this.repairCost = ((Repairable)meta).getRepairCost();
        }
        if (meta instanceof ItemMetaMock) {
            this.persistentDataContainer = ((ItemMetaMock)meta).persistentDataContainer;
        }
    }

    static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        Enchantment enchant;
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        Iterator<Enchantment> var2 = enchantments.keySet().iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!(enchant = var2.next()).conflictsWith(ench));
        return true;
    }

    public boolean hasDisplayName() {
        return Objects.nonNull(this.displayName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    private boolean isLoreEquals(ItemMeta meta) {
        if (this.lore == null) {
            return !meta.hasLore();
        }
        if (!meta.hasLore()) {
            return false;
        }
        List otherLore = meta.getLore();
        if (this.lore.size() == otherLore.size()) {
            for (int i = 0; i < this.lore.size(); ++i) {
                if (this.lore.get(i).equals(otherLore.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isDisplayNameEqual(ItemMeta meta) {
        if (this.displayName != null) {
            if (meta.hasDisplayName()) {
                return this.displayName.equals(meta.getDisplayName());
            }
            return false;
        }
        return !meta.hasDisplayName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.lore == null ? 0 : this.lore.hashCode());
        result = 31 * result + (this.customModelData == null ? 0 : this.customModelData.hashCode());
        result = 31 * result + (this.enchants.isEmpty() ? 0 : this.enchants.hashCode());
        result = 31 * result + (this.hasRepairCost() ? this.repairCost : 0);
        result = 31 * result + (!this.persistentDataContainer.isEmpty() ? this.persistentDataContainer.hashCode() : 0);
        result = 31 * result + (this.hideFlags.isEmpty() ? 0 : this.hideFlags.hashCode());
        result = 31 * result + Boolean.hashCode(this.unbreakable);
        result = 31 * result + (this.hasDamage() ? this.damage : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemMeta)) {
            return false;
        }
        ItemMeta meta = (ItemMeta)obj;
        if (!this.isDisplayNameEqual(meta)) {
            return false;
        }
        if (!this.isLoreEquals(meta)) {
            return false;
        }
        if (obj instanceof Damageable) {
            Damageable damageable = (Damageable)obj;
            if (this.hasDamage() != damageable.hasDamage() || this.hasDamage() && this.getDamage() != damageable.getDamage()) {
                return false;
            }
        } else if (this.hasDamage()) {
            return false;
        }
        if (!this.enchants.equals(meta.getEnchants())) {
            return false;
        }
        if (!this.hideFlags.equals(meta.getItemFlags())) {
            return false;
        }
        if (!this.persistentDataContainer.equals(meta.getPersistentDataContainer())) {
            return false;
        }
        if (this.unbreakable != meta.isUnbreakable()) {
            return false;
        }
        return this.hasCustomModelData() == meta.hasCustomModelData() && (!this.hasCustomModelData() || this.getCustomModelData() == meta.getCustomModelData());
    }

    public ItemMetaMock clone() {
        try {
            ItemMetaMock meta = (ItemMetaMock)super.clone();
            meta.displayName = this.displayName;
            if (this.lore != null) {
                meta.lore = new ArrayList<String>(this.lore);
            }
            meta.unbreakable = this.unbreakable;
            meta.customModelData = this.customModelData;
            meta.enchants = new HashMap<Enchantment, Integer>(this.enchants);
            meta.persistentDataContainer = new PersistentDataContainerMock(this.persistentDataContainer);
            meta.damage = this.damage;
            meta.repairCost = this.repairCost;
            meta.hideFlags = EnumSet.copyOf(this.hideFlags);
            return meta;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasLore() {
        return this.lore != null;
    }

    public List<String> getLore() {
        return new ArrayList<String>(this.lore);
    }

    public void setLore(List<String> lore) {
        this.lore = new ArrayList<String>(lore);
    }

    public void assertLore(List<String> lines) {
        if (this.lore != null && this.lore.size() == lines.size()) {
            for (int i = 0; i < this.lore.size(); ++i) {
                if (!this.lore.get(i).equals(lines.get(i))) {
                    throw new AssertionError((Object)String.format("Line %d should be '%s' but was '%s'", i, lines.get(i), this.lore.get(i)));
                }
            }
        } else {
            if (this.lore != null) {
                throw new AssertionError((Object)String.format("Lore contained %d lines but should contain %d lines", this.lore.size(), lines.size()));
            }
            throw new AssertionError((Object)"No lore was set");
        }
    }

    public void assertLore(String ... lines) {
        this.assertLore(Arrays.asList(lines));
    }

    public void assertHasNoLore() throws AssertionError {
        if (this.lore != null && !this.lore.isEmpty()) {
            throw new AssertionError((Object)"Lore was set but shouldn't have been set");
        }
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.displayName != null) {
            map.put("displayName", this.displayName);
        }
        if (this.lore != null) {
            map.put("lore", this.lore);
        }
        if (this.customModelData != null) {
            map.put("customModelData", this.customModelData);
        }
        map.put("enchants", this.enchants);
        map.put("repairCost", this.repairCost);
        map.put("itemFlags", this.hideFlags);
        map.put("unbreakable", this.unbreakable);
        map.put("damage", this.damage);
        map.put("persistentDataContainer", this.persistentDataContainer.serialize());
        return map;
    }

    public static ItemMetaMock deserialize(Map<String, Object> args) {
        ItemMetaMock serialMock = new ItemMetaMock();
        serialMock.displayName = (String)args.get("displayName");
        serialMock.lore = (List)args.get("lore");
        serialMock.enchants = (Map)args.get("enchants");
        serialMock.hideFlags = (Set)args.get("itemFlags");
        serialMock.unbreakable = (Boolean)args.get("unbreakable");
        serialMock.customModelData = (Integer)args.get("customModelData");
        Map map = (Map)args.get("persistentDataContainer");
        serialMock.persistentDataContainer = PersistentDataContainerMock.deserialize(map);
        serialMock.damage = (Integer)args.get("damage");
        serialMock.repairCost = (Integer)args.get("repairCost");
        return serialMock;
    }

    public boolean hasLocalizedName() {
        throw new UnimplementedOperationException();
    }

    public String getLocalizedName() {
        throw new UnimplementedOperationException();
    }

    public void setLocalizedName(String name) {
        throw new UnimplementedOperationException();
    }

    public boolean hasEnchants() {
        return !this.enchants.isEmpty();
    }

    public boolean hasEnchant(Enchantment ench) {
        return this.enchants.containsKey(ench);
    }

    public int getEnchantLevel(Enchantment ench) {
        return this.hasEnchant(ench) ? this.enchants.get(ench) : 0;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return Collections.unmodifiableMap(this.enchants);
    }

    public boolean addEnchant(Enchantment ench, int level, boolean ignoreLevelRestriction) {
        Integer existingLevel = this.enchants.get(ench);
        if (Objects.nonNull(existingLevel) && existingLevel.equals(level)) {
            return false;
        }
        if (ignoreLevelRestriction || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            this.enchants.put(ench, level);
            return true;
        }
        return false;
    }

    public boolean removeEnchant(Enchantment ench) {
        return Objects.nonNull(this.enchants.remove(ench));
    }

    public boolean hasConflictingEnchant(Enchantment ench) {
        boolean b;
        boolean bl = b = this.hasEnchants() && this.enchants.remove(ench) != null;
        if (this.enchants != null && this.enchants.isEmpty()) {
            this.enchants = null;
        }
        return b;
    }

    public void addItemFlags(ItemFlag ... itemFlags) {
        this.hideFlags.addAll(Arrays.asList(itemFlags));
    }

    public void removeItemFlags(ItemFlag ... itemFlags) {
        this.hideFlags.removeAll(Arrays.asList(itemFlags));
    }

    public Set<ItemFlag> getItemFlags() {
        return Collections.unmodifiableSet(this.hideFlags);
    }

    public boolean hasItemFlag(ItemFlag flag) {
        return this.hideFlags.contains(flag);
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean hasDamage() {
        return this.damage > 0;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    public boolean hasAttributeModifiers() {
        throw new UnimplementedOperationException();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        throw new UnimplementedOperationException();
    }

    public void setAttributeModifiers(Multimap<Attribute, AttributeModifier> attributeModifiers) {
        throw new UnimplementedOperationException();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot) {
        throw new UnimplementedOperationException();
    }

    public Collection<AttributeModifier> getAttributeModifiers(Attribute attribute) {
        throw new UnimplementedOperationException();
    }

    public boolean addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        throw new UnimplementedOperationException();
    }

    public boolean removeAttributeModifier(Attribute attribute) {
        throw new UnimplementedOperationException();
    }

    public boolean removeAttributeModifier(EquipmentSlot slot) {
        throw new UnimplementedOperationException();
    }

    public boolean removeAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        throw new UnimplementedOperationException();
    }

    public CustomItemTagContainer getCustomTagContainer() {
        throw new UnimplementedOperationException();
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public boolean hasCustomModelData() {
        return this.customModelData != null;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public void setCustomModelData(@Nullable Integer data) {
        this.customModelData = data;
    }

    public void setVersion(int version) {
        throw new UnimplementedOperationException();
    }
}

