/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Strings;
import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullMetaMock
extends ItemMetaMock
implements SkullMeta {
    private String owner;

    public SkullMetaMock() {
    }

    public SkullMetaMock(SkullMeta meta) {
        super((ItemMeta)meta);
        this.owner = meta.hasOwner() ? meta.getOwningPlayer().getName() : null;
    }

    @Override
    public SkullMetaMock clone() {
        SkullMetaMock mock = (SkullMetaMock)super.clone();
        mock.setOwner(this.owner);
        return mock;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.owner.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SkullMeta)) {
            return false;
        }
        SkullMeta other = (SkullMeta)obj;
        return Objects.equals(this.owner, other.getOwningPlayer().getName());
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean hasOwner() {
        return !Strings.isNullOrEmpty((String)this.owner);
    }

    public boolean setOwner(String owner) {
        this.owner = owner;
        return true;
    }

    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            return new OfflinePlayerMock(this.owner);
        }
        return null;
    }

    public boolean setOwningPlayer(OfflinePlayer owner) {
        this.owner = owner.getName();
        return true;
    }
}

