/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scheduler;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ScheduledTask
implements BukkitTask {
    private int id;
    private Plugin plugin;
    private boolean isSync;
    private boolean isCancelled = false;
    private long scheduledTick;
    private boolean running;
    private Runnable runnable;
    private List<Runnable> cancelListeners = new LinkedList<Runnable>();

    public ScheduledTask(int id, Plugin plugin, boolean isSync, long scheduledTick, Runnable runnable) {
        this.id = id;
        this.plugin = plugin;
        this.isSync = isSync;
        this.scheduledTick = scheduledTick;
        this.runnable = runnable;
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public long getScheduledTick() {
        return this.scheduledTick;
    }

    protected void setScheduledTick(long scheduledTick) {
        this.scheduledTick = scheduledTick;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public void run() {
        if (this.isCancelled()) {
            throw new CancellationException("Task is cancelled");
        }
        this.runnable.run();
    }

    public int getTaskId() {
        return this.id;
    }

    public Plugin getOwner() {
        return this.plugin;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        this.isCancelled = true;
        this.cancelListeners.forEach(Runnable::run);
    }

    public void addOnCancelled(Runnable callback) {
        this.cancelListeners.add(callback);
    }
}

