/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.BlockMock;
import be.seeseemelk.mockbukkit.block.state.BarrelMock;
import be.seeseemelk.mockbukkit.block.state.ChestMock;
import be.seeseemelk.mockbukkit.block.state.DispenserMock;
import be.seeseemelk.mockbukkit.block.state.DropperMock;
import be.seeseemelk.mockbukkit.block.state.EnderChestMock;
import be.seeseemelk.mockbukkit.block.state.HopperMock;
import be.seeseemelk.mockbukkit.block.state.LecternMock;
import be.seeseemelk.mockbukkit.block.state.ShulkerBoxMock;
import be.seeseemelk.mockbukkit.block.state.SignMock;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BlockStateMock
implements BlockState,
Cloneable {
    private final MetadataTable metadataTable = new MetadataTable();
    private Block block;
    private Material material;

    public BlockStateMock(@NotNull Material material) {
        this.material = material;
    }

    protected BlockStateMock(@NotNull Block block) {
        this.block = block;
        this.material = block.getType();
    }

    protected BlockStateMock(@NotNull BlockStateMock state) {
        this.material = state.getType();
        this.block = state.isPlaced() ? state.getBlock() : null;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.metadataTable.getMetadata(metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.metadataTable.hasMetadata(metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    public Block getBlock() {
        if (this.block == null) {
            throw new IllegalStateException("This BlockState has not been placed!");
        }
        return this.block;
    }

    @Deprecated
    public MaterialData getData() {
        return new MaterialData(this.material);
    }

    public Material getType() {
        return this.material;
    }

    public byte getLightLevel() {
        return this.getBlock().getLightLevel();
    }

    public World getWorld() {
        return this.getBlock().getWorld();
    }

    public int getX() {
        return this.getBlock().getX();
    }

    public int getY() {
        return this.getBlock().getY();
    }

    public int getZ() {
        return this.getBlock().getZ();
    }

    public Location getLocation() {
        return this.getBlock().getLocation();
    }

    public Location getLocation(Location loc) {
        return this.getBlock().getLocation(loc);
    }

    public Chunk getChunk() {
        return this.getBlock().getChunk();
    }

    @Deprecated
    public void setData(@NotNull MaterialData data) {
        this.material = data.getItemType();
    }

    public void setType(Material type) {
        this.material = type;
    }

    public boolean update() {
        return this.update(false);
    }

    public boolean update(boolean force) {
        return this.update(force, true);
    }

    public boolean update(boolean force, boolean applyPhysics) {
        if (!this.isPlaced()) {
            return true;
        }
        Block b = this.getBlock();
        if (b instanceof BlockMock && (force || b.getType() == this.material)) {
            ((BlockMock)b).setState(this);
            return true;
        }
        return false;
    }

    @Deprecated
    public byte getRawData() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setRawData(byte data) {
        throw new UnimplementedOperationException();
    }

    public boolean isPlaced() {
        return this.block != null;
    }

    public BlockData getBlockData() {
        throw new UnimplementedOperationException();
    }

    public void setBlockData(BlockData data) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockState getSnapshot() {
        return new BlockStateMock(this);
    }

    @NotNull
    public static BlockStateMock mockState(@NotNull Block block) {
        switch (block.getType()) {
            case LECTERN: {
                return new LecternMock(block);
            }
            case HOPPER: {
                return new HopperMock(block);
            }
            case BARREL: {
                return new BarrelMock(block);
            }
            case DISPENSER: {
                return new DispenserMock(block);
            }
            case DROPPER: {
                return new DropperMock(block);
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                return new ChestMock(block);
            }
            case ENDER_CHEST: {
                return new EnderChestMock(block);
            }
            case ACACIA_SIGN: 
            case ACACIA_WALL_SIGN: 
            case BIRCH_SIGN: 
            case BIRCH_WALL_SIGN: 
            case CRIMSON_SIGN: 
            case CRIMSON_WALL_SIGN: 
            case DARK_OAK_SIGN: 
            case DARK_OAK_WALL_SIGN: 
            case JUNGLE_SIGN: 
            case JUNGLE_WALL_SIGN: 
            case OAK_SIGN: 
            case OAK_WALL_SIGN: 
            case SPRUCE_SIGN: 
            case SPRUCE_WALL_SIGN: 
            case WARPED_SIGN: 
            case WARPED_WALL_SIGN: {
                return new SignMock(block);
            }
            case SHULKER_BOX: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: {
                return new ShulkerBoxMock(block);
            }
        }
        return new BlockStateMock(block);
    }
}

