/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.UnsafeValues;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;

public class MockUnsafeValues
implements UnsafeValues {
    private final Set<String> compatibleApiVersions = new HashSet<String>(Arrays.asList("1.13", "1.14", "1.15", "1.16", "1.17", "1.18"));

    public Material toLegacy(Material material) {
        if (material.isLegacy()) {
            return material;
        }
        throw new UnimplementedOperationException();
    }

    public Material fromLegacy(Material material) {
        return material;
    }

    public Material fromLegacy(MaterialData material) {
        throw new UnimplementedOperationException();
    }

    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        throw new UnimplementedOperationException();
    }

    public BlockData fromLegacy(Material material, byte data) {
        throw new UnimplementedOperationException();
    }

    public int getDataVersion() {
        return 1;
    }

    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        throw new UnimplementedOperationException();
    }

    public void checkSupported(PluginDescriptionFile pdf) throws InvalidPluginException {
        if (pdf.getAPIVersion() == null) {
            throw new InvalidPluginException("Plugin does not specify 'api-version' in plugin.yml");
        }
        if (!this.compatibleApiVersions.contains(pdf.getAPIVersion())) {
            throw new InvalidPluginException(String.format("Plugin api version %s is incompatible with the current MockBukkit version", pdf.getAPIVersion()));
        }
    }

    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        return clazz;
    }

    public Advancement loadAdvancement(NamespacedKey key, String advancement) {
        throw new UnimplementedOperationException();
    }

    public boolean removeAdvancement(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Material material, EquipmentSlot slot) {
        throw new UnimplementedOperationException();
    }

    public Material getMaterial(String material, int version) {
        throw new UnimplementedOperationException();
    }
}

