/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.MockChunkData;
import be.seeseemelk.mockbukkit.MockPlayerList;
import be.seeseemelk.mockbukkit.MockUnsafeValues;
import be.seeseemelk.mockbukkit.ThreadAccessException;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.boss.BossBarMock;
import be.seeseemelk.mockbukkit.boss.KeyedBossBarMock;
import be.seeseemelk.mockbukkit.command.CommandResult;
import be.seeseemelk.mockbukkit.command.ConsoleCommandSenderMock;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import be.seeseemelk.mockbukkit.command.MockCommandMap;
import be.seeseemelk.mockbukkit.enchantments.EnchantmentsMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMockFactory;
import be.seeseemelk.mockbukkit.help.HelpMapMock;
import be.seeseemelk.mockbukkit.inventory.BarrelInventoryMock;
import be.seeseemelk.mockbukkit.inventory.ChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.DispenserInventoryMock;
import be.seeseemelk.mockbukkit.inventory.DropperInventoryMock;
import be.seeseemelk.mockbukkit.inventory.EnderChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.HopperInventoryMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import be.seeseemelk.mockbukkit.inventory.ItemFactoryMock;
import be.seeseemelk.mockbukkit.inventory.LecternInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.ShulkerBoxInventoryMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import be.seeseemelk.mockbukkit.plugin.PluginManagerMock;
import be.seeseemelk.mockbukkit.potion.MockPotionEffectType;
import be.seeseemelk.mockbukkit.scheduler.BukkitSchedulerMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardManagerMock;
import be.seeseemelk.mockbukkit.services.ServicesManagerMock;
import be.seeseemelk.mockbukkit.tags.TagRegistry;
import be.seeseemelk.mockbukkit.tags.TagWrapperMock;
import be.seeseemelk.mockbukkit.tags.TagsMock;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.CachedServerIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerMock
extends Server.Spigot
implements Server {
    private static final String BUKKIT_VERSION = "1.17.1";
    private static final String JOIN_MESSAGE = "%s has joined the server.";
    private static final String MOTD = "A Minecraft Server";
    private final Logger logger = Logger.getLogger("ServerMock");
    private final Thread mainThread = Thread.currentThread();
    private final MockUnsafeValues unsafe = new MockUnsafeValues();
    private final Map<String, TagRegistry> materialTags = new HashMap<String, TagRegistry>();
    private final Set<EntityMock> entities = new HashSet<EntityMock>();
    private final List<World> worlds = new ArrayList<World>();
    private final List<Recipe> recipes = new LinkedList<Recipe>();
    private final Map<NamespacedKey, KeyedBossBarMock> bossBars = new HashMap<NamespacedKey, KeyedBossBarMock>();
    private final ItemFactory factory = new ItemFactoryMock();
    private final PlayerMockFactory playerFactory = new PlayerMockFactory(this);
    private final PluginManagerMock pluginManager = new PluginManagerMock(this);
    private final ScoreboardManagerMock scoreboardManager = new ScoreboardManagerMock();
    private final BukkitSchedulerMock scheduler = new BukkitSchedulerMock();
    private final ServicesManagerMock servicesManager = new ServicesManagerMock();
    private final MockPlayerList playerList = new MockPlayerList();
    private final MockCommandMap commandMap = new MockCommandMap(this);
    private final HelpMapMock helpMap = new HelpMapMock();
    private GameMode defaultGameMode = GameMode.SURVIVAL;
    private ConsoleCommandSender consoleSender;
    private int spawnRadius = 16;

    public ServerMock() {
        ServerMock.registerSerializables();
        this.createPotionEffectTypes();
        TagsMock.loadDefaultTags(this, true);
        EnchantmentsMock.registerDefaultEnchantments();
        try {
            InputStream stream = ClassLoader.getSystemResourceAsStream("logger.properties");
            LogManager.getLogManager().readConfiguration(stream);
        }
        catch (IOException e) {
            this.logger.warning("Could not load file logger.properties");
        }
        this.logger.setLevel(Level.ALL);
    }

    public boolean isOnMainThread() {
        return this.mainThread.equals(Thread.currentThread());
    }

    public void assertMainThread() {
        if (!this.isOnMainThread()) {
            throw new ThreadAccessException("The Bukkit API was accessed from asynchronous code.");
        }
    }

    public void registerEntity(@NotNull EntityMock entity) {
        this.assertMainThread();
        this.entities.add(entity);
    }

    @NotNull
    public Set<EntityMock> getEntities() {
        return Collections.unmodifiableSet(this.entities);
    }

    public void addPlayer(PlayerMock player) {
        this.assertMainThread();
        this.playerList.addPlayer(player);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)player, String.format(JOIN_MESSAGE, player.getDisplayName()));
        Bukkit.getPluginManager().callEvent((Event)playerJoinEvent);
        player.setLastPlayed(this.getCurrentServerTime());
        this.registerEntity(player);
    }

    public PlayerMock addPlayer() {
        this.assertMainThread();
        PlayerMock player = this.playerFactory.createRandomPlayer();
        this.addPlayer(player);
        return player;
    }

    public PlayerMock addPlayer(String name) {
        this.assertMainThread();
        PlayerMock player = new PlayerMock(this, name);
        this.addPlayer(player);
        return player;
    }

    public void setPlayers(int num) {
        this.assertMainThread();
        this.playerList.clearOnlinePlayers();
        for (int i = 0; i < num; ++i) {
            this.addPlayer();
        }
    }

    public void setOfflinePlayers(int num) {
        this.assertMainThread();
        this.playerList.clearOfflinePlayers();
        for (PlayerMock playerMock : this.getOnlinePlayers()) {
            this.playerList.addPlayer(playerMock);
        }
        for (int i = 0; i < num; ++i) {
            OfflinePlayerMock offlinePlayerMock = this.playerFactory.createRandomOfflinePlayer();
            this.playerList.addOfflinePlayer(offlinePlayerMock);
        }
    }

    public PlayerMock getPlayer(int num) {
        return this.playerList.getPlayer(num);
    }

    public WorldMock addSimpleWorld(String name) {
        this.assertMainThread();
        WorldMock world = new WorldMock();
        world.setName(name);
        this.worlds.add(world);
        return world;
    }

    public void addWorld(WorldMock world) {
        this.assertMainThread();
        this.worlds.add(world);
    }

    public CommandResult executeConsole(Command command, String ... args) {
        this.assertMainThread();
        return this.execute(command, (CommandSender)this.getConsoleSender(), args);
    }

    public CommandResult executeConsole(String command, String ... args) {
        this.assertMainThread();
        return this.executeConsole(this.getCommandMap().getCommand(command), args);
    }

    public CommandResult executePlayer(Command command, String ... args) {
        this.assertMainThread();
        if (this.playerList.isSomeoneOnline()) {
            return this.execute(command, (CommandSender)this.getPlayer(0), args);
        }
        throw new IllegalStateException("Need at least one player to run the command");
    }

    public CommandResult executePlayer(String command, String ... args) {
        this.assertMainThread();
        return this.executePlayer(this.getCommandMap().getCommand(command), args);
    }

    public CommandResult execute(Command command, CommandSender sender, String ... args) {
        this.assertMainThread();
        if (!(sender instanceof MessageTarget)) {
            throw new IllegalArgumentException("Only a MessageTarget can be the sender of the command");
        }
        boolean status = command.execute(sender, command.getName(), args);
        return new CommandResult(status, (MessageTarget)sender);
    }

    public CommandResult execute(String command, CommandSender sender, String ... args) {
        this.assertMainThread();
        return this.execute(this.getCommandMap().getCommand(command), sender, args);
    }

    public String getName() {
        return "ServerMock";
    }

    public String getVersion() {
        return String.format("MockBukkit (MC: %s)", BUKKIT_VERSION);
    }

    public String getBukkitVersion() {
        return BUKKIT_VERSION;
    }

    public Collection<? extends PlayerMock> getOnlinePlayers() {
        return this.playerList.getOnlinePlayers();
    }

    public OfflinePlayer[] getOfflinePlayers() {
        return this.playerList.getOfflinePlayers();
    }

    public Player getPlayer(String name) {
        return this.playerList.getPlayer(name);
    }

    public Player getPlayerExact(String name) {
        return this.playerList.getPlayerExact(name);
    }

    public List<Player> matchPlayer(String name) {
        return this.playerList.matchPlayer(name);
    }

    public Player getPlayer(UUID id) {
        return this.playerList.getPlayer(id);
    }

    public PluginManagerMock getPluginManager() {
        return this.pluginManager;
    }

    @NotNull
    public MockCommandMap getCommandMap() {
        return this.commandMap;
    }

    public PluginCommand getPluginCommand(String name) {
        this.assertMainThread();
        Command command = this.getCommandMap().getCommand(name);
        return command instanceof PluginCommand ? (PluginCommand)command : null;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ConsoleCommandSender getConsoleSender() {
        if (this.consoleSender == null) {
            this.consoleSender = new ConsoleCommandSenderMock();
        }
        return this.consoleSender;
    }

    @NotNull
    public InventoryMock createInventory(InventoryHolder owner, InventoryType type, String title, int size) {
        this.assertMainThread();
        if (!type.isCreatable()) {
            throw new IllegalArgumentException("Inventory Type is not creatable!");
        }
        switch (type) {
            case CHEST: {
                return new ChestInventoryMock(owner, size > 0 ? size : 27);
            }
            case DISPENSER: {
                return new DispenserInventoryMock(owner);
            }
            case DROPPER: {
                return new DropperInventoryMock(owner);
            }
            case PLAYER: {
                if (owner instanceof HumanEntity) {
                    return new PlayerInventoryMock((HumanEntity)owner);
                }
                throw new IllegalArgumentException("Cannot create a Player Inventory for: " + owner);
            }
            case ENDER_CHEST: {
                return new EnderChestInventoryMock(owner);
            }
            case HOPPER: {
                return new HopperInventoryMock(owner);
            }
            case SHULKER_BOX: {
                return new ShulkerBoxInventoryMock(owner);
            }
            case BARREL: {
                return new BarrelInventoryMock(owner);
            }
            case LECTERN: {
                return new LecternInventoryMock(owner);
            }
        }
        throw new UnimplementedOperationException("Inventory type not yet supported");
    }

    public InventoryMock createInventory(InventoryHolder owner, InventoryType type) {
        return this.createInventory(owner, type, "Inventory");
    }

    public InventoryMock createInventory(InventoryHolder owner, InventoryType type, String title) {
        return this.createInventory(owner, type, title, -1);
    }

    public InventoryMock createInventory(InventoryHolder owner, int size) {
        return this.createInventory(owner, size, "Inventory");
    }

    public InventoryMock createInventory(InventoryHolder owner, int size, String title) {
        return this.createInventory(owner, InventoryType.CHEST, title, size);
    }

    public ItemFactory getItemFactory() {
        return this.factory;
    }

    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds);
    }

    public World getWorld(String name) {
        return this.worlds.stream().filter(world -> world.getName().equals(name)).findAny().orElse(null);
    }

    public World getWorld(UUID uid) {
        return this.worlds.stream().filter(world -> world.getUID().equals(uid)).findAny().orElse(null);
    }

    public BukkitSchedulerMock getScheduler() {
        return this.scheduler;
    }

    public int getMaxPlayers() {
        return this.playerList.getMaxPlayers();
    }

    public Set<String> getIPBans() {
        return this.playerList.getIPBans().getBanEntries().stream().map(BanEntry::getTarget).collect(Collectors.toSet());
    }

    public void banIP(String address) {
        this.assertMainThread();
        this.playerList.getIPBans().addBan(address, null, null, null);
    }

    public void unbanIP(String address) {
        this.assertMainThread();
        this.playerList.getIPBans().pardon(address);
    }

    public BanList getBanList(BanList.Type type) {
        switch (type) {
            case IP: {
                return this.playerList.getIPBans();
            }
        }
        return this.playerList.getProfileBans();
    }

    public Set<OfflinePlayer> getOperators() {
        return this.playerList.getOperators();
    }

    public GameMode getDefaultGameMode() {
        return this.defaultGameMode;
    }

    public void setDefaultGameMode(GameMode mode) {
        this.assertMainThread();
        this.defaultGameMode = mode;
    }

    public int broadcastMessage(String message) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        for (Player player : players) {
            player.sendMessage(message);
        }
        return players.size();
    }

    public int broadcast(String message, String permission) {
        Collection<? extends PlayerMock> players = this.getOnlinePlayers();
        int count = 0;
        for (Player player : players) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
            ++count;
        }
        return count;
    }

    public static void registerSerializables() {
        ConfigurationSerialization.registerClass(ItemMetaMock.class);
    }

    public boolean addRecipe(Recipe recipe) {
        this.assertMainThread();
        this.recipes.add(recipe);
        return true;
    }

    public List<Recipe> getRecipesFor(@NotNull ItemStack item) {
        this.assertMainThread();
        return this.recipes.stream().filter(recipe -> {
            ItemStack result = recipe.getResult();
            return result.getType() == item.getType() && result.getItemMeta().equals(item.getItemMeta());
        }).collect(Collectors.toList());
    }

    public Recipe getRecipe(NamespacedKey key) {
        this.assertMainThread();
        for (Recipe recipe : this.recipes) {
            if (!(recipe instanceof Keyed) || !((Keyed)recipe).getKey().equals((Object)key)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public Recipe getCraftingRecipe(@NotNull ItemStack[] craftingMatrix, @NotNull World world) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack craftItem(@NotNull ItemStack[] craftingMatrix, @NotNull World world, @NotNull Player player) {
        throw new UnimplementedOperationException();
    }

    public boolean removeRecipe(NamespacedKey key) {
        this.assertMainThread();
        Iterator<Recipe> iterator = this.recipeIterator();
        while (iterator.hasNext()) {
            Recipe recipe = iterator.next();
            if (!(recipe instanceof Keyed) || !((Keyed)recipe).getKey().equals((Object)key)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public Iterator<Recipe> recipeIterator() {
        this.assertMainThread();
        return this.recipes.iterator();
    }

    public void clearRecipes() {
        this.assertMainThread();
        this.recipes.clear();
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        this.assertMainThread();
        String[] commands = commandLine.split(" ");
        String commandLabel = commands[0];
        String[] args = Arrays.copyOfRange(commands, 1, commands.length);
        Command command = this.getCommandMap().getCommand(commandLabel);
        if (command != null) {
            return command.execute(sender, commandLabel, args);
        }
        return false;
    }

    public HelpMapMock getHelpMap() {
        return this.helpMap;
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        throw new UnimplementedOperationException();
    }

    public Set<String> getListeningPluginChannels() {
        throw new UnimplementedOperationException();
    }

    public int getPort() {
        throw new UnimplementedOperationException();
    }

    public int getViewDistance() {
        throw new UnimplementedOperationException();
    }

    public String getIp() {
        throw new UnimplementedOperationException();
    }

    public String getWorldType() {
        throw new UnimplementedOperationException();
    }

    public boolean getGenerateStructures() {
        throw new UnimplementedOperationException();
    }

    public boolean getAllowEnd() {
        throw new UnimplementedOperationException();
    }

    public boolean getAllowNether() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getResourcePack() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getResourcePackHash() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getResourcePackPrompt() {
        throw new UnimplementedOperationException();
    }

    public boolean isResourcePackRequired() {
        throw new UnimplementedOperationException();
    }

    public boolean hasWhitelist() {
        throw new UnimplementedOperationException();
    }

    public void setWhitelist(boolean value) {
        throw new UnimplementedOperationException();
    }

    public boolean isWhitelistEnforced() {
        throw new UnimplementedOperationException();
    }

    public void setWhitelistEnforced(boolean value) {
        throw new UnimplementedOperationException();
    }

    public Set<OfflinePlayer> getWhitelistedPlayers() {
        throw new UnimplementedOperationException();
    }

    public void reloadWhitelist() {
        throw new UnimplementedOperationException();
    }

    public String getUpdateFolder() {
        throw new UnimplementedOperationException();
    }

    public File getUpdateFolderFile() {
        throw new UnimplementedOperationException();
    }

    public long getConnectionThrottle() {
        throw new UnimplementedOperationException();
    }

    public int getTicksPerAnimalSpawns() {
        throw new UnimplementedOperationException();
    }

    public int getTicksPerMonsterSpawns() {
        throw new UnimplementedOperationException();
    }

    public ServicesManagerMock getServicesManager() {
        return this.servicesManager;
    }

    public World createWorld(WorldCreator creator) {
        WorldMock world = new WorldMock(creator);
        this.addWorld(world);
        return world;
    }

    public boolean unloadWorld(String name, boolean save) {
        throw new UnimplementedOperationException();
    }

    public boolean unloadWorld(World world, boolean save) {
        throw new UnimplementedOperationException();
    }

    public MapView createMap(World world) {
        throw new UnimplementedOperationException();
    }

    public void reload() {
        throw new UnimplementedOperationException();
    }

    public void reloadData() {
        throw new UnimplementedOperationException();
    }

    public void savePlayers() {
        throw new UnimplementedOperationException();
    }

    public void resetRecipes() {
        throw new UnimplementedOperationException();
    }

    public Map<String, String[]> getCommandAliases() {
        throw new UnimplementedOperationException();
    }

    public int getSpawnRadius() {
        return this.spawnRadius;
    }

    public void setSpawnRadius(int spawnRadius) {
        this.spawnRadius = spawnRadius;
    }

    public boolean getOnlineMode() {
        throw new UnimplementedOperationException();
    }

    public boolean getAllowFlight() {
        throw new UnimplementedOperationException();
    }

    public boolean isHardcore() {
        throw new UnimplementedOperationException();
    }

    public void shutdown() {
        throw new UnimplementedOperationException();
    }

    public OfflinePlayer getOfflinePlayer(String name) {
        return this.playerList.getOfflinePlayer(name);
    }

    public OfflinePlayer getOfflinePlayer(UUID id) {
        OfflinePlayer player = this.playerList.getOfflinePlayer(id);
        if (player != null) {
            return player;
        }
        return this.playerFactory.createOfflinePlayer(id);
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        throw new UnimplementedOperationException();
    }

    public File getWorldContainer() {
        throw new UnimplementedOperationException();
    }

    public Messenger getMessenger() {
        throw new UnimplementedOperationException();
    }

    public Merchant createMerchant(String title) {
        throw new UnimplementedOperationException();
    }

    public int getMonsterSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public int getAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public int getWaterAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public int getAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public boolean isPrimaryThread() {
        return this.isOnMainThread();
    }

    public String getMotd() {
        return MOTD;
    }

    public String getShutdownMessage() {
        throw new UnimplementedOperationException();
    }

    public Warning.WarningState getWarningState() {
        throw new UnimplementedOperationException();
    }

    public ScoreboardManagerMock getScoreboardManager() {
        return this.scoreboardManager;
    }

    public CachedServerIcon getServerIcon() {
        throw new UnimplementedOperationException();
    }

    public CachedServerIcon loadServerIcon(File file) {
        throw new UnimplementedOperationException();
    }

    public CachedServerIcon loadServerIcon(BufferedImage image) {
        throw new UnimplementedOperationException();
    }

    public void setIdleTimeout(int threshold) {
        throw new UnimplementedOperationException();
    }

    public int getIdleTimeout() {
        throw new UnimplementedOperationException();
    }

    public ChunkGenerator.ChunkData createChunkData(World world) {
        return new MockChunkData(world);
    }

    public BossBar createBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        return new BossBarMock(title, color, style, flags);
    }

    public Entity getEntity(UUID uuid) {
        throw new UnimplementedOperationException();
    }

    public Advancement getAdvancement(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    public Iterator<Advancement> advancementIterator() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public MockUnsafeValues getUnsafe() {
        return this.unsafe;
    }

    public BlockData createBlockData(Material material) {
        throw new UnimplementedOperationException();
    }

    public BlockData createBlockData(Material material, Consumer<BlockData> consumer) {
        throw new UnimplementedOperationException();
    }

    public BlockData createBlockData(String data) {
        throw new UnimplementedOperationException();
    }

    public BlockData createBlockData(Material material, String data) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Tag<Material> createMaterialTag(@NotNull NamespacedKey key, @NotNull String registryKey, Material ... materials) {
        Validate.notNull((Object)key, (String)"A NamespacedKey must never be null");
        TagRegistry registry = this.materialTags.get(registryKey);
        TagWrapperMock tag = new TagWrapperMock(registry, key);
        registry.getTags().put(key, tag);
        return tag;
    }

    public void addTagRegistry(@NotNull TagRegistry registry) {
        this.materialTags.put(registry.getRegistry(), registry);
    }

    public <T extends Keyed> Tag<T> getTag(String registryKey, NamespacedKey key, Class<T> clazz) {
        Tag tag;
        TagRegistry registry;
        if (clazz == Material.class && (registry = this.materialTags.get(registryKey)) != null && (tag = (Tag)registry.getTags().get(key)) != null) {
            return tag;
        }
        return null;
    }

    private void createPotionEffectTypes() {
        for (PotionEffectType type : PotionEffectType.values()) {
            if (type == null) continue;
            return;
        }
        this.registerPotionEffectType(1, "SPEED", false, 8171462);
        this.registerPotionEffectType(2, "SLOWNESS", false, 5926017);
        this.registerPotionEffectType(3, "HASTE", false, 14270531);
        this.registerPotionEffectType(4, "MINING_FATIGUE", false, 4866583);
        this.registerPotionEffectType(5, "STRENGTH", false, 9643043);
        this.registerPotionEffectType(6, "INSTANT_HEALTH", true, 16262179);
        this.registerPotionEffectType(7, "INSTANT_DAMAGE", true, 4393481);
        this.registerPotionEffectType(8, "JUMP_BOOST", false, 2293580);
        this.registerPotionEffectType(9, "NAUSEA", false, 5578058);
        this.registerPotionEffectType(10, "REGENERATION", false, 13458603);
        this.registerPotionEffectType(11, "RESISTANCE", false, 10044730);
        this.registerPotionEffectType(12, "FIRE_RESISTANCE", false, 14981690);
        this.registerPotionEffectType(13, "WATER_BREATHING", false, 3035801);
        this.registerPotionEffectType(14, "INVISIBILITY", false, 8356754);
        this.registerPotionEffectType(15, "BLINDNESS", false, 2039587);
        this.registerPotionEffectType(16, "NIGHT_VISION", false, 0x1F1FA1);
        this.registerPotionEffectType(17, "HUNGER", false, 5797459);
        this.registerPotionEffectType(18, "WEAKNESS", false, 0x484D48);
        this.registerPotionEffectType(19, "POISON", false, 5149489);
        this.registerPotionEffectType(20, "WITHER", false, 3484199);
        this.registerPotionEffectType(21, "HEALTH_BOOST", false, 16284963);
        this.registerPotionEffectType(22, "ABSORPTION", false, 0x2552A5);
        this.registerPotionEffectType(23, "SATURATION", true, 16262179);
        this.registerPotionEffectType(24, "GLOWING", false, 9740385);
        this.registerPotionEffectType(25, "LEVITATION", false, 0xCEFFFF);
        this.registerPotionEffectType(26, "LUCK", false, 0x339900);
        this.registerPotionEffectType(27, "UNLUCK", false, 12624973);
        this.registerPotionEffectType(28, "SLOW_FALLING", false, 16773073);
        this.registerPotionEffectType(29, "CONDUIT_POWER", false, 1950417);
        this.registerPotionEffectType(30, "DOLPHINS_GRACE", false, 8954814);
        this.registerPotionEffectType(31, "BAD_OMEN", false, 745784);
        this.registerPotionEffectType(32, "HERO_OF_THE_VILLAGE", false, 45217);
        PotionEffectType.stopAcceptingRegistrations();
    }

    private void registerPotionEffectType(int id, @NotNull String name, boolean instant, int rgb) {
        NamespacedKey key = NamespacedKey.minecraft((String)name.toLowerCase(Locale.ROOT));
        MockPotionEffectType type = new MockPotionEffectType(key, id, name, instant, Color.fromRGB((int)rgb));
        PotionEffectType.registerPotionEffectType((PotionEffectType)type);
    }

    public LootTable getLootTable(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        throw new UnimplementedOperationException();
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    public KeyedBossBar createBossBar(NamespacedKey key, String title, BarColor color, BarStyle style, BarFlag ... flags) {
        Validate.notNull((Object)key, (String)"A NamespacedKey must never be null");
        KeyedBossBarMock bar = new KeyedBossBarMock(key, title, color, style, flags);
        this.bossBars.put(key, bar);
        return bar;
    }

    public Iterator<KeyedBossBar> getBossBars() {
        return this.bossBars.values().stream().map(bossbar -> bossbar).iterator();
    }

    public KeyedBossBar getBossBar(NamespacedKey key) {
        Validate.notNull((Object)key, (String)"A NamespacedKey must never be null");
        return this.bossBars.get(key);
    }

    public boolean removeBossBar(NamespacedKey key) {
        Validate.notNull((Object)key, (String)"A NamespacedKey must never be null");
        return this.bossBars.remove(key, this.bossBars.get(key));
    }

    public List<Entity> selectEntities(CommandSender sender, String selector) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public StructureManager getStructureManager() {
        throw new UnimplementedOperationException();
    }

    public MapView getMap(int id) {
        throw new UnimplementedOperationException();
    }

    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        throw new UnimplementedOperationException();
    }

    public int getTicksPerWaterSpawns() {
        throw new UnimplementedOperationException();
    }

    public int getTicksPerAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    protected long getCurrentServerTime() {
        return System.currentTimeMillis();
    }

    public int getTicksPerWaterAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    public int getTicksPerWaterUndergroundCreatureSpawns() {
        throw new UnimplementedOperationException();
    }

    public int getWaterAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public int getWaterUndergroundCreatureSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public int getMaxWorldSize() {
        throw new UnimplementedOperationException();
    }

    public int getSimulationDistance() {
        throw new UnimplementedOperationException();
    }

    public boolean getHideOnlinePlayers() {
        throw new UnimplementedOperationException();
    }

    public Server.Spigot spigot() {
        return this;
    }

    @NotNull
    public YamlConfiguration getConfig() {
        throw new UnimplementedOperationException();
    }

    public void broadcast(@NotNull BaseComponent component) {
        for (Player player : this.getOnlinePlayers()) {
            player.spigot().sendMessage(component);
        }
    }

    public void broadcast(BaseComponent ... components) {
        for (Player player : this.getOnlinePlayers()) {
            player.spigot().sendMessage(components);
        }
    }

    public void restart() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getTicksPerSpawns(@NotNull SpawnCategory spawnCategory) {
        throw new UnimplementedOperationException();
    }

    public PlayerProfile createPlayerProfile(@Nullable UUID uniqueId, @Nullable String name) {
        throw new UnimplementedOperationException();
    }

    public PlayerProfile createPlayerProfile(@NotNull UUID uniqueId) {
        throw new UnimplementedOperationException();
    }

    public PlayerProfile createPlayerProfile(@NotNull String name) {
        throw new UnimplementedOperationException();
    }

    public int getSpawnLimit(@NotNull SpawnCategory spawnCategory) {
        throw new UnimplementedOperationException();
    }
}

