/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.LivingEntityMock;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityEquipmentMock
implements EntityEquipment {
    private final LivingEntityMock holder;
    private ItemStack itemInMainHand = new ItemStack(Material.AIR);
    private ItemStack itemInOffHand = new ItemStack(Material.AIR);
    private ItemStack helmet = new ItemStack(Material.AIR);
    private ItemStack chestPlate = new ItemStack(Material.AIR);
    private ItemStack leggings = new ItemStack(Material.AIR);
    private ItemStack boots = new ItemStack(Material.AIR);

    public EntityEquipmentMock(@NotNull LivingEntityMock holder) {
        this.holder = holder;
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        this.setItem(slot, item, false);
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item, boolean silent) {
        switch (slot) {
            case HEAD: {
                this.setHelmet(item, silent);
                break;
            }
            case CHEST: {
                this.setChestplate(item, silent);
                break;
            }
            case LEGS: {
                this.setLeggings(item, silent);
                break;
            }
            case FEET: {
                this.setBoots(item, silent);
                break;
            }
            case HAND: {
                this.setItemInMainHand(item, silent);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item, silent);
                break;
            }
            default: {
                throw new UnimplementedOperationException("EquipmentSlot '" + slot + "' has no implementation!");
            }
        }
    }

    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> this.getChestplate();
            case EquipmentSlot.FEET -> this.getBoots();
            case EquipmentSlot.HAND -> this.getItemInMainHand();
            case EquipmentSlot.HEAD -> this.getHelmet();
            case EquipmentSlot.LEGS -> this.getLeggings();
            case EquipmentSlot.OFF_HAND -> this.getItemInOffHand();
            default -> throw new UnimplementedOperationException("EquipmentSlot '" + slot + "' has no implementation!");
        };
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        return this.itemInMainHand;
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.itemInMainHand = item;
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        return this.itemInOffHand;
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.itemInOffHand = item;
    }

    @Deprecated
    @NotNull
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Deprecated
    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public void setHelmet(ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    public void setHelmet(ItemStack helmet, boolean silent) {
        this.helmet = helmet;
    }

    public ItemStack getChestplate() {
        return this.chestPlate;
    }

    public void setChestplate(ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.chestPlate = chestplate;
    }

    public ItemStack getLeggings() {
        return this.leggings;
    }

    public void setLeggings(ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    public void setLeggings(ItemStack leggings, boolean silent) {
        this.leggings = leggings;
    }

    public ItemStack getBoots() {
        return this.boots;
    }

    public void setBoots(ItemStack boots) {
        this.setBoots(boots, false);
    }

    public void setBoots(ItemStack boots, boolean silent) {
        this.boots = boots;
    }

    public ItemStack[] getArmorContents() {
        return new ItemStack[]{this.getBoots(), this.getLeggings(), this.getChestplate(), this.getHelmet()};
    }

    public void setArmorContents(@NotNull ItemStack[] items) {
        Validate.notNull((Object)items, (String)"The provided items must not be null.");
        this.setBoots(items.length >= 1 ? items[0] : null);
        this.setLeggings(items.length >= 2 ? items[1] : null);
        this.setChestplate(items.length >= 3 ? items[2] : null);
        this.setHelmet(items.length >= 4 ? items[3] : null);
    }

    public void clear() {
        this.setItemInMainHand(null);
        this.setItemInOffHand(null);
        this.setHelmet(null);
        this.setChestplate(null);
        this.setLeggings(null);
        this.setBoots(null);
    }

    public float getItemInHandDropChance() {
        throw new UnimplementedOperationException();
    }

    public void setItemInHandDropChance(float chance) {
        throw new UnimplementedOperationException();
    }

    public float getItemInMainHandDropChance() {
        throw new UnimplementedOperationException();
    }

    public void setItemInMainHandDropChance(float chance) {
        throw new UnimplementedOperationException();
    }

    public float getItemInOffHandDropChance() {
        throw new UnimplementedOperationException();
    }

    public void setItemInOffHandDropChance(float chance) {
        throw new UnimplementedOperationException();
    }

    public float getHelmetDropChance() {
        throw new UnimplementedOperationException();
    }

    public void setHelmetDropChance(float chance) {
        throw new UnimplementedOperationException();
    }

    public float getChestplateDropChance() {
        throw new UnimplementedOperationException();
    }

    public void setChestplateDropChance(float chance) {
        throw new UnimplementedOperationException();
    }

    public float getLeggingsDropChance() {
        throw new UnimplementedOperationException();
    }

    public void setLeggingsDropChance(float chance) {
        throw new UnimplementedOperationException();
    }

    public float getBootsDropChance() {
        throw new UnimplementedOperationException();
    }

    public void setBootsDropChance(float chance) {
        throw new UnimplementedOperationException();
    }

    public Entity getHolder() {
        return this.holder;
    }
}

