/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.persistence;

import be.seeseemelk.mockbukkit.persistence.PersistentDataAdapterContextMock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentDataContainerMock
implements PersistentDataContainer {
    private final PersistentDataAdapterContext context = new PersistentDataAdapterContextMock();
    private final Map<NamespacedKey, Object> map;

    public PersistentDataContainerMock() {
        this.map = new HashMap<NamespacedKey, Object>();
    }

    public PersistentDataContainerMock(PersistentDataContainerMock mock) {
        this.map = new HashMap<NamespacedKey, Object>(mock.map);
    }

    public int hashCode() {
        int hashCode = 3;
        return hashCode += this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PersistentDataContainerMock)) {
            return false;
        }
        return this.map.equals(((PersistentDataContainerMock)obj).map);
    }

    @Nullable
    public <T, Z> Z get(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
        Object value = this.map.get(key);
        if (value == null || !type.getPrimitiveType().isInstance(value)) {
            return null;
        }
        return (Z)type.fromPrimitive(type.getPrimitiveType().cast(value), this.context);
    }

    public <T, Z> void set(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z value) {
        this.map.put(key, type.toPrimitive(value, this.context));
    }

    public <T, Z> boolean has(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
        Object value = this.map.get(key);
        return value != null && type.getPrimitiveType().isInstance(value);
    }

    @NotNull
    public PersistentDataAdapterContext getAdapterContext() {
        return this.context;
    }

    @NotNull
    public <T, Z> Z getOrDefault(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z defaultValue) {
        Z value = this.get(key, type);
        return value != null ? value : defaultValue;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void remove(@NotNull NamespacedKey key) {
        this.map.remove(key);
    }

    public Set<NamespacedKey> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Map<String, Object> serialize() {
        return this.map.entrySet().stream().collect(Collectors.toMap(e -> ((NamespacedKey)e.getKey()).toString(), Map.Entry::getValue));
    }

    public static PersistentDataContainerMock deserialize(Map<String, Object> args) {
        PersistentDataContainerMock mock = new PersistentDataContainerMock();
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            mock.map.put(NamespacedKey.fromString((String)entry.getKey()), entry.getValue());
        }
        return mock;
    }
}

