/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.sound;

import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.jetbrains.annotations.NotNull;

public final class AudioExperience {
    private final String sound;
    private final SoundCategory category;
    private final Location location;
    private final float volume;
    private final float pitch;

    public AudioExperience(@NotNull String sound, @NotNull SoundCategory category, @NotNull Location loc, float volume, float pitch) {
        Validate.notNull((Object)sound, (String)"The played sound cannot be null!");
        Validate.notNull((Object)category, (String)"The category must not be null!");
        Validate.notNull((Object)loc, (String)"The location cannot be null!");
        this.sound = sound;
        this.category = category;
        this.location = loc;
        this.volume = volume;
        this.pitch = pitch;
    }

    public AudioExperience(@NotNull Sound sound, @NotNull SoundCategory category, @NotNull Location loc, float volume, float pitch) {
        this(sound.getKey().getKey(), category, loc, volume, pitch);
    }

    @NotNull
    public String getSound() {
        return this.sound;
    }

    @NotNull
    public SoundCategory getCategory() {
        return this.category;
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }
}

