/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import be.seeseemelk.mockbukkit.block.state.BlockStateMock;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public class BlockMock
implements Block {
    private final MetadataTable metadataTable = new MetadataTable();
    private final Location location;
    private BlockStateMock state;
    private Material material;
    private byte data;
    private BlockData blockData;

    public BlockMock() {
        this(Material.AIR);
    }

    public BlockMock(@NotNull Location location) {
        this(Material.AIR, location);
    }

    public BlockMock(@NotNull Material material) {
        this(material, null);
    }

    public BlockMock(@NotNull Material material, @Nullable Location location) {
        this.material = material;
        this.location = location;
        this.state = BlockStateMock.mockState(this);
        this.blockData = new BlockDataMock(material);
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.metadataTable.getMetadata(metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.metadataTable.hasMetadata(metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    @Deprecated
    public byte getData() {
        return this.data;
    }

    public Block getRelative(int modX, int modY, int modZ) {
        int x = this.location.getBlockX() + modX;
        int y = this.location.getBlockY() + modY;
        int z = this.location.getBlockZ() + modZ;
        return this.location.getWorld().getBlockAt(x, y, z);
    }

    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    public void assertType(@NotNull Material material) {
        if (this.material != material) {
            Assertions.fail((String)String.format("Block material type is <%s>, but <%s> was expected.", this.material, material));
        }
    }

    public Material getType() {
        return this.material;
    }

    public byte getLightLevel() {
        throw new UnimplementedOperationException();
    }

    public byte getLightFromSky() {
        throw new UnimplementedOperationException();
    }

    public byte getLightFromBlocks() {
        throw new UnimplementedOperationException();
    }

    public World getWorld() {
        return this.location.getWorld();
    }

    public int getX() {
        return this.location.getBlockX();
    }

    public int getY() {
        return this.location.getBlockY();
    }

    public int getZ() {
        return this.location.getBlockZ();
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.location.getX());
            loc.setY(this.location.getY());
            loc.setZ(this.location.getZ());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public Chunk getChunk() {
        return this.location.getWorld().getChunkAt((Block)this);
    }

    public void setType(Material type) {
        this.material = type;
        this.state = BlockStateMock.mockState(this);
        this.blockData = new BlockDataMock(type);
    }

    public void setType(Material type, boolean applyPhysics) {
        this.setType(this.material);
    }

    public BlockFace getFace(@NotNull Block block) {
        for (BlockFace face : BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public BlockState getState() {
        return this.state.getSnapshot();
    }

    public Biome getBiome() {
        throw new UnimplementedOperationException();
    }

    public void setBiome(Biome bio) {
        throw new UnimplementedOperationException();
    }

    public boolean isBlockPowered() {
        throw new UnimplementedOperationException();
    }

    public boolean isBlockIndirectlyPowered() {
        throw new UnimplementedOperationException();
    }

    public boolean isBlockFacePowered(BlockFace face) {
        throw new UnimplementedOperationException();
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        throw new UnimplementedOperationException();
    }

    public int getBlockPower(BlockFace face) {
        throw new UnimplementedOperationException();
    }

    public int getBlockPower() {
        throw new UnimplementedOperationException();
    }

    public boolean isEmpty() {
        return this.material == Material.AIR;
    }

    public boolean isLiquid() {
        return this.material == Material.LAVA || this.material == Material.WATER || this.material == Material.BUBBLE_COLUMN;
    }

    public double getTemperature() {
        throw new UnimplementedOperationException();
    }

    public double getHumidity() {
        throw new UnimplementedOperationException();
    }

    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnimplementedOperationException();
    }

    public boolean breakNaturally() {
        if (this.isEmpty()) {
            return false;
        }
        this.setType(Material.AIR);
        return true;
    }

    public boolean breakNaturally(ItemStack tool) {
        return this.breakNaturally();
    }

    public Collection<ItemStack> getDrops() {
        throw new UnimplementedOperationException();
    }

    public Collection<ItemStack> getDrops(ItemStack tool) {
        throw new UnimplementedOperationException();
    }

    public BlockData getBlockData() {
        return this.blockData;
    }

    public void setBlockData(@NotNull BlockData data) {
        this.material = data.getMaterial();
        this.blockData = data;
    }

    public void setBlockData(BlockData data, boolean applyPhysics) {
        throw new UnimplementedOperationException();
    }

    public boolean isPassable() {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public VoxelShape getCollisionShape() {
        throw new UnimplementedOperationException();
    }

    public Collection<ItemStack> getDrops(ItemStack tool, Entity entity) {
        throw new UnimplementedOperationException();
    }

    public void setState(@NotNull BlockStateMock state) {
        Validate.notNull((Object)state, (String)"The BlockState cannot be null");
        this.state = state;
    }

    public boolean applyBoneMeal(BlockFace face) {
        throw new UnimplementedOperationException();
    }

    public boolean isPreferredTool(ItemStack tool) {
        throw new UnimplementedOperationException();
    }

    public float getBreakSpeed(@NotNull Player player) {
        throw new UnimplementedOperationException();
    }

    public boolean canPlace(BlockData data) {
        throw new UnimplementedOperationException();
    }
}

