/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.ProjectileMock;
import be.seeseemelk.mockbukkit.inventory.meta.FireworkMetaMock;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;

public class FireworkMock
extends ProjectileMock
implements Firework {
    private FireworkMeta meta;
    private boolean shotAtAngle = false;

    public FireworkMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        this(server, uuid, new FireworkMetaMock());
    }

    public FireworkMock(@NotNull ServerMock server, @NotNull UUID uuid, @NotNull FireworkMeta meta) {
        super(server, uuid);
        this.meta = meta.clone();
    }

    public EntityType getType() {
        return EntityType.FIREWORK;
    }

    @NotNull
    public FireworkMeta getFireworkMeta() {
        return this.meta;
    }

    public void setFireworkMeta(@NotNull FireworkMeta meta) {
        Validate.notNull((Object)meta, (String)"FireworkMeta cannot be null!");
        this.meta = meta.clone();
    }

    public void detonate() {
        throw new UnimplementedOperationException();
    }

    public boolean isShotAtAngle() {
        return this.shotAtAngle;
    }

    public void setShotAtAngle(boolean shotAtAngle) {
        this.shotAtAngle = shotAtAngle;
    }

    @NotNull
    public SpawnCategory getSpawnCategory() {
        return SpawnCategory.MISC;
    }
}

