/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.attribute.AttributeInstanceMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.potion.ActivePotionEffect;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public abstract class LivingEntityMock
extends EntityMock
implements LivingEntity {
    private static final double MAX_HEALTH = 20.0;
    protected double health;
    private double maxHealth = 20.0;
    private int maxAirTicks = 300;
    private int remainingAirTicks = 300;
    protected boolean alive = true;
    private boolean gliding = false;
    protected Map<Attribute, AttributeInstanceMock> attributes;
    private final Set<ActivePotionEffect> activeEffects = new HashSet<ActivePotionEffect>();

    protected LivingEntityMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
        this.attributes = new EnumMap<Attribute, AttributeInstanceMock>(Attribute.class);
        this.attributes.put(Attribute.GENERIC_MAX_HEALTH, new AttributeInstanceMock(Attribute.GENERIC_MAX_HEALTH, 20.0));
        this.setMaxHealth(20.0);
        this.setHealth(20.0);
    }

    public double getHealth() {
        return this.health;
    }

    @Override
    public boolean isDead() {
        return !this.alive;
    }

    public void setHealth(double health) {
        if (health > 0.0) {
            this.health = Math.min(health, this.getMaxHealth());
            return;
        }
        this.health = 0.0;
        EntityDeathEvent event = new EntityDeathEvent((LivingEntity)this, new ArrayList(), 0);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.alive = false;
    }

    public double getMaxHealth() {
        return this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
    }

    public void setMaxHealth(double health) {
        this.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
        if (this.health > health) {
            this.health = health;
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(this.maxHealth);
    }

    public void damage(double amount) {
        this.damage(amount, null);
    }

    public void damage(double amount, Entity source) {
        if (this.isInvulnerable()) {
            if (source instanceof HumanEntity) {
                if (((Player)source).getGameMode() != GameMode.CREATIVE) {
                    return;
                }
            } else {
                return;
            }
        }
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, 1.0);
        EnumMap<EntityDamageEvent.DamageModifier, Function> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, Function>(EntityDamageEvent.DamageModifier.class);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, damage -> damage);
        EntityDamageByEntityEvent event = source != null ? new EntityDamageByEntityEvent(source, (Entity)this, EntityDamageEvent.DamageCause.ENTITY_ATTACK, modifiers, modifierFunctions) : new EntityDamageEvent((Entity)this, EntityDamageEvent.DamageCause.CUSTOM, modifiers, modifierFunctions);
        event.setDamage(amount);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            amount = event.getDamage();
            this.setHealth(this.health - amount);
        }
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        if (this.attributes.containsKey(attribute)) {
            return this.attributes.get(attribute);
        }
        throw new UnimplementedOperationException();
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        throw new UnimplementedOperationException();
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        T entity = this.launchProjectile(projectile);
        entity.setVelocity(velocity);
        return entity;
    }

    public double getEyeHeight() {
        throw new UnimplementedOperationException();
    }

    public double getEyeHeight(boolean ignorePose) {
        throw new UnimplementedOperationException();
    }

    public Location getEyeLocation() {
        return this.getLocation().add(0.0, this.getEyeHeight(), 0.0);
    }

    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    public Block getTargetBlockExact(int maxDistance) {
        throw new UnimplementedOperationException();
    }

    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceBlocks(double maxDistance) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    public int getRemainingAir() {
        return this.remainingAirTicks;
    }

    public void setRemainingAir(int ticks) {
        this.remainingAirTicks = ticks;
    }

    public int getMaximumAir() {
        return this.maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.maxAirTicks = ticks;
    }

    public int getMaximumNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    public void setMaximumNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    public double getLastDamage() {
        throw new UnimplementedOperationException();
    }

    public void setLastDamage(double damage) {
        throw new UnimplementedOperationException();
    }

    public int getNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    public void setNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    public Player getKiller() {
        throw new UnimplementedOperationException();
    }

    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    @Deprecated
    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        if (effect != null) {
            this.activeEffects.add(new ActivePotionEffect(effect));
            return true;
        }
        return false;
    }

    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean successful = true;
        for (PotionEffect effect : effects) {
            if (this.addPotionEffect(effect)) continue;
            successful = false;
        }
        return successful;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getPotionEffect(type) != null;
    }

    public PotionEffect getPotionEffect(PotionEffectType type) {
        for (PotionEffect effect : this.getActivePotionEffects()) {
            if (!effect.getType().equals((Object)type)) continue;
            return effect;
        }
        return null;
    }

    public void removePotionEffect(PotionEffectType type) {
        this.activeEffects.removeIf(effect -> effect.hasExpired() || effect.getPotionEffect().getType().equals((Object)type));
    }

    public Collection<PotionEffect> getActivePotionEffects() {
        HashSet<PotionEffect> effects = new HashSet<PotionEffect>();
        Iterator<ActivePotionEffect> iterator = this.activeEffects.iterator();
        while (iterator.hasNext()) {
            ActivePotionEffect effect = iterator.next();
            if (effect.hasExpired()) {
                iterator.remove();
                continue;
            }
            effects.add(effect.getPotionEffect());
        }
        return effects;
    }

    public boolean hasLineOfSight(Entity other) {
        throw new UnimplementedOperationException();
    }

    public boolean getRemoveWhenFarAway() {
        throw new UnimplementedOperationException();
    }

    public void setRemoveWhenFarAway(boolean remove) {
        throw new UnimplementedOperationException();
    }

    public void setCanPickupItems(boolean pickup) {
        throw new UnimplementedOperationException();
    }

    public boolean getCanPickupItems() {
        throw new UnimplementedOperationException();
    }

    public boolean isLeashed() {
        throw new UnimplementedOperationException();
    }

    public Entity getLeashHolder() throws IllegalStateException {
        throw new UnimplementedOperationException();
    }

    public boolean setLeashHolder(Entity holder) {
        throw new UnimplementedOperationException();
    }

    public boolean isGliding() {
        return this.gliding;
    }

    public void setGliding(boolean gliding) {
        this.gliding = gliding;
    }

    public boolean isSwimming() {
        throw new UnimplementedOperationException();
    }

    public void setSwimming(boolean swimming) {
        throw new UnimplementedOperationException();
    }

    public boolean isRiptiding() {
        throw new UnimplementedOperationException();
    }

    public boolean isClimbing() {
        throw new UnimplementedOperationException();
    }

    public void setAI(boolean ai) {
        throw new UnimplementedOperationException();
    }

    public boolean hasAI() {
        throw new UnimplementedOperationException();
    }

    public void setCollidable(boolean collidable) {
        throw new UnimplementedOperationException();
    }

    public boolean isCollidable() {
        throw new UnimplementedOperationException();
    }

    public EntityCategory getCategory() {
        throw new UnimplementedOperationException();
    }

    public void setArrowsInBody(int count) {
        throw new UnimplementedOperationException();
    }

    public int getArrowsInBody() {
        throw new UnimplementedOperationException();
    }

    public void setArrowCooldown(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getArrowCooldown() {
        throw new UnimplementedOperationException();
    }

    public void setInvisible(boolean invisible) {
        throw new UnimplementedOperationException();
    }

    public boolean isInvisible() {
        throw new UnimplementedOperationException();
    }
}

