/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.plugin;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.PluginCommandUtils;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.AuthorNagException;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.java.JavaPluginUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

public class PluginManagerMock
implements PluginManager {
    private final ServerMock server;
    private final JavaPluginLoader loader;
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final List<PluginCommand> commands = new ArrayList<PluginCommand>();
    private final List<Event> events = new ArrayList<Event>();
    private final List<File> temporaryFiles = new LinkedList<File>();
    private final List<Permission> permissions = new ArrayList<Permission>();
    private final Map<Permissible, Set<String>> permissionSubscriptions = new HashMap<Permissible, Set<String>>();
    private Map<String, List<Listener>> listeners = new HashMap<String, List<Listener>>();
    private final List<Class<?>> pluginConstructorTypes = Arrays.asList(JavaPluginLoader.class, PluginDescriptionFile.class, File.class, File.class);

    public PluginManagerMock(@NotNull ServerMock server) {
        this.server = server;
        this.loader = new JavaPluginLoader((Server)this.server);
    }

    public void unload() {
        for (File file : this.temporaryFiles) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                System.err.println("Could not remove file");
                e.printStackTrace();
            }
        }
    }

    public void assertEventFired(@NotNull String message, @NotNull Predicate<Event> predicate) {
        for (Event event : this.events) {
            if (!predicate.test(event)) continue;
            return;
        }
        Assertions.fail((String)message);
    }

    public void assertEventFired(@NotNull Predicate<Event> predicate) {
        this.assertEventFired("Event assert failed", predicate);
    }

    public <T extends Event> void assertEventFired(String message, Class<T> eventClass, Predicate<T> predicate) {
        for (Event event : this.events) {
            if (!eventClass.isInstance(event) || !predicate.test((Event)eventClass.cast(event))) continue;
            return;
        }
        Assertions.fail((String)message);
    }

    public <T extends Event> void assertEventFired(Class<T> eventClass, Predicate<T> predicate) {
        this.assertEventFired("No event of the correct class tested true", eventClass, predicate);
    }

    public void assertEventFired(@NotNull Class<? extends Event> eventClass) {
        this.assertEventFired("No event of that type has been fired", eventClass::isInstance);
    }

    public Plugin getPlugin(@NotNull String name) {
        for (Plugin plugin : this.plugins) {
            if (!name.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    public Plugin[] getPlugins() {
        return this.plugins.toArray(new Plugin[0]);
    }

    @NotNull
    public Collection<PluginCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    private boolean isConstructorCompatible(@NotNull Constructor<?> constructor, @NotNull Class<?>[] types) {
        Class<?>[] parameters = constructor.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            Class<?> parameter = parameters[i];
            if (!(i < 4 ? !type.equals(parameter) : !parameter.isAssignableFrom(type))) continue;
            return false;
        }
        return true;
    }

    private Constructor<? extends JavaPlugin> getCompatibleConstructor(Class<? extends JavaPlugin> class1, Class<?>[] types) throws NoSuchMethodException {
        for (Constructor<?> constructor : class1.getDeclaredConstructors()) {
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length != types.length || !this.isConstructorCompatible(constructor, types)) continue;
            return constructor;
        }
        StringBuilder parameters = new StringBuilder("[");
        for (Class<?> type : types) {
            parameters.append(type.getName()).append(", ");
        }
        String str = parameters.substring(0, parameters.length() - 2) + "]";
        throw new NoSuchMethodException("No compatible constructor for " + class1.getName() + " with parameters " + str);
    }

    @NotNull
    private File createTemporaryDirectory(@NotNull String name) throws IOException {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        File directory = Files.createTempDirectory(name + "-" + ((Random)random).nextInt(), new FileAttribute[0]).toFile();
        this.temporaryFiles.add(directory);
        return directory;
    }

    @NotNull
    private File createTemporaryPluginFile(@NotNull String name) throws IOException {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        File pluginFile = Files.createTempFile(name + "-" + ((Random)random).nextInt(), ".jar", new FileAttribute[0]).toFile();
        pluginFile.createNewFile();
        this.temporaryFiles.add(pluginFile);
        return pluginFile;
    }

    public void registerLoadedPlugin(@NotNull Plugin plugin) {
        this.addCommandsFrom(plugin);
        this.plugins.add(plugin);
        plugin.onLoad();
    }

    public JavaPlugin loadPlugin(Class<? extends JavaPlugin> class1, PluginDescriptionFile description, Object[] parameters) {
        try {
            ArrayList types = new ArrayList(this.pluginConstructorTypes);
            for (Object parameter : parameters) {
                types.add(parameter.getClass());
            }
            Constructor<? extends JavaPlugin> constructor = this.getCompatibleConstructor(class1, types.toArray(new Class[0]));
            constructor.setAccessible(true);
            Object[] arguments = new Object[types.size()];
            arguments[0] = this.loader;
            arguments[1] = description;
            arguments[2] = this.createTemporaryDirectory("MockBukkit-" + description.getName() + "-" + description.getVersion());
            arguments[3] = this.createTemporaryPluginFile("MockBukkit-" + description.getName() + "-" + description.getVersion());
            System.arraycopy(parameters, 0, arguments, 4, parameters.length);
            JavaPlugin plugin = constructor.newInstance(arguments);
            this.registerLoadedPlugin((Plugin)plugin);
            return plugin;
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate plugin", e);
        }
    }

    public JavaPlugin loadPlugin(Class<? extends JavaPlugin> class1, PluginDescriptionFile description) {
        return this.loadPlugin(class1, description, new Object[0]);
    }

    public JavaPlugin loadPlugin(Class<? extends JavaPlugin> class1, Object[] parameters) {
        try {
            PluginDescriptionFile description = this.findPluginDescription(class1);
            return this.loadPlugin(class1, description, parameters);
        }
        catch (IOException | InvalidDescriptionException e) {
            throw new RuntimeException(e);
        }
    }

    private PluginDescriptionFile findPluginDescription(Class<? extends JavaPlugin> class1) throws IOException, InvalidDescriptionException {
        Enumeration<URL> resources = class1.getClassLoader().getResources("plugin.yml");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            PluginDescriptionFile description = new PluginDescriptionFile(url.openStream());
            String mainClass = description.getMain();
            if (!class1.getName().equals(mainClass)) continue;
            return description;
        }
        throw new FileNotFoundException("Could not find file plugin.yml. Maybe forgot to add the 'main' property?");
    }

    public void callEvent(@NotNull Event event) {
        RegisteredListener[] listeners;
        if (event.isAsynchronous() && this.server.isOnMainThread()) {
            throw new IllegalStateException("Asynchronous Events cannot be called on the main Thread.");
        }
        this.events.add(event);
        HandlerList handlers = event.getHandlers();
        for (RegisteredListener l : listeners = handlers.getRegisteredListeners()) {
            this.callRegisteredListener(l, event);
        }
    }

    public void callEventAsynchronously(@NotNull Event event) {
        if (!event.isAsynchronous()) {
            throw new IllegalStateException("Synchronous Events cannot be called asynchronously.");
        }
        this.server.getScheduler().executeAsyncEvent(event);
    }

    private void callRegisteredListener(@NotNull RegisteredListener registration, @NotNull Event event) {
        if (!registration.getPlugin().isEnabled()) {
            return;
        }
        try {
            registration.callEvent(event);
        }
        catch (AuthorNagException ex) {
            Plugin plugin = registration.getPlugin();
            if (plugin.isNaggable()) {
                plugin.setNaggable(false);
                this.server.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), ex.getMessage()));
            }
        }
        catch (Throwable ex) {
            String msg = "Could not pass event " + event.getEventName() + " to " + registration.getPlugin().getDescription().getFullName();
            this.server.getLogger().log(Level.SEVERE, msg, ex);
        }
    }

    public void enablePlugin(@NotNull Plugin plugin) {
        if (plugin instanceof JavaPlugin) {
            if (!plugin.isEnabled()) {
                JavaPluginUtils.setEnabled((JavaPlugin)plugin, true);
                this.callEvent((Event)new PluginEnableEvent(plugin));
            }
        } else {
            throw new IllegalArgumentException("Not a JavaPlugin");
        }
    }

    private void addSection(PluginCommand command, String name, Object value) {
        switch (name) {
            case "description": {
                command.setDescription((String)value);
                break;
            }
            case "aliases": {
                if (value instanceof List) {
                    command.setAliases(((List)value).stream().map(Object::toString).collect(Collectors.toList()));
                    break;
                }
                if (value != null) {
                    command.setAliases(Collections.singletonList(value.toString()));
                    break;
                }
                command.setAliases(Collections.emptyList());
                break;
            }
            case "permission": {
                command.setPermission((String)value);
                break;
            }
            case "permission-message": {
                command.setPermissionMessage((String)value);
                break;
            }
            case "usage": {
                command.setUsage((String)value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown section " + value);
            }
        }
    }

    protected void addCommandsFrom(Plugin plugin) {
        Map commands = plugin.getDescription().getCommands();
        for (Map.Entry entry : commands.entrySet()) {
            PluginCommand command = PluginCommandUtils.createPluginCommand((String)entry.getKey(), plugin);
            for (Map.Entry section : ((Map)entry.getValue()).entrySet()) {
                this.addSection(command, (String)section.getKey(), section.getValue());
            }
            this.commands.add(command);
            this.server.getCommandMap().register(plugin.getName(), (Command)command);
        }
    }

    public void registerInterface(@NotNull Class<? extends PluginLoader> loader) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public boolean isPluginEnabled(@NotNull String name) {
        boolean result = false;
        for (Plugin mockedPlugin : this.plugins) {
            if (!mockedPlugin.getName().equals(name)) continue;
            result = mockedPlugin.isEnabled();
        }
        return result;
    }

    public boolean isPluginEnabled(Plugin plugin) {
        boolean result = false;
        for (Plugin mockedPlugin : this.plugins) {
            if (!mockedPlugin.equals(plugin)) continue;
            result = plugin.isEnabled();
        }
        return result;
    }

    public Plugin loadPlugin(@NotNull File file) throws InvalidPluginException, InvalidDescriptionException, UnknownDependencyException {
        throw new UnimplementedOperationException();
    }

    public Plugin[] loadPlugins(@NotNull File directory) {
        throw new UnimplementedOperationException();
    }

    public void disablePlugins() {
        for (Plugin plugin : this.plugins) {
            this.disablePlugin(plugin);
        }
    }

    public void clearPlugins() {
        this.disablePlugins();
        this.plugins.clear();
    }

    public void clearEvents() {
        this.events.clear();
    }

    public void registerEvents(@NotNull Listener listener, @NotNull Plugin plugin) {
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + listener + " while not enabled");
        }
        this.addListener(listener, plugin);
        for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners(listener, plugin).entrySet()) {
            this.getEventListeners(this.getRegistrationClass((Class)entry.getKey())).registerAll((Collection)entry.getValue());
        }
    }

    private void addListener(Listener listener, Plugin plugin) {
        List l = this.listeners.getOrDefault(plugin.getName(), new ArrayList());
        if (!l.contains(listener)) {
            l.add(listener);
            this.listeners.put(plugin.getName(), l);
        }
    }

    public void unregisterPluginEvents(Plugin plugin) {
        List<Listener> listListener = this.listeners.get(plugin.getName());
        if (listListener != null) {
            for (Listener l : listListener) {
                for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners(l, plugin).entrySet()) {
                    this.getEventListeners(this.getRegistrationClass((Class)entry.getKey())).unregister(plugin);
                }
            }
        }
    }

    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin) {
        this.registerEvent(event, listener, priority, executor, plugin, false);
    }

    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin, boolean ignoreCancelled) {
        Validate.notNull((Object)listener, (String)"Listener cannot be null");
        Validate.notNull((Object)priority, (String)"Priority cannot be null");
        Validate.notNull((Object)executor, (String)"Executor cannot be null");
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + event + " while not enabled");
        }
        this.addListener(listener, plugin);
        this.getEventListeners(event).register(new RegisteredListener(listener, executor, priority, plugin, ignoreCancelled));
    }

    private HandlerList getEventListeners(Class<? extends Event> type) {
        try {
            Method method = this.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalPluginAccessException(e.toString());
        }
    }

    private Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return this.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    public void disablePlugin(@NotNull Plugin plugin) {
        if (plugin instanceof JavaPlugin) {
            if (plugin.isEnabled()) {
                this.unregisterPluginEvents(plugin);
                JavaPluginUtils.setEnabled((JavaPlugin)plugin, false);
                this.callEvent((Event)new PluginDisableEvent(plugin));
            }
        } else {
            throw new IllegalArgumentException("Not a JavaPlugin");
        }
    }

    public Permission getPermission(@NotNull String name) {
        return this.permissions.stream().filter(permission -> permission.getName().equals(name)).findFirst().orElse(null);
    }

    public void addPermission(@NotNull Permission perm) {
        this.permissions.add(perm);
    }

    public void removePermission(@NotNull Permission perm) {
        this.permissions.remove(perm);
    }

    public void removePermission(@NotNull String name) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<Permission> getDefaultPermissions(boolean op) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (Permission permission : this.permissions) {
            PermissionDefault permissionDefault = permission.getDefault();
            if (permissionDefault == PermissionDefault.TRUE) {
                permissions.add(permission);
                continue;
            }
            if (!op || permissionDefault != PermissionDefault.OP) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    public void recalculatePermissionDefaults(@NotNull Permission perm) {
    }

    private Set<String> getPermissionSubscriptions(Permissible permissible) {
        if (this.permissionSubscriptions.containsKey(permissible)) {
            return this.permissionSubscriptions.get(permissible);
        }
        HashSet<String> subscriptions = new HashSet<String>();
        this.permissionSubscriptions.put(permissible, subscriptions);
        return subscriptions;
    }

    public void subscribeToPermission(@NotNull String permission, @NotNull Permissible permissible) {
        this.getPermissionSubscriptions(permissible).add(permission);
    }

    public void unsubscribeFromPermission(@NotNull String permission, @NotNull Permissible permissible) {
        this.getPermissionSubscriptions(permissible).remove(permission);
    }

    @NotNull
    public Set<Permissible> getPermissionSubscriptions(@NotNull String permission) {
        HashSet<Permissible> subscriptions = new HashSet<Permissible>();
        for (Map.Entry<Permissible, Set<String>> entry : this.permissionSubscriptions.entrySet()) {
            Permissible permissible = entry.getKey();
            Set<String> permissions = entry.getValue();
            if (!permissions.contains(permission)) continue;
            subscriptions.add(permissible);
        }
        return subscriptions;
    }

    public void subscribeToDefaultPerms(boolean op, @NotNull Permissible permissible) {
        throw new UnimplementedOperationException();
    }

    public void unsubscribeFromDefaultPerms(boolean op, @NotNull Permissible permissible) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<Permissible> getDefaultPermSubscriptions(boolean op) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<Permission> getPermissions() {
        return Collections.unmodifiableSet(new HashSet<Permission>(this.permissions));
    }

    public boolean useTimings() {
        return false;
    }
}

