/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.ChunkCoordinate;
import be.seeseemelk.mockbukkit.ChunkMock;
import be.seeseemelk.mockbukkit.Coordinate;
import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.BlockMock;
import be.seeseemelk.mockbukkit.entity.ArmorStandMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.entity.ExperienceOrbMock;
import be.seeseemelk.mockbukkit.entity.FireworkMock;
import be.seeseemelk.mockbukkit.entity.ItemEntityMock;
import be.seeseemelk.mockbukkit.entity.ZombieMock;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import com.destroystokyo.paper.HeightmapType;
import io.papermc.paper.world.MoonPhase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldMock
implements World {
    private static final int SEA_LEVEL = 63;
    private final Map<Coordinate, BlockMock> blocks = new HashMap<Coordinate, BlockMock>();
    private final Map<GameRule<?>, Object> gameRules = new HashMap();
    private final MetadataTable metadataTable = new MetadataTable();
    private final Map<ChunkCoordinate, ChunkMock> loadedChunks = new HashMap<ChunkCoordinate, ChunkMock>();
    private PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();
    private final ServerMock server;
    private final Material defaultBlock;
    private final int grassHeight;
    private final int minHeight;
    private final int maxHeight;
    private final UUID uuid = UUID.randomUUID();
    private World.Environment environment = World.Environment.NORMAL;
    private String name = "World";
    private Location spawnLocation;
    private long fullTime = 0L;
    private int weatherDuration = 0;
    private int thunderDuration = 0;
    private boolean storming = false;
    private long seed = 0L;
    private WorldType worldType = WorldType.NORMAL;

    public WorldMock(Material defaultBlock, int minHeight, int maxHeight, int grassHeight) {
        this.defaultBlock = defaultBlock;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.grassHeight = grassHeight;
        this.server = MockBukkit.getMock();
        this.gameRules.put(GameRule.ANNOUNCE_ADVANCEMENTS, true);
        this.gameRules.put(GameRule.COMMAND_BLOCK_OUTPUT, true);
        this.gameRules.put(GameRule.DISABLE_ELYTRA_MOVEMENT_CHECK, false);
        this.gameRules.put(GameRule.DO_DAYLIGHT_CYCLE, true);
        this.gameRules.put(GameRule.DO_ENTITY_DROPS, true);
        this.gameRules.put(GameRule.DO_FIRE_TICK, true);
        this.gameRules.put(GameRule.DO_LIMITED_CRAFTING, false);
        this.gameRules.put(GameRule.DO_MOB_LOOT, true);
        this.gameRules.put(GameRule.DO_MOB_SPAWNING, true);
        this.gameRules.put(GameRule.DO_TILE_DROPS, true);
        this.gameRules.put(GameRule.DO_WEATHER_CYCLE, true);
        this.gameRules.put(GameRule.KEEP_INVENTORY, false);
        this.gameRules.put(GameRule.LOG_ADMIN_COMMANDS, true);
        this.gameRules.put(GameRule.MAX_COMMAND_CHAIN_LENGTH, 65536);
        this.gameRules.put(GameRule.MAX_ENTITY_CRAMMING, 24);
        this.gameRules.put(GameRule.MOB_GRIEFING, true);
        this.gameRules.put(GameRule.NATURAL_REGENERATION, true);
        this.gameRules.put(GameRule.RANDOM_TICK_SPEED, 3);
        this.gameRules.put(GameRule.REDUCED_DEBUG_INFO, false);
        this.gameRules.put(GameRule.SEND_COMMAND_FEEDBACK, true);
        this.gameRules.put(GameRule.SHOW_DEATH_MESSAGES, true);
        this.gameRules.put(GameRule.SPAWN_RADIUS, 10);
        this.gameRules.put(GameRule.SPECTATORS_GENERATE_CHUNKS, true);
    }

    public WorldMock(@NotNull WorldCreator creator) {
        this();
        this.name = creator.name();
        this.worldType = creator.type();
        this.seed = creator.seed();
        this.environment = creator.environment();
    }

    public WorldMock(Material defaultBlock, int maxHeight, int grassHeight) {
        this(defaultBlock, 0, maxHeight, grassHeight);
    }

    public WorldMock(Material defaultBlock, int grassHeight) {
        this(defaultBlock, 128, grassHeight);
    }

    public WorldMock() {
        this(Material.GRASS, 4);
    }

    public BlockMock createBlock(Coordinate c) {
        if (c.y >= this.maxHeight) {
            throw new ArrayIndexOutOfBoundsException("Y larger than max height");
        }
        if (c.y < this.minHeight) {
            throw new ArrayIndexOutOfBoundsException("Y smaller than min height");
        }
        Location location = new Location((World)this, (double)c.x, (double)c.y, (double)c.z);
        BlockMock block = c.y == 0 ? new BlockMock(Material.BEDROCK, location) : (c.y <= this.grassHeight ? new BlockMock(this.defaultBlock, location) : new BlockMock(location));
        this.blocks.put(c, block);
        return block;
    }

    public int getEntityCount() {
        throw new UnimplementedOperationException();
    }

    public int getTileEntityCount() {
        throw new UnimplementedOperationException();
    }

    public int getTickableTileEntityCount() {
        throw new UnimplementedOperationException();
    }

    public int getChunkCount() {
        throw new UnimplementedOperationException();
    }

    public int getPlayerCount() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public MoonPhase getMoonPhase() {
        throw new UnimplementedOperationException();
    }

    public boolean lineOfSightExists(@NotNull Location from, @NotNull Location to) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockMock getBlockAt(int x, int y, int z) {
        return this.getBlockAt(new Coordinate(x, y, z));
    }

    @NotNull
    public BlockMock getBlockAt(@NotNull Coordinate coordinate) {
        if (this.blocks.containsKey(coordinate)) {
            return this.blocks.get(coordinate);
        }
        return this.createBlock(coordinate);
    }

    @NotNull
    public BlockMock getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Deprecated
    @NotNull
    public Block getBlockAtKey(long key) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Location getLocationAtKey(long key) {
        return super.getLocationAtKey(key);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    public UUID getUID() {
        return this.uuid;
    }

    @NotNull
    public Location getSpawnLocation() {
        if (this.spawnLocation == null) {
            this.setSpawnLocation(0, this.grassHeight + 1, 0);
        }
        return this.spawnLocation;
    }

    public boolean setSpawnLocation(Location location) {
        return this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public boolean setSpawnLocation(int x, int y, int z) {
        if (this.spawnLocation == null) {
            this.spawnLocation = new Location((World)this, (double)x, (double)y, (double)z);
        } else {
            this.spawnLocation.setX((double)x);
            this.spawnLocation.setY((double)y);
            this.spawnLocation.setZ((double)z);
        }
        return true;
    }

    @NotNull
    public List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Set<EntityMock> serverEntities = MockBukkit.getMock().getEntities();
        serverEntities.stream().filter(entity -> entity.getWorld() == this).collect(Collectors.toCollection(() -> entities));
        return entities;
    }

    @NotNull
    public ChunkMock getChunkAt(int x, int z) {
        return this.getChunkAt(new ChunkCoordinate(x, z));
    }

    @NotNull
    public ChunkMock getChunkAt(@NotNull ChunkCoordinate coordinate) {
        ChunkMock chunk = this.loadedChunks.get(coordinate);
        if (chunk == null) {
            chunk = new ChunkMock(this, coordinate.getX(), coordinate.getZ());
            this.loadedChunks.put(coordinate, chunk);
        }
        return chunk;
    }

    public void sendPluginMessage(@NotNull Plugin source, @NotNull String channel, byte[] message) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<String> getListeningPluginChannels() {
        throw new UnimplementedOperationException();
    }

    public void setMetadata(@NotNull String metadataKey, @NotNull MetadataValue newMetadataValue) {
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    @NotNull
    public List<MetadataValue> getMetadata(@NotNull String metadataKey) {
        return this.metadataTable.getMetadata(metadataKey);
    }

    public boolean hasMetadata(@NotNull String metadataKey) {
        return this.metadataTable.hasMetadata(metadataKey);
    }

    public void removeMetadata(@NotNull String metadataKey, @NotNull Plugin owningPlugin) {
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    public int getHighestBlockYAt(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public int getHighestBlockYAt(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Block getHighestBlockAt(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Block getHighestBlockAt(Location location) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getHighestBlockYAt(int x, int z, @NotNull HeightmapType heightmap) throws UnsupportedOperationException {
        throw new UnimplementedOperationException();
    }

    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public Chunk getChunkAt(Block block) {
        return this.getChunkAt(block.getLocation());
    }

    public boolean isChunkLoaded(Chunk chunk) {
        throw new UnimplementedOperationException();
    }

    public Chunk[] getLoadedChunks() {
        return this.loadedChunks.values().toArray(new Chunk[0]);
    }

    public void loadChunk(Chunk chunk) {
        throw new UnimplementedOperationException();
    }

    public boolean isChunkLoaded(int x, int z) {
        ChunkCoordinate coordinate = new ChunkCoordinate(x, z);
        return this.loadedChunks.containsKey(coordinate);
    }

    @Deprecated
    public boolean isChunkInUse(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public void loadChunk(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public boolean loadChunk(int x, int z, boolean generate) {
        throw new UnimplementedOperationException();
    }

    public boolean unloadChunk(Chunk chunk) {
        throw new UnimplementedOperationException();
    }

    public boolean unloadChunk(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public boolean unloadChunk(int x, int z, boolean save) {
        throw new UnimplementedOperationException();
    }

    public boolean unloadChunkRequest(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean regenerateChunk(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean refreshChunk(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public ItemEntityMock dropItem(@NotNull Location loc, @NotNull ItemStack item, @Nullable Consumer<Item> function) {
        Validate.notNull((Object)loc, (String)"The provided location must not be null.");
        Validate.notNull((Object)item, (String)"Cannot drop items that are null.");
        Validate.isTrue((!item.getType().isAir() ? 1 : 0) != 0, (String)"Cannot drop air.");
        ItemEntityMock entity = new ItemEntityMock(this.server, UUID.randomUUID(), item);
        entity.setLocation(loc);
        if (function != null) {
            function.accept((Object)entity);
        }
        this.server.registerEntity(entity);
        return entity;
    }

    public ItemEntityMock dropItem(@NotNull Location loc, @NotNull ItemStack item) {
        return this.dropItem(loc, item, e -> {});
    }

    public ItemEntityMock dropItemNaturally(@NotNull Location location, @NotNull ItemStack item, @Nullable Consumer<Item> function) {
        Validate.notNull((Object)location, (String)"The provided location must not be null.");
        ThreadLocalRandom random = ThreadLocalRandom.current();
        double xs = (double)(((Random)random).nextFloat() * 0.5f) + 0.25;
        double ys = (double)(((Random)random).nextFloat() * 0.5f) + 0.25;
        double zs = (double)(((Random)random).nextFloat() * 0.5f) + 0.25;
        Location loc = location.clone();
        loc.setX(loc.getX() + xs);
        loc.setY(loc.getY() + ys);
        loc.setZ(loc.getZ() + zs);
        return this.dropItem(loc, item, (Consumer)function);
    }

    public ItemEntityMock dropItemNaturally(@NotNull Location loc, @NotNull ItemStack item) {
        return this.dropItemNaturally(loc, item, e -> {});
    }

    public Arrow spawnArrow(Location location, Vector direction, float speed, float spread) {
        throw new UnimplementedOperationException();
    }

    public boolean generateTree(Location location, TreeType type) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        throw new UnimplementedOperationException();
    }

    public boolean generateTree(Location location, Random random, TreeType type, Predicate<BlockState> statePredicate) {
        throw new UnimplementedOperationException();
    }

    public Entity spawnEntity(Location loc, EntityType type) {
        return this.spawn(loc, type.getEntityClass());
    }

    @NotNull
    public Entity spawnEntity(@NotNull Location loc, @NotNull EntityType type, boolean randomizeData) {
        throw new UnimplementedOperationException();
    }

    private <T extends Entity> EntityMock mockEntity(@NotNull Class<T> clazz) {
        if (clazz == ArmorStand.class) {
            return new ArmorStandMock(this.server, UUID.randomUUID());
        }
        if (clazz == Zombie.class) {
            return new ZombieMock(this.server, UUID.randomUUID());
        }
        if (clazz == Firework.class) {
            return new FireworkMock(this.server, UUID.randomUUID());
        }
        if (clazz == ExperienceOrb.class) {
            return new ExperienceOrbMock(this.server, UUID.randomUUID());
        }
        if (clazz == Player.class) {
            throw new IllegalArgumentException("Player Entities cannot be spawned, use ServerMock#addPlayer(...)");
        }
        if (clazz == Item.class) {
            throw new IllegalArgumentException("Items must be spawned using World#dropItem(...)");
        }
        throw new UnimplementedOperationException();
    }

    public LightningStrike strikeLightning(Location loc) {
        throw new UnimplementedOperationException();
    }

    public LightningStrike strikeLightningEffect(Location loc) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location findLightningRod(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location findLightningTarget(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    public List<LivingEntity> getLivingEntities() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        throw new UnimplementedOperationException();
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> cls) {
        throw new UnimplementedOperationException();
    }

    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(int x, int z, boolean gen, boolean urgent) {
        throw new UnimplementedOperationException();
    }

    public List<Player> getPlayers() {
        return Bukkit.getOnlinePlayers().stream().filter(p -> p.getWorld() == this).collect(Collectors.toList());
    }

    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Entity getEntity(@NotNull UUID uuid) {
        throw new UnimplementedOperationException();
    }

    public long getTime() {
        return this.getFullTime() % 24000L;
    }

    public void setTime(long time) {
        long base = this.getFullTime() - this.getFullTime() % 24000L;
        this.setFullTime(base + time % 24000L);
    }

    public long getFullTime() {
        return this.fullTime;
    }

    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent((World)this, TimeSkipEvent.SkipReason.CUSTOM, time - this.getFullTime());
        this.server.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.fullTime += event.getSkipAmount();
        }
    }

    public boolean isDayTime() {
        return false;
    }

    public boolean hasStorm() {
        return this.storming;
    }

    public void setStorm(boolean hasStorm) {
        this.storming = hasStorm;
    }

    public int getWeatherDuration() {
        return this.weatherDuration;
    }

    public void setWeatherDuration(int duration) {
        this.weatherDuration = duration;
    }

    public boolean isThundering() {
        return this.thunderDuration > 0;
    }

    public void setThundering(boolean thundering) {
        this.thunderDuration = thundering ? 600 : 0;
    }

    public int getThunderDuration() {
        return this.thunderDuration;
    }

    public void setThunderDuration(int duration) {
        this.thunderDuration = duration;
    }

    public boolean createExplosion(double x, double y, double z, float power) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(Location loc, float power) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(Location loc, float power, boolean setFire) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(@Nullable Entity source, @NotNull Location loc, float power, boolean setFire, boolean breakBlocks) {
        return false;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean getPVP() {
        throw new UnimplementedOperationException();
    }

    public void setPVP(boolean pvp) {
        throw new UnimplementedOperationException();
    }

    public ChunkGenerator getGenerator() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public BiomeProvider getBiomeProvider() {
        throw new UnimplementedOperationException();
    }

    public void save() {
        throw new UnimplementedOperationException();
    }

    public List<BlockPopulator> getPopulators() {
        throw new UnimplementedOperationException();
    }

    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz) throws IllegalArgumentException {
        Validate.notNull((Object)location, (String)"The provided location must not be null.");
        Validate.notNull(clazz, (String)"The provided class must not be null.");
        EntityMock entity = this.mockEntity(clazz);
        entity.setLocation(location);
        this.server.registerEntity(entity);
        return (T)((Entity)clazz.cast(entity));
    }

    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @Nullable Consumer<T> function) throws IllegalArgumentException {
        T entity = this.spawn(location, clazz);
        if (function != null) {
            function.accept(entity);
        }
        return entity;
    }

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @Nullable Consumer<T> function, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, boolean randomizeData, @Nullable Consumer<T> function) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public void playEffect(Location location, Effect effect, int data) {
        throw new UnimplementedOperationException();
    }

    public void playEffect(Location location, Effect effect, int data, int radius) {
        throw new UnimplementedOperationException();
    }

    public <T> void playEffect(Location location, Effect effect, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void playEffect(Location location, Effect effect, T data, int radius) {
        throw new UnimplementedOperationException();
    }

    public ChunkSnapshot getEmptyChunkSnapshot(int x, int z, boolean includeBiome, boolean includeBiomeTempRain) {
        throw new UnimplementedOperationException();
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        throw new UnimplementedOperationException();
    }

    public boolean getAllowAnimals() {
        throw new UnimplementedOperationException();
    }

    public boolean getAllowMonsters() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public Biome getBiome(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setBiome(int x, int z, Biome bio) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public double getTemperature(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public double getHumidity(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    @NotNull
    public BiomeProvider vanillaBiomeProvider() {
        throw new UnimplementedOperationException();
    }

    public int getSeaLevel() {
        return 63;
    }

    public boolean getKeepSpawnInMemory() {
        throw new UnimplementedOperationException();
    }

    public void setKeepSpawnInMemory(boolean keepLoaded) {
        throw new UnimplementedOperationException();
    }

    public boolean isAutoSave() {
        throw new UnimplementedOperationException();
    }

    public void setAutoSave(boolean value) {
        throw new UnimplementedOperationException();
    }

    public Difficulty getDifficulty() {
        throw new UnimplementedOperationException();
    }

    public void setDifficulty(Difficulty difficulty) {
        throw new UnimplementedOperationException();
    }

    public File getWorldFolder() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public WorldType getWorldType() {
        return this.worldType;
    }

    public boolean canGenerateStructures() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public long getTicksPerAnimalSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public long getTicksPerMonsterSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getMonsterSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setMonsterSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setAnimalSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setWaterAnimalSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setWaterUndergroundCreatureSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setAmbientSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    public void playSound(Location location, Sound sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location location, String sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location location, Sound sound, SoundCategory category, float volume, float pitch) {
        for (Player player : this.getPlayers()) {
            player.playSound(location, sound, category, volume, pitch);
        }
    }

    public void playSound(Location location, String sound, SoundCategory category, float volume, float pitch) {
        for (Player player : this.getPlayers()) {
            player.playSound(location, sound, category, volume, pitch);
        }
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        if (entity == null || entity.getWorld() != this || sound == null || category == null) {
            return;
        }
        for (Player player : this.getPlayers()) {
            player.playSound(entity, sound, category, volume, pitch);
        }
    }

    public String[] getGameRules() {
        return this.gameRules.values().stream().map(Object::toString).collect(Collectors.toList()).toArray(new String[0]);
    }

    @Deprecated
    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        GameRule gameRule = GameRule.getByName((String)rule);
        if (gameRule == null) {
            return null;
        }
        return this.getGameRuleValue(gameRule).toString();
    }

    @Deprecated
    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null) {
            return false;
        }
        GameRule gameRule = GameRule.getByName((String)rule);
        if (gameRule == null) {
            return false;
        }
        if (gameRule.getType().equals(Boolean.TYPE) && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
            return this.setGameRule(gameRule, value.equalsIgnoreCase("true"));
        }
        if (gameRule.getType().equals(Integer.TYPE)) {
            try {
                int intValue = Integer.parseInt(value);
                return this.setGameRule(gameRule, intValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isGameRule(String rule) {
        return rule != null && GameRule.getByName((String)rule) != null;
    }

    public WorldBorder getWorldBorder() {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(@NotNull Particle particle, @Nullable List<Player> receivers, @Nullable Player source, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data, boolean force) {
        throw new UnimplementedOperationException();
    }

    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public <T> T getGameRuleValue(GameRule<T> rule) {
        return rule.getType().cast(this.gameRules.get(rule));
    }

    public <T> T getGameRuleDefault(GameRule<T> rule) {
        throw new UnimplementedOperationException();
    }

    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        this.gameRules.put(rule, newValue);
        return true;
    }

    public boolean isChunkGenerated(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        throw new UnimplementedOperationException();
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        throw new UnimplementedOperationException();
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        throw new UnimplementedOperationException();
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        throw new UnimplementedOperationException();
    }

    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location locateNearestBiome(@NotNull Location origin, @NotNull Biome biome, int radius) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location locateNearestBiome(@NotNull Location origin, @NotNull Biome biome, int radius, int step) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean isUltrawarm() {
        throw new UnimplementedOperationException();
    }

    public double getCoordinateScale() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean hasSkylight() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean hasBedrockCeiling() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean doesBedWork() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean doesRespawnAnchorWork() {
        throw new UnimplementedOperationException();
    }

    public boolean isFixedTime() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Collection<Material> getInfiniburn() {
        throw new UnimplementedOperationException();
    }

    public void sendGameEvent(@Nullable Entity sourceEntity, @NotNull GameEvent gameEvent, @NotNull Vector position) {
        throw new UnimplementedOperationException();
    }

    public boolean isChunkForceLoaded(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public void setChunkForceLoaded(int x, int z, boolean forced) {
        throw new UnimplementedOperationException();
    }

    public Collection<Chunk> getForceLoadedChunks() {
        throw new UnimplementedOperationException();
    }

    public boolean addPluginChunkTicket(int x, int z, Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    public boolean removePluginChunkTicket(int x, int z, Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    public void removePluginChunkTickets(Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    public Collection<Plugin> getPluginChunkTickets(int x, int z) {
        throw new UnimplementedOperationException();
    }

    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        throw new UnimplementedOperationException();
    }

    public <T extends AbstractArrow> T spawnArrow(Location location, Vector direction, float speed, float spread, Class<T> clazz) {
        throw new UnimplementedOperationException();
    }

    public Raid locateNearestRaid(Location location, int radius) {
        throw new UnimplementedOperationException();
    }

    public List<Raid> getRaids() {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        throw new UnimplementedOperationException();
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        throw new UnimplementedOperationException();
    }

    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        throw new UnimplementedOperationException();
    }

    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        throw new UnimplementedOperationException();
    }

    public Block getHighestBlockAt(int x, int z, HeightMap heightMap) {
        throw new UnimplementedOperationException();
    }

    public Block getHighestBlockAt(Location location, HeightMap heightMap) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Biome getBiome(@NotNull Location location) {
        throw new UnimplementedOperationException();
    }

    public Biome getBiome(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Biome getComputedBiome(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public void setBiome(@NotNull Location location, @NotNull Biome biome) {
        throw new UnimplementedOperationException();
    }

    public void setBiome(int x, int y, int z, Biome bio) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockState getBlockState(@NotNull Location location) {
        BlockMock block = this.getBlockAt(location);
        return block.getState();
    }

    @NotNull
    public BlockState getBlockState(int x, int y, int z) {
        BlockMock block = this.getBlockAt(x, y, z);
        return block.getState();
    }

    @NotNull
    public BlockData getBlockData(@NotNull Location location) {
        BlockMock block = this.getBlockAt(location);
        return block.getBlockData();
    }

    @NotNull
    public BlockData getBlockData(int x, int y, int z) {
        BlockMock block = this.getBlockAt(x, y, z);
        return block.getBlockData();
    }

    @NotNull
    public Material getType(@NotNull Location location) {
        BlockMock block = this.getBlockAt(location);
        return block.getType();
    }

    @NotNull
    public Material getType(int x, int y, int z) {
        BlockMock block = this.getBlockAt(x, y, z);
        return block.getType();
    }

    public void setBlockData(@NotNull Location location, @NotNull BlockData blockData) {
        BlockMock block = this.getBlockAt(location);
        block.setBlockData(blockData);
    }

    public void setBlockData(int x, int y, int z, @NotNull BlockData blockData) {
        BlockMock block = this.getBlockAt(x, y, z);
        block.setBlockData(blockData);
    }

    public void setType(@NotNull Location location, @NotNull Material material) {
        BlockMock block = this.getBlockAt(location);
        block.setType(material);
    }

    public void setType(int x, int y, int z, @NotNull Material material) {
        BlockMock block = this.getBlockAt(x, y, z);
        block.setType(material);
    }

    public boolean generateTree(@NotNull Location location, @NotNull Random random, @NotNull TreeType type) {
        throw new UnimplementedOperationException();
    }

    public boolean generateTree(@NotNull Location location, @NotNull Random random, @NotNull TreeType type, @Nullable Consumer<BlockState> stateConsumer) {
        throw new UnimplementedOperationException();
    }

    public double getTemperature(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public double getHumidity(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    public int getLogicalHeight() {
        throw new UnimplementedOperationException();
    }

    public boolean isNatural() {
        throw new UnimplementedOperationException();
    }

    public boolean isBedWorks() {
        throw new UnimplementedOperationException();
    }

    public boolean hasSkyLight() {
        throw new UnimplementedOperationException();
    }

    public boolean hasCeiling() {
        throw new UnimplementedOperationException();
    }

    public boolean isPiglinSafe() {
        throw new UnimplementedOperationException();
    }

    public boolean isRespawnAnchorWorks() {
        throw new UnimplementedOperationException();
    }

    public boolean hasRaids() {
        throw new UnimplementedOperationException();
    }

    public boolean isUltraWarm() {
        throw new UnimplementedOperationException();
    }

    public boolean isHardcore() {
        throw new UnimplementedOperationException();
    }

    public void setHardcore(boolean hardcore) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public long getTicksPerWaterSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public long getTicksPerAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        throw new UnimplementedOperationException();
    }

    public DragonBattle getEnderDragonBattle() {
        throw new UnimplementedOperationException();
    }

    public boolean setSpawnLocation(int x, int y, int z, float angle) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public long getTicksPerWaterAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setTicksPerWaterAmbientSpawns(int ticksPerAmbientSpawns) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public long getTicksPerWaterUndergroundCreatureSpawns() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setTicksPerWaterUndergroundCreatureSpawns(int ticksPerWaterUndergroundCreatureSpawns) {
        throw new UnimplementedOperationException();
    }

    public int getWaterAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    public void setWaterAmbientSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    public int getViewDistance() {
        throw new UnimplementedOperationException();
    }

    public void setViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public void setSimulationDistance(int simulationDistance) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getNoTickViewDistance() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setNoTickViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public int getSendViewDistance() {
        throw new UnimplementedOperationException();
    }

    public void setSendViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public World.Spigot spigot() {
        throw new UnimplementedOperationException();
    }

    public boolean isClearWeather() {
        throw new UnimplementedOperationException();
    }

    public int getClearWeatherDuration() {
        throw new UnimplementedOperationException();
    }

    public void setClearWeatherDuration(int duration) {
        throw new UnimplementedOperationException();
    }

    public long getGameTime() {
        throw new UnimplementedOperationException();
    }

    public int getSimulationDistance() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public long getTicksPerSpawns(@NotNull SpawnCategory spawnCategory) {
        throw new UnimplementedOperationException();
    }

    public void setTicksPerSpawns(@NotNull SpawnCategory spawnCategory, int ticksPerCategorySpawn) {
        throw new UnimplementedOperationException();
    }

    public int getSpawnLimit(@NotNull SpawnCategory spawnCategory) {
        throw new UnimplementedOperationException();
    }

    public void setSpawnLimit(@NotNull SpawnCategory spawnCategory, int limit) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public NamespacedKey getKey() {
        throw new UnimplementedOperationException();
    }
}

