/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.meta.BookMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.EnchantedBookMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.FireworkEffectMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.FireworkMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.KnowledgeBookMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.LeatherArmorMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.PotionMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.SkullMetaMock;
import be.seeseemelk.mockbukkit.inventory.meta.SuspiciousStewMetaMock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Random;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ItemFactoryMock
implements ItemFactory {
    private final Color defaultLeatherColor = Color.fromRGB((int)10511680);

    private Class<? extends ItemMeta> getItemMetaClass(Material material) {
        switch (material) {
            case WRITABLE_BOOK: 
            case WRITTEN_BOOK: {
                return BookMetaMock.class;
            }
            case ENCHANTED_BOOK: {
                return EnchantedBookMetaMock.class;
            }
            case KNOWLEDGE_BOOK: {
                return KnowledgeBookMetaMock.class;
            }
            case LEATHER_BOOTS: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_HELMET: 
            case LEATHER_LEGGINGS: {
                return LeatherArmorMetaMock.class;
            }
            case MAP: {
                throw new UnimplementedOperationException();
            }
            case FIREWORK_STAR: {
                return FireworkEffectMetaMock.class;
            }
            case FIREWORK_ROCKET: {
                return FireworkMetaMock.class;
            }
            case POTION: 
            case LINGERING_POTION: 
            case SPLASH_POTION: {
                return PotionMetaMock.class;
            }
            case PLAYER_HEAD: {
                return SkullMetaMock.class;
            }
            case SUSPICIOUS_STEW: {
                return SuspiciousStewMetaMock.class;
            }
            case TROPICAL_FISH_BUCKET: {
                throw new UnimplementedOperationException();
            }
        }
        return ItemMetaMock.class;
    }

    public ItemMeta getItemMeta(Material material) {
        Class<? extends ItemMeta> clazz = null;
        try {
            clazz = this.getItemMetaClass(material);
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Can't instantiate class '" + clazz + "'");
        }
    }

    public boolean isApplicable(ItemMeta meta, ItemStack stack) {
        return this.isApplicable(meta, stack.getType());
    }

    public boolean isApplicable(ItemMeta meta, Material material) {
        Class<? extends ItemMeta> target = this.getItemMetaClass(material);
        return target.isInstance(meta);
    }

    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        return Objects.equals(meta1, meta2);
    }

    public ItemMeta asMetaFor(ItemMeta meta, ItemStack stack) {
        return this.asMetaFor(meta, stack.getType());
    }

    public ItemMeta asMetaFor(ItemMeta meta, Material material) {
        Class<? extends ItemMeta> target = this.getItemMetaClass(material);
        try {
            for (Constructor<?> constructor : target.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(meta.getClass())) continue;
                return (ItemMeta)constructor.newInstance(meta);
            }
            throw new NoSuchMethodException("Cannot find an ItemMeta constructor for the class \"" + meta.getClass().getName() + "\"");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Color getDefaultLeatherColor() {
        return this.defaultLeatherColor;
    }

    @NotNull
    public ItemStack createItemStack(@NotNull String input) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public Material updateMaterial(ItemMeta meta, Material material) {
        return material;
    }

    @NotNull
    public ItemStack enchantWithLevels(@NotNull ItemStack itemStack, @Range(from=1L, to=30L) int levels, boolean allowTreasure, @NotNull Random random) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(@NotNull ItemStack item, @NotNull UnaryOperator<HoverEvent.ShowItem> op) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Component displayName(@NotNull ItemStack itemStack) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @Nullable
    public String getI18NDisplayName(@Nullable ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack ensureServerConversions(@NotNull ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull ItemStack itemStack) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull Entity entity, @Nullable String customName) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull Entity entity, @Nullable BaseComponent customName) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public Content hoverContentOf(@NotNull Entity entity, @NotNull BaseComponent[] customName) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ItemStack getSpawnEgg(@Nullable EntityType type) {
        throw new UnimplementedOperationException();
    }
}

