/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scoreboard.ScoreMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardMock;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectiveMock
implements Objective {
    private ScoreboardMock scoreboard;
    private final String name;
    private final String criteria;
    private final Map<String, ScoreMock> scores = new HashMap<String, ScoreMock>();
    private Component displayName;
    private DisplaySlot displaySlot;
    private RenderType renderType;

    public ObjectiveMock(@NotNull ScoreboardMock scoreboard, @NotNull String name, @NotNull String displayName, @NotNull String criteria, @NotNull RenderType renderType) {
        Validate.notNull((Object)scoreboard, (String)"When registering an Objective to the Scoreboard the scoreboard cannot be null.");
        Validate.notNull((Object)name, (String)"The name cannot be null");
        Validate.notNull((Object)criteria, (String)"The criteria cannot be null");
        this.scoreboard = scoreboard;
        this.name = name;
        this.displayName = Component.text((String)displayName);
        this.criteria = criteria;
        this.renderType = renderType;
    }

    private void validate() throws IllegalStateException {
        if (!this.isRegistered()) {
            throw new IllegalStateException("This objective is no longer registered.");
        }
    }

    public String getName() throws IllegalStateException {
        this.validate();
        return this.name;
    }

    @NotNull
    public Component displayName() throws IllegalStateException {
        return this.displayName;
    }

    public void displayName(@Nullable Component displayName) throws IllegalStateException, IllegalArgumentException {
        this.displayName = displayName;
    }

    @Deprecated
    public String getDisplayName() throws IllegalStateException {
        this.validate();
        return LegacyComponentSerializer.legacySection().serialize(this.displayName);
    }

    @Deprecated
    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)displayName, (String)"The display name cannot be null");
        Validate.isTrue((displayName.length() <= 128 ? 1 : 0) != 0, (String)"The display name cannot be longer than 128 characters");
        this.validate();
        this.displayName = LegacyComponentSerializer.legacySection().deserialize(displayName);
    }

    public String getCriteria() throws IllegalStateException {
        this.validate();
        return this.criteria;
    }

    public ScoreboardMock getScoreboard() {
        return this.scoreboard;
    }

    public void unregister() throws IllegalStateException {
        this.validate();
        this.scoreboard.unregister(this);
        this.scoreboard = null;
    }

    public boolean isRegistered() {
        return this.scoreboard != null && this.scoreboard.getObjectives().contains(this);
    }

    public void setDisplaySlot(@Nullable DisplaySlot slot) throws IllegalStateException {
        this.validate();
        this.displaySlot = slot;
        this.scoreboard.setDisplaySlot(this, slot);
    }

    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        this.validate();
        return this.displaySlot;
    }

    public void setRenderType(@NotNull RenderType renderType) throws IllegalStateException {
        this.validate();
        this.renderType = renderType;
    }

    public RenderType getRenderType() throws IllegalStateException {
        this.validate();
        return this.renderType;
    }

    @Deprecated
    public ScoreMock getScore(@NotNull OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"The player cannot be null");
        this.validate();
        return this.getScore(player.getName());
    }

    public ScoreMock getScore(@NotNull String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)entry, (String)"The entry cannot be null");
        Validate.isTrue((entry.length() <= 40 ? 1 : 0) != 0, (String)"Objective entries cannot be longer than 40 characters");
        this.validate();
        ScoreMock score = this.scores.get(entry);
        if (score != null) {
            return score;
        }
        score = new ScoreMock(this, entry);
        this.scores.put(entry, score);
        return score;
    }

    @NotNull
    public Score getScoreFor(@NotNull Entity entity) throws IllegalArgumentException, IllegalStateException {
        throw new UnimplementedOperationException();
    }

    public boolean isModifiable() throws IllegalStateException {
        throw new UnimplementedOperationException();
    }
}

