/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scoreboard.ObjectiveMock;
import be.seeseemelk.mockbukkit.scoreboard.TeamMock;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardMock
implements Scoreboard {
    private Map<String, ObjectiveMock> objectives = new HashMap<String, ObjectiveMock>();
    private Map<DisplaySlot, ObjectiveMock> objectivesByDisplaySlot = new EnumMap<DisplaySlot, ObjectiveMock>(DisplaySlot.class);
    private Map<String, Team> teams = new HashMap<String, Team>();

    @Deprecated
    public ObjectiveMock registerNewObjective(String name, String criteria) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, name, RenderType.INTEGER);
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String name, @NotNull String criteria, @Nullable Component displayName) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String name, @NotNull String criteria, @Nullable Component displayName, @NotNull RenderType renderType) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public ObjectiveMock registerNewObjective(String name, String criteria, String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @Deprecated
    public ObjectiveMock registerNewObjective(String name, String criteria, String displayName, RenderType renderType) throws IllegalArgumentException {
        ObjectiveMock objective = new ObjectiveMock(this, name, displayName, criteria, renderType);
        this.objectives.put(name, objective);
        return objective;
    }

    public ObjectiveMock getObjective(String name) throws IllegalArgumentException {
        return this.objectives.get(name);
    }

    public Set<Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        return this.objectives.values().stream().filter(objective -> objective.getCriteria().equals(criteria)).collect(Collectors.toSet());
    }

    public Set<Objective> getObjectives() {
        return Collections.unmodifiableSet(new HashSet<ObjectiveMock>(this.objectives.values()));
    }

    public ObjectiveMock getObjective(DisplaySlot slot) throws IllegalArgumentException {
        return this.objectivesByDisplaySlot.get(slot);
    }

    public Set<Score> getScores(OfflinePlayer player) throws IllegalArgumentException {
        return this.getScores(player.getName());
    }

    public Set<Score> getScores(String entry) throws IllegalArgumentException {
        HashSet<Score> scores = new HashSet<Score>();
        for (Objective objective : this.objectives.values()) {
            scores.add(objective.getScore(entry));
        }
        return scores;
    }

    public void resetScores(OfflinePlayer player) throws IllegalArgumentException {
        this.resetScores(player.getName());
    }

    public void resetScores(String entry) throws IllegalArgumentException {
        for (Objective objective : this.objectives.values()) {
            objective.getScore(entry).setScore(0);
        }
    }

    public Team getPlayerTeam(OfflinePlayer player) throws IllegalArgumentException {
        return this.getEntryTeam(player.getName());
    }

    public Team getEntryTeam(String entry) throws IllegalArgumentException {
        for (Team t : this.teams.values()) {
            if (!t.hasEntry(entry)) continue;
            return t;
        }
        return null;
    }

    public Team getTeam(String teamName) throws IllegalArgumentException {
        return this.teams.get(teamName);
    }

    public Set<Team> getTeams() {
        return Collections.unmodifiableSet(new HashSet<Team>(this.teams.values()));
    }

    public Team registerNewTeam(String name) throws IllegalArgumentException {
        TeamMock team = new TeamMock(name, this);
        this.teams.put(name, team);
        return team;
    }

    @Deprecated
    public Set<OfflinePlayer> getPlayers() {
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (Team t : this.teams.values()) {
            players.addAll(t.getPlayers());
        }
        return players;
    }

    public Set<String> getEntries() {
        HashSet<String> entries = new HashSet<String>();
        for (Team t : this.teams.values()) {
            entries.addAll(t.getEntries());
        }
        return entries;
    }

    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        this.objectivesByDisplaySlot.remove(slot);
    }

    @NotNull
    public Set<Score> getScoresFor(@NotNull Entity entity) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public void resetScoresFor(@NotNull Entity entity) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Team getEntityTeam(@NotNull Entity entity) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    protected void setDisplaySlot(@NotNull ObjectiveMock objective, DisplaySlot slot) {
        this.objectivesByDisplaySlot.put(slot, objective);
    }

    protected void unregister(@NotNull ObjectiveMock objectiveMock) {
        if (objectiveMock.getDisplaySlot() != null) {
            this.objectivesByDisplaySlot.remove(objectiveMock.getDisplaySlot());
        }
        this.objectives.remove(objectiveMock.getName());
    }
}

