/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamMock
implements Team {
    private final String name;
    private String displayName;
    private String prefix;
    private String suffix;
    private ChatColor color;
    private boolean allowFriendlyFire = false;
    private final HashSet<String> entries;
    private boolean canSeeFriendly = true;
    private EnumMap<Team.Option, Team.OptionStatus> options = new EnumMap(Team.Option.class);
    private boolean registered;
    private Scoreboard board;

    public TeamMock(String name, Scoreboard board) {
        this.name = name;
        this.board = board;
        this.registered = true;
        this.entries = new HashSet();
        this.options.put(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
    }

    public String getName() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.name;
    }

    @NotNull
    public Component displayName() throws IllegalStateException {
        throw new UnimplementedOperationException();
    }

    public void displayName(@Nullable Component displayName) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Component prefix() throws IllegalStateException {
        throw new UnimplementedOperationException();
    }

    public void prefix(@Nullable Component prefix) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Component suffix() throws IllegalStateException {
        throw new UnimplementedOperationException();
    }

    public void suffix(@Nullable Component suffix) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public boolean hasColor() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public TextColor color() throws IllegalStateException {
        throw new UnimplementedOperationException();
    }

    public void color(@Nullable NamedTextColor color) {
        throw new UnimplementedOperationException();
    }

    public String getDisplayName() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.displayName;
    }

    public void setDisplayName(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.displayName = s;
    }

    public String getPrefix() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.prefix;
    }

    public void setPrefix(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.prefix = s;
    }

    public String getSuffix() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.suffix;
    }

    public void setSuffix(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.suffix = s;
    }

    public ChatColor getColor() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.color;
    }

    public void setColor(ChatColor chatColor) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.color = chatColor;
    }

    public boolean allowFriendlyFire() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.allowFriendlyFire;
    }

    public void setAllowFriendlyFire(boolean b) throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.allowFriendlyFire = b;
    }

    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.canSeeFriendly;
    }

    public void setCanSeeFriendlyInvisibles(boolean b) throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.canSeeFriendly = b;
    }

    @Deprecated
    public NameTagVisibility getNameTagVisibility() {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        Team.OptionStatus s = this.options.get(Team.Option.NAME_TAG_VISIBILITY);
        switch (s) {
            case NEVER: {
                return NameTagVisibility.NEVER;
            }
            case ALWAYS: {
                return NameTagVisibility.ALWAYS;
            }
            case FOR_OTHER_TEAMS: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case FOR_OWN_TEAM: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Option not compatible");
    }

    @Deprecated
    public void setNameTagVisibility(NameTagVisibility nameTagVisibility) {
        MockBukkit.getMock().getLogger().log(Level.WARNING, "Consider USE setOption() DEPRECATED");
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        switch (nameTagVisibility) {
            case ALWAYS: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
                return;
            }
            case NEVER: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
                return;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OTHER_TEAMS);
                return;
            }
            case HIDE_FOR_OWN_TEAM: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OWN_TEAM);
                return;
            }
        }
        throw new IllegalArgumentException("Option not compatible");
    }

    @Deprecated
    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (String s : this.entries) {
            OfflinePlayer player;
            if (s == null || (player = MockBukkit.getMock().getOfflinePlayer(s)) == null) continue;
            players.add(player);
        }
        return players;
    }

    public Set<String> getEntries() throws IllegalStateException {
        return this.entries;
    }

    public int getSize() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.size();
    }

    public Scoreboard getScoreboard() {
        return this.board;
    }

    @Deprecated
    public void addPlayer(OfflinePlayer offlinePlayer) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.entries.add(offlinePlayer.getName());
    }

    public void addEntry(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.entries.add(s);
    }

    public void addEntities(@NotNull Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public void addEntries(@NotNull Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public boolean removePlayer(OfflinePlayer offlinePlayer) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.remove(offlinePlayer.getName());
    }

    public boolean removeEntry(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.remove(s);
    }

    public boolean removeEntities(@NotNull Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public boolean removeEntries(@NotNull Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public void unregister() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.registered = false;
    }

    @Deprecated
    public boolean hasPlayer(OfflinePlayer offlinePlayer) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.contains(offlinePlayer.getName());
    }

    public boolean hasEntry(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.contains(s);
    }

    public Team.OptionStatus getOption(Team.Option option) throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.options.get(option);
    }

    public void setOption(Team.Option option, Team.OptionStatus optionStatus) throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.options.put(option, optionStatus);
    }

    public void addEntity(@NotNull Entity entity) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public boolean removeEntity(@NotNull Entity entity) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public boolean hasEntity(@NotNull Entity entity) throws IllegalStateException, IllegalArgumentException {
        throw new UnimplementedOperationException();
    }
}

