/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.statistic;

import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class StatisticsMock {
    private final Map<Statistic, Integer> untypedStatistics = new EnumMap<Statistic, Integer>(Statistic.class);
    private final Map<Statistic, Map<Material, Integer>> materialStatistics = new EnumMap<Statistic, Map<Material, Integer>>(Statistic.class);
    private final Map<Statistic, Map<EntityType, Integer>> entityStatistics = new EnumMap<Statistic, Map<EntityType, Integer>>(Statistic.class);

    public void setStatistic(@NotNull Statistic statistic, int amount) {
        Validate.isTrue((amount >= 0 ? 1 : 0) != 0, (String)"amount must be greater than or equal to 0");
        Validate.isTrue((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (String)"statistic must be provided with parameter");
        this.untypedStatistics.put(statistic, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        Validate.isTrue((amount >= 0 ? 1 : 0) != 0, (String)"amount must be greater than or equal to 0");
        Validate.isTrue((statistic.getType() == Statistic.Type.ITEM || statistic.getType() == Statistic.Type.BLOCK ? 1 : 0) != 0, (String)"statistic must take a material parameter");
        this.materialStatistics.computeIfAbsent(statistic, k -> new EnumMap(Material.class)).put(material, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull EntityType entity, int amount) {
        Validate.isTrue((amount >= 0 ? 1 : 0) != 0, (String)"amount must be greater than or equal to 0");
        Validate.isTrue((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (String)"statistic must take an entity parameter");
        this.entityStatistics.computeIfAbsent(statistic, k -> new EnumMap(EntityType.class)).put(entity, amount);
    }

    public void incrementStatistic(@NotNull Statistic statistic, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be greater than 0");
        this.setStatistic(statistic, this.getStatistic(statistic) + amount);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be greater than 0");
        this.setStatistic(statistic, material, this.getStatistic(statistic, material) + amount);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entity, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be greater than 0");
        this.setStatistic(statistic, entity, this.getStatistic(statistic, entity) + amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be greater than 0");
        this.setStatistic(statistic, this.getStatistic(statistic) - amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be greater than 0");
        this.setStatistic(statistic, material, this.getStatistic(statistic, material) - amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entity, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be greater than 0");
        this.setStatistic(statistic, entity, this.getStatistic(statistic, entity) - amount);
    }

    public int getStatistic(@NotNull Statistic statistic) {
        Validate.isTrue((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (String)"statistic must be provided with parameter");
        return this.untypedStatistics.getOrDefault(statistic, 0);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        Validate.isTrue((statistic.getType() == Statistic.Type.ITEM || statistic.getType() == Statistic.Type.BLOCK ? 1 : 0) != 0, (String)"statistic must take a material parameter");
        Map<Material, Integer> map = this.materialStatistics.get(statistic);
        if (map == null) {
            return 0;
        }
        return map.getOrDefault(material, 0);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull EntityType entity) {
        Validate.isTrue((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (String)"statistic must take an entity parameter");
        Map<EntityType, Integer> map = this.entityStatistics.get(statistic);
        if (map == null) {
            return 0;
        }
        return map.getOrDefault(entity, 0);
    }
}

