/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.tags;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.tags.TagMisconfigurationException;
import be.seeseemelk.mockbukkit.tags.TagRegistry;
import be.seeseemelk.mockbukkit.tags.TagWrapperMock;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

public final class TagsMock {
    private TagsMock() {
    }

    public static void loadDefaultTags(@NotNull ServerMock server, boolean skipIfExists) {
        try {
            TagsMock.loadRegistry(server, TagRegistry.BLOCKS, skipIfExists);
        }
        catch (IOException | URISyntaxException e) {
            server.getLogger().log(Level.SEVERE, "Failed to load Tag Registry \"blocks\"", e);
        }
        try {
            TagsMock.loadRegistry(server, TagRegistry.ITEMS, skipIfExists);
        }
        catch (IOException | URISyntaxException e) {
            server.getLogger().log(Level.SEVERE, "Failed to load Tag Registry \"items\"", e);
        }
    }

    private static void loadRegistry(@NotNull ServerMock server, @NotNull TagRegistry registry, boolean skipIfExists) throws URISyntaxException, IOException {
        if (skipIfExists && !registry.isEmpty()) {
            server.addTagRegistry(registry);
            return;
        }
        Pattern filePattern = Pattern.compile("\\.");
        URL resource = MockBukkit.class.getClassLoader().getResource("tags/" + registry.getRegistry());
        TagsMock.loadFileSystem(resource.toURI());
        Path directory = Paths.get(resource.toURI());
        try (Stream<Path> stream = Files.walk(directory, 1, new FileVisitOption[0]);){
            stream.skip(1L).filter(path -> {
                boolean isDirectory = Files.isDirectory(path, new LinkOption[0]);
                boolean isTagFormat = !path.getFileName().toString().startsWith("_");
                return !isDirectory && isTagFormat;
            }).forEach(path -> {
                String name = filePattern.split(path.getFileName().toString())[0];
                NamespacedKey key = NamespacedKey.minecraft((String)name);
                TagWrapperMock tag = new TagWrapperMock(registry, key);
                registry.getTags().put(key, tag);
            });
        }
        server.addTagRegistry(registry);
        for (TagWrapperMock tag : registry.getTags().values()) {
            try {
                tag.reload();
            }
            catch (TagMisconfigurationException e) {
                server.getLogger().log(Level.SEVERE, e, () -> "Failed to load Tag - " + tag.getKey());
            }
        }
    }

    @NotNull
    private static FileSystem loadFileSystem(@NotNull URI uri) throws IOException {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            return FileSystems.newFileSystem(uri, env);
        }
        catch (IllegalArgumentException | FileSystemAlreadyExistsException e) {
            return FileSystems.getDefault();
        }
    }
}

