/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.MockBanList;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.BanList;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPlayerList {
    private int maxPlayers = Integer.MAX_VALUE;
    private final Set<PlayerMock> onlinePlayers = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<OfflinePlayer> offlinePlayers = Collections.synchronizedSet(new HashSet());
    @NotNull
    private final BanList ipBans = new MockBanList();
    @NotNull
    private final BanList profileBans = new MockBanList();

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @NotNull
    public BanList getIPBans() {
        return this.ipBans;
    }

    @NotNull
    public BanList getProfileBans() {
        return this.profileBans;
    }

    public void addPlayer(@NotNull PlayerMock player) {
        this.onlinePlayers.add(player);
        this.offlinePlayers.add((OfflinePlayer)player);
    }

    public void disconnectPlayer(@NotNull PlayerMock player) {
        this.onlinePlayers.remove(player);
    }

    public void addOfflinePlayer(@NotNull OfflinePlayer player) {
        this.offlinePlayers.add(player);
    }

    @NotNull
    public Set<OfflinePlayer> getOperators() {
        return Stream.concat(this.onlinePlayers.stream(), this.offlinePlayers.stream()).filter(ServerOperator::isOp).collect(Collectors.toSet());
    }

    @NotNull
    public Collection<PlayerMock> getOnlinePlayers() {
        return Collections.unmodifiableSet(this.onlinePlayers);
    }

    @NotNull
    public @NotNull OfflinePlayer @NotNull [] getOfflinePlayers() {
        return this.offlinePlayers.toArray(new OfflinePlayer[0]);
    }

    public boolean isSomeoneOnline() {
        return !this.onlinePlayers.isEmpty();
    }

    @NotNull
    public List<Player> matchPlayer(@NotNull String name) {
        return this.onlinePlayers.stream().filter(player -> player.getName().toLowerCase(Locale.ENGLISH).startsWith(name.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
    }

    @Nullable
    public Player getPlayerExact(@NotNull String name) {
        return this.onlinePlayers.stream().filter(player -> player.getName().toLowerCase(Locale.ENGLISH).equals(name.toLowerCase(Locale.ENGLISH))).findFirst().orElse(null);
    }

    @Nullable
    public Player getPlayer(@NotNull String name) {
        Player player = this.getPlayerExact(name);
        if (player != null) {
            return player;
        }
        String lowercase = name.toLowerCase(Locale.ENGLISH);
        int delta = Integer.MAX_VALUE;
        for (Player player2 : this.onlinePlayers) {
            int currentDelta;
            if (!player2.getName().toLowerCase(Locale.ENGLISH).startsWith(lowercase) || (currentDelta = Math.abs(player2.getName().length() - lowercase.length())) >= delta) continue;
            delta = currentDelta;
            player = player2;
        }
        return player;
    }

    @Nullable
    public Player getPlayer(@NotNull UUID id) {
        for (Player player : this.onlinePlayers) {
            if (!id.equals(player.getUniqueId())) continue;
            return player;
        }
        return null;
    }

    @NotNull
    public PlayerMock getPlayer(int num) {
        return List.copyOf(this.onlinePlayers).get(num);
    }

    @NotNull
    public OfflinePlayer getOfflinePlayer(@NotNull String name) {
        Player player = this.getPlayer(name);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!offlinePlayer.getName().equals(name)) continue;
            return offlinePlayer;
        }
        return new OfflinePlayerMock(name);
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer(@NotNull UUID id) {
        Player player = this.getPlayer(id);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer offlinePlayer : this.getOfflinePlayers()) {
            if (!offlinePlayer.getUniqueId().equals(id)) continue;
            return offlinePlayer;
        }
        return null;
    }

    public void clearOnlinePlayers() {
        this.onlinePlayers.clear();
    }

    public void clearOfflinePlayers() {
        this.offlinePlayers.clear();
    }
}

