/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import com.destroystokyo.paper.MaterialTags;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Bed;
import org.jetbrains.annotations.NotNull;

public class BedMock
extends BlockDataMock
implements Bed {
    private static final String PART = "part";
    private static final String OCCUPIED = "occupied";
    private static final String FACING = "facing";

    public BedMock(@NotNull Material type) {
        super(type);
        this.checkType(type, (Tag<Material>)MaterialTags.BEDS);
        this.setFacing(BlockFace.NORTH);
        super.set(OCCUPIED, false);
        this.setPart(Bed.Part.FOOT);
    }

    @NotNull
    public Bed.Part getPart() {
        return (Bed.Part)super.get(PART);
    }

    public void setPart(@NotNull Bed.Part part) {
        super.set(PART, part);
    }

    public boolean isOccupied() {
        return (Boolean)super.get(OCCUPIED);
    }

    @NotNull
    public BlockFace getFacing() {
        return (BlockFace)super.get(FACING);
    }

    public void setFacing(@NotNull BlockFace facing) {
        if (!this.getFaces().contains(facing)) {
            throw new IllegalArgumentException("Invalid face: " + facing);
        }
        super.set(FACING, facing);
    }

    @NotNull
    public Set<BlockFace> getFaces() {
        return Set.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    }
}

