/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.BlockMock;
import be.seeseemelk.mockbukkit.block.state.BannerMock;
import be.seeseemelk.mockbukkit.block.state.BarrelMock;
import be.seeseemelk.mockbukkit.block.state.BeaconMock;
import be.seeseemelk.mockbukkit.block.state.BedMock;
import be.seeseemelk.mockbukkit.block.state.BeehiveMock;
import be.seeseemelk.mockbukkit.block.state.BellMock;
import be.seeseemelk.mockbukkit.block.state.BlastFurnaceMock;
import be.seeseemelk.mockbukkit.block.state.BrewingStandMock;
import be.seeseemelk.mockbukkit.block.state.CampfireMock;
import be.seeseemelk.mockbukkit.block.state.ChestMock;
import be.seeseemelk.mockbukkit.block.state.CommandBlockMock;
import be.seeseemelk.mockbukkit.block.state.ComparatorMock;
import be.seeseemelk.mockbukkit.block.state.ConduitMock;
import be.seeseemelk.mockbukkit.block.state.CreatureSpawnerMock;
import be.seeseemelk.mockbukkit.block.state.DaylightDetectorMock;
import be.seeseemelk.mockbukkit.block.state.DispenserMock;
import be.seeseemelk.mockbukkit.block.state.DropperMock;
import be.seeseemelk.mockbukkit.block.state.EnchantingTableMock;
import be.seeseemelk.mockbukkit.block.state.EndGatewayMock;
import be.seeseemelk.mockbukkit.block.state.EnderChestMock;
import be.seeseemelk.mockbukkit.block.state.HopperMock;
import be.seeseemelk.mockbukkit.block.state.JigsawMock;
import be.seeseemelk.mockbukkit.block.state.JukeboxMock;
import be.seeseemelk.mockbukkit.block.state.LecternMock;
import be.seeseemelk.mockbukkit.block.state.SculkCatalystMock;
import be.seeseemelk.mockbukkit.block.state.SculkSensorMock;
import be.seeseemelk.mockbukkit.block.state.SculkShriekerMock;
import be.seeseemelk.mockbukkit.block.state.ShulkerBoxMock;
import be.seeseemelk.mockbukkit.block.state.SignMock;
import be.seeseemelk.mockbukkit.block.state.SkullMock;
import be.seeseemelk.mockbukkit.block.state.SmokerMock;
import be.seeseemelk.mockbukkit.block.state.StructureMock;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import com.destroystokyo.paper.MaterialTags;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStateMock
implements BlockState {
    @NotNull
    private final MetadataTable metadataTable;
    @Nullable
    private Block block;
    private Material material;

    public BlockStateMock(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        this.metadataTable = new MetadataTable();
        this.material = material;
    }

    protected BlockStateMock(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        this.metadataTable = new MetadataTable();
        this.block = block;
        this.material = block.getType();
    }

    protected BlockStateMock(@NotNull BlockStateMock state) {
        Preconditions.checkNotNull((Object)state, (Object)"BlockStateMock cannot be null");
        this.metadataTable = new MetadataTable(state.metadataTable);
        this.material = state.getType();
        this.block = state.isPlaced() ? state.getBlock() : null;
    }

    protected void checkType(@NotNull Material material, Material ... expected) {
        Preconditions.checkArgument((boolean)Arrays.stream(expected).anyMatch(m -> material == m), (Object)("Cannot create a " + this.getClass().getSimpleName() + " from " + material));
    }

    protected void checkType(@NotNull Block block, Material ... expected) {
        this.checkType(block.getType(), expected);
    }

    protected void checkType(@NotNull Material material, @NotNull Tag<Material> tag) {
        Preconditions.checkArgument((boolean)tag.isTagged((Keyed)material), (Object)("Cannot create a " + this.getClass().getSimpleName() + " from " + material));
    }

    protected void checkType(@NotNull Block block, @NotNull Tag<Material> expected) {
        this.checkType(block.getType(), expected);
    }

    public void setMetadata(String metadataKey, @NotNull MetadataValue newMetadataValue) {
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    @NotNull
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.metadataTable.getMetadata(metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.metadataTable.hasMetadata(metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    @NotNull
    public Block getBlock() {
        if (this.block == null) {
            throw new IllegalStateException("This BlockState has not been placed!");
        }
        return this.block;
    }

    @Deprecated
    public @NotNull MaterialData getData() {
        return new MaterialData(this.material);
    }

    @NotNull
    public Material getType() {
        return this.material;
    }

    public byte getLightLevel() {
        return this.getBlock().getLightLevel();
    }

    @NotNull
    public World getWorld() {
        return this.getBlock().getWorld();
    }

    public int getX() {
        return this.getBlock().getX();
    }

    public int getY() {
        return this.getBlock().getY();
    }

    public int getZ() {
        return this.getBlock().getZ();
    }

    @NotNull
    public Location getLocation() {
        return this.getBlock().getLocation();
    }

    public Location getLocation(Location loc) {
        return this.getBlock().getLocation(loc);
    }

    @NotNull
    public Chunk getChunk() {
        return this.getBlock().getChunk();
    }

    @Deprecated
    public void setData(@NotNull MaterialData data) {
        this.material = data.getItemType();
    }

    public void setType(Material type) {
        this.material = type;
    }

    public boolean update() {
        return this.update(false);
    }

    public boolean update(boolean force) {
        return this.update(force, true);
    }

    public boolean update(boolean force, boolean applyPhysics) {
        if (!this.isPlaced()) {
            return true;
        }
        Block b = this.getBlock();
        if (b.getType() != this.getType() && !force) {
            return false;
        }
        b.setType(this.getType());
        if (b instanceof BlockMock) {
            BlockMock bm = (BlockMock)b;
            bm.setState(this);
        }
        return true;
    }

    @Deprecated
    public byte getRawData() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setRawData(byte data) {
        throw new UnimplementedOperationException();
    }

    public boolean isPlaced() {
        return this.block != null;
    }

    public boolean isCollidable() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockData getBlockData() {
        throw new UnimplementedOperationException();
    }

    public void setBlockData(BlockData data) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public BlockState getSnapshot() {
        return new BlockStateMock(this);
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + (this.isPlaced() ? this.getWorld().hashCode() : 0);
        hash = 31 * hash + (this.isPlaced() ? this.getLocation().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockStateMock)) {
            return false;
        }
        BlockStateMock other = (BlockStateMock)obj;
        if (this.isPlaced() && this.getWorld() != other.getWorld() && (this.getWorld() == null || !this.getWorld().equals(other.getWorld()))) {
            return false;
        }
        return !this.isPlaced() || this.getLocation() == other.getLocation() || this.getLocation() != null && this.getLocation().equals((Object)other.getLocation());
    }

    @NotNull
    public static BlockStateMock mockState(@NotNull Block block) {
        if (Tag.BANNERS.isTagged((Keyed)block.getType())) {
            return new BannerMock(block);
        }
        if (MaterialTags.SHULKER_BOXES.isTagged(block.getType())) {
            return new ShulkerBoxMock(block);
        }
        if (MaterialTags.SIGNS.isTagged(block.getType())) {
            return new SignMock(block);
        }
        if (MaterialTags.BEDS.isTagged(block)) {
            return new BedMock(block);
        }
        if (MaterialTags.SKULLS.isTagged(block)) {
            return new SkullMock(block);
        }
        switch (block.getType()) {
            case STRUCTURE_BLOCK: {
                return new StructureMock(block);
            }
            case SMOKER: {
                return new SmokerMock(block);
            }
            case END_GATEWAY: {
                return new EndGatewayMock(block);
            }
            case SCULK_CATALYST: {
                return new SculkCatalystMock(block);
            }
            case SCULK_SHRIEKER: {
                return new SculkShriekerMock(block);
            }
            case SCULK_SENSOR: {
                return new SculkSensorMock(block);
            }
            case BEACON: {
                return new BeaconMock(block);
            }
            case BEEHIVE: {
                return new BeehiveMock(block);
            }
            case BREWING_STAND: {
                return new BrewingStandMock(block);
            }
            case BLAST_FURNACE: {
                return new BlastFurnaceMock(block);
            }
            case COMPARATOR: {
                return new ComparatorMock(block);
            }
            case CONDUIT: {
                return new ConduitMock(block);
            }
            case ENCHANTING_TABLE: {
                return new EnchantingTableMock(block);
            }
            case JIGSAW: {
                return new JigsawMock(block);
            }
            case JUKEBOX: {
                return new JukeboxMock(block);
            }
            case SPAWNER: {
                return new CreatureSpawnerMock(block);
            }
            case DAYLIGHT_DETECTOR: {
                return new DaylightDetectorMock(block);
            }
            case COMMAND_BLOCK: 
            case CHAIN_COMMAND_BLOCK: 
            case REPEATING_COMMAND_BLOCK: {
                return new CommandBlockMock(block);
            }
            case CAMPFIRE: 
            case SOUL_CAMPFIRE: {
                return new CampfireMock(block);
            }
            case BELL: {
                return new BellMock(block);
            }
            case LECTERN: {
                return new LecternMock(block);
            }
            case HOPPER: {
                return new HopperMock(block);
            }
            case BARREL: {
                return new BarrelMock(block);
            }
            case DISPENSER: {
                return new DispenserMock(block);
            }
            case DROPPER: {
                return new DropperMock(block);
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                return new ChestMock(block);
            }
            case ENDER_CHEST: {
                return new EnderChestMock(block);
            }
        }
        return new BlockStateMock(block);
    }
}

