/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.command;

import be.seeseemelk.mockbukkit.command.MessageTarget;
import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

public class CommandResult {
    private final boolean success;
    @NotNull
    private final MessageTarget sender;

    public CommandResult(boolean success, @NotNull MessageTarget sender) {
        Preconditions.checkNotNull((Object)sender, (Object)"Sender cannot be null");
        this.success = success;
        this.sender = sender;
    }

    public boolean hasSucceeded() {
        return this.success;
    }

    public void assertSucceeded() {
        Assertions.assertTrue((boolean)this.success);
    }

    public void assertFailed() {
        Assertions.assertFalse((boolean)this.success);
    }

    public void assertResponse(String message) {
        String received = this.sender.nextMessage();
        if (received != null) {
            Assertions.assertEquals((Object)message, (Object)received);
        } else {
            Assertions.fail((String)"No more messages");
        }
    }

    public void assertResponse(@NotNull String format, Object ... objects) {
        this.assertResponse(String.format(format, objects));
    }

    public void assertNoResponse() {
        if (this.sender.nextMessage() != null) {
            Assertions.fail((String)"More messages");
        }
    }
}

