/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.command;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleCommandSenderMock
implements ConsoleCommandSender,
MessageTarget {
    private final CommandSender.Spigot spigot = new CommandSender.Spigot();
    private final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private final Queue<Component> messages = new LinkedList<Component>();

    public void sendMessage(@NotNull String message) {
        this.sendRawMessage(message);
    }

    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public void sendMessage(@Nullable UUID sender, @NotNull String message) {
        this.sendRawMessage(message);
    }

    public void sendMessage(UUID sender, String ... messages) {
        this.sendMessage(messages);
    }

    @Override
    @Nullable
    public Component nextComponentMessage() {
        return this.messages.poll();
    }

    public boolean isPermissionSet(@NotNull String name) {
        return this.perm.isPermissionSet(name);
    }

    public boolean isPermissionSet(@NotNull Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    public boolean hasPermission(@NotNull String name) {
        return this.perm.hasPermission(name);
    }

    public boolean hasPermission(@NotNull Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @NotNull
    public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @NotNull
    public PermissionAttachment addAttachment(@NotNull Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(@NotNull Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    public void removeAttachment(@NotNull PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @NotNull
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public boolean isOp() {
        return true;
    }

    public void setOp(boolean value) {
        throw new UnsupportedOperationException("Cannot change operator status of server console");
    }

    @NotNull
    public Server getServer() {
        MockBukkit.ensureMocking();
        return MockBukkit.getMock();
    }

    @NotNull
    public String getName() {
        return "CONSOLE";
    }

    public boolean isConversing() {
        throw new UnimplementedOperationException();
    }

    public void acceptConversationInput(@NotNull String input) {
        throw new UnimplementedOperationException();
    }

    public boolean beginConversation(@NotNull Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(@NotNull Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(@NotNull Conversation conversation, @NotNull ConversationAbandonedEvent details) {
        throw new UnimplementedOperationException();
    }

    public void sendRawMessage(@NotNull String message) {
        this.sendRawMessage(null, message);
    }

    public void sendRawMessage(@Nullable UUID sender, @NotNull String message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
        this.messages.add((Component)LegacyComponentSerializer.legacySection().deserialize(message));
    }

    @NotNull
    public CommandSender.Spigot spigot() {
        return this.spigot;
    }

    @NotNull
    public Component name() {
        return Component.text((String)this.getName());
    }
}

