/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.AnimalsMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import net.kyori.adventure.util.TriState;
import org.bukkit.Location;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeMock
extends AnimalsMock
implements Bee {
    @Nullable
    private Location hive;
    @Nullable
    private Location flower;
    private boolean nectar = false;
    private boolean hasStung = false;
    private int anger = 0;
    private int cannotEnterHiveTicks = 0;
    @NotNull
    private TriState rollingOverride = TriState.NOT_SET;

    public BeeMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @Nullable
    public Location getHive() {
        return this.hive;
    }

    public void setHive(@Nullable Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Hive must be in same world");
        this.hive = location;
    }

    @Nullable
    public Location getFlower() {
        return this.flower;
    }

    public void setFlower(@Nullable Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        this.flower = location;
    }

    public boolean hasNectar() {
        return this.nectar;
    }

    public void setHasNectar(boolean nectar) {
        this.nectar = nectar;
    }

    public boolean hasStung() {
        return this.hasStung;
    }

    public void setHasStung(boolean stung) {
        this.hasStung = stung;
    }

    public int getAnger() {
        return this.anger;
    }

    public void setAnger(int anger) {
        this.anger = anger;
    }

    public int getCannotEnterHiveTicks() {
        return this.cannotEnterHiveTicks;
    }

    public void setCannotEnterHiveTicks(int ticks) {
        this.cannotEnterHiveTicks = ticks;
    }

    public void setRollingOverride(@NotNull TriState rolling) {
        Preconditions.checkNotNull((Object)rolling, (Object)"Rolling override cannot be null");
        this.rollingOverride = rolling;
    }

    @NotNull
    public TriState getRollingOverride() {
        return this.rollingOverride;
    }

    public boolean isRolling() {
        return this.rollingOverride.toBooleanOrElse(false);
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.BEE;
    }
}

