/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.AsyncCatcher;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.entity.LivingEntityMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryViewMock;
import be.seeseemelk.mockbukkit.inventory.SimpleInventoryViewMock;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public abstract class HumanEntityMock
extends LivingEntityMock
implements HumanEntity {
    @Nullable
    private PlayerInventoryMock inventory = null;
    private InventoryView inventoryView;
    @Nullable
    private ItemStack cursor = null;
    @NotNull
    private GameMode gameMode = GameMode.SURVIVAL;
    @Nullable
    private Location lastDeathLocation = new Location((World)new WorldMock(), 0.0, 0.0, 0.0);
    protected int expLevel = 0;
    private float saturation = 5.0f;
    private int foodLevel = 20;

    protected HumanEntityMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public void assertGameMode(GameMode expectedGamemode) {
        Assertions.assertEquals((Object)expectedGamemode, (Object)this.gameMode);
    }

    @NotNull
    public PlayerInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = (PlayerInventoryMock)Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.PLAYER);
        }
        return this.inventory;
    }

    public void closeInventory() {
        this.closeInventory(InventoryCloseEvent.Reason.PLUGIN);
    }

    public void closeInventory(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull InventoryCloseEvent.Reason reason) {
        if (this.inventoryView instanceof PlayerInventoryViewMock) {
            new InventoryCloseEvent(this.inventoryView, reason).callEvent();
            Inventory inventory = this.inventoryView.getTopInventory();
            if (inventory instanceof InventoryMock) {
                InventoryMock inventoryMock = (InventoryMock)inventory;
                inventoryMock.removeViewer(this);
            }
        }
        this.cursor = null;
        this.inventoryView = new SimpleInventoryViewMock(this, null, this.inventory, InventoryType.CRAFTING);
    }

    @NotNull
    public InventoryView getOpenInventory() {
        return this.inventoryView;
    }

    public void openInventory(@NotNull InventoryView inventory) {
        Preconditions.checkNotNull((Object)inventory, (Object)"Inventory cannot be null");
        this.closeInventory();
        this.inventoryView = inventory;
    }

    public InventoryView openInventory(@NotNull Inventory inventory) {
        AsyncCatcher.catchOp("open inventory");
        Preconditions.checkNotNull((Object)inventory, (Object)"Inventory cannot be null");
        this.closeInventory();
        if (inventory instanceof InventoryMock) {
            InventoryMock inventoryMock = (InventoryMock)inventory;
            inventoryMock.addViewers(this);
        }
        this.inventoryView = new PlayerInventoryViewMock(this, inventory);
        return this.inventoryView;
    }

    @NotNull
    public ItemStack getItemOnCursor() {
        return this.cursor == null ? new ItemStack(Material.AIR, 0) : this.cursor.clone();
    }

    public void setItemOnCursor(@Nullable ItemStack item) {
        this.cursor = item == null ? null : item.clone();
    }

    @Nullable
    public Location getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void setLastDeathLocation(@Nullable Location location) {
        this.lastDeathLocation = location;
    }

    @NotNull
    public GameMode getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(@NotNull GameMode mode) {
        Preconditions.checkNotNull((Object)mode, (Object)"GameMode cannot be null");
        if (this.gameMode == mode) {
            return;
        }
        this.gameMode = mode;
    }

    public boolean setWindowProperty(@NotNull InventoryView.Property prop, int value) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public InventoryView openMerchant(@NotNull Villager trader, boolean force) {
        Preconditions.checkNotNull((Object)trader, (Object)"Trader cannot be null");
        return this.openMerchant((Merchant)trader, force);
    }

    public InventoryView openMerchant(@NotNull Merchant merchant, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openAnvil(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openCartographyTable(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openGrindstone(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openLoom(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openSmithingTable(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InventoryView openStonecutter(@Nullable Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public ItemStack getItemInHand() {
        return this.getInventory().getItemInMainHand();
    }

    public void setItemInHand(@Nullable ItemStack item) {
        this.getInventory().setItemInMainHand(item);
    }

    public boolean hasCooldown(@NotNull Material material) {
        throw new UnimplementedOperationException();
    }

    public int getCooldown(@NotNull Material material) {
        throw new UnimplementedOperationException();
    }

    public void setCooldown(@NotNull Material material, int ticks) {
        throw new UnimplementedOperationException();
    }

    public boolean isDeeplySleeping() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSleeping() {
        throw new UnimplementedOperationException();
    }

    public int getSleepTicks() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Location getPotentialBedLocation() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public FishHook getFishHook() {
        throw new UnimplementedOperationException();
    }

    public boolean sleep(@NotNull Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    public void wakeup(boolean setSpawnLocation) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Location getBedLocation() {
        throw new UnimplementedOperationException();
    }

    public boolean isBlocking() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isHandRaised() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public ItemStack getItemInUse() {
        throw new UnimplementedOperationException();
    }

    public int getExpToLevel() {
        if (this.expLevel >= 31) {
            return 9 * this.expLevel - 158;
        }
        if (this.expLevel >= 16) {
            return 5 * this.expLevel - 38;
        }
        return 2 * this.expLevel + 7;
    }

    @Nullable
    public Entity releaseLeftShoulderEntity() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Entity releaseRightShoulderEntity() {
        throw new UnimplementedOperationException();
    }

    public float getAttackCooldown() {
        throw new UnimplementedOperationException();
    }

    public boolean discoverRecipe(@NotNull NamespacedKey recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"Recipe cannot be null");
        return this.discoverRecipes(Collections.singletonList(recipe)) != 0;
    }

    public int discoverRecipes(@NotNull Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    public boolean undiscoverRecipe(@NotNull NamespacedKey recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"Recipe cannot be null");
        return this.undiscoverRecipes(Collections.singletonList(recipe)) != 0;
    }

    public int undiscoverRecipes(@NotNull Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    public boolean hasDiscoveredRecipe(@NotNull NamespacedKey recipe) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<NamespacedKey> getDiscoveredRecipes() {
        throw new UnimplementedOperationException();
    }

    public Entity getShoulderEntityLeft() {
        throw new UnimplementedOperationException();
    }

    public void setShoulderEntityLeft(Entity entity) {
        throw new UnimplementedOperationException();
    }

    public Entity getShoulderEntityRight() {
        throw new UnimplementedOperationException();
    }

    public void setShoulderEntityRight(Entity entity) {
        throw new UnimplementedOperationException();
    }

    public void openSign(@NotNull Sign sign) {
        throw new UnimplementedOperationException();
    }

    public boolean dropItem(boolean dropAll) {
        throw new UnimplementedOperationException();
    }

    public float getExhaustion() {
        throw new UnimplementedOperationException();
    }

    public void setExhaustion(float value) {
        throw new UnimplementedOperationException();
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float value) {
        this.saturation = Math.min((float)this.getFoodLevel(), value);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public void setFoodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
    }

    public int getSaturatedRegenRate() {
        throw new UnimplementedOperationException();
    }

    public void setSaturatedRegenRate(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getUnsaturatedRegenRate() {
        throw new UnimplementedOperationException();
    }

    public void setUnsaturatedRegenRate(int ticks) {
        throw new UnimplementedOperationException();
    }

    public int getStarvationRate() {
        throw new UnimplementedOperationException();
    }

    public void setStarvationRate(int ticks) {
        throw new UnimplementedOperationException();
    }
}

