/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.AnimalsMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.entity.Pig;
import org.jetbrains.annotations.NotNull;

public class PigMock
extends AnimalsMock
implements Pig {
    private boolean hasSaddle = false;
    private int boostTicks = ThreadLocalRandom.current().nextInt(841) + 140;
    private int currentBoostTicks = 0;

    public PigMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public boolean hasSaddle() {
        return this.hasSaddle;
    }

    public void setSaddle(boolean saddled) {
        this.hasSaddle = saddled;
    }

    public int getBoostTicks() {
        return this.boostTicks;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be bigger than or equal to 0");
        this.boostTicks = ticks;
    }

    public int getCurrentBoostTicks() {
        return this.currentBoostTicks;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.hasSaddle) {
            return;
        }
        Preconditions.checkArgument((ticks >= 0 && ticks <= this.boostTicks ? 1 : 0) != 0, (Object)"Current Boost Ticks must be less than Boost Ticks (#getBoostTicks)");
        this.currentBoostTicks = ticks;
    }

    @NotNull
    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }
}

