/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.FishMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.PufferFish;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PufferFishMock
extends FishMock
implements PufferFish {
    private int puffState = 0;

    public PufferFishMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @Override
    @NotNull
    public ItemStack getBaseBucketItem() {
        return new ItemStack(Material.PUFFERFISH_BUCKET);
    }

    public int getPuffState() {
        return this.puffState;
    }

    public void setPuffState(int state) {
        Preconditions.checkArgument((state >= 0 && state <= 2 ? 1 : 0) != 0, (Object)"State has to be between 0 and 2");
        this.puffState = state;
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.PUFFERFISH;
    }
}

