/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInventoryMock
extends InventoryMock
implements PlayerInventory,
EntityEquipment {
    protected static final int HOTBAR = 0;
    protected static final int SLOT_BAR = 9;
    protected static final int BOOTS = 36;
    protected static final int LEGGINGS = 37;
    protected static final int CHESTPLATE = 38;
    protected static final int HELMET = 39;
    protected static final int OFF_HAND = 40;
    private int mainHandSlot = 0;

    public PlayerInventoryMock(HumanEntity holder) {
        super((InventoryHolder)holder, InventoryType.PLAYER);
    }

    public HumanEntity getHolder() {
        return (HumanEntity)super.getHolder();
    }

    @Override
    public ItemStack @NotNull [] getStorageContents() {
        return Arrays.copyOfRange(this.getContents(), 0, 36);
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        throw new UnimplementedOperationException("setStorageContests has not been implemented for Player Inventories");
    }

    public ItemStack @NotNull [] getArmorContents() {
        return Arrays.copyOfRange(this.getContents(), 36, 40);
    }

    public ItemStack @NotNull [] getExtraContents() {
        return Arrays.copyOfRange(this.getContents(), 40, 41);
    }

    public ItemStack getHelmet() {
        return this.getItem(39);
    }

    public ItemStack getChestplate() {
        return this.getItem(38);
    }

    public ItemStack getLeggings() {
        return this.getItem(37);
    }

    public ItemStack getBoots() {
        return this.getItem(36);
    }

    public void setArmorContents(ItemStack @Nullable [] items) {
        if (items == null) {
            throw new NullPointerException("ItemStack was null");
        }
        if (items.length > 4) {
            throw new IllegalArgumentException("ItemStack array too large (max: 4, was: " + items.length + ")");
        }
        items = items.length == 4 ? items : Arrays.copyOf(items, 4);
        this.setItem(36, items[0]);
        this.setItem(37, items[1]);
        this.setItem(38, items[2]);
        this.setItem(39, items[3]);
    }

    public float getItemInHandDropChance() {
        return 1.0f;
    }

    public void setItemInHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getItemInMainHandDropChance() {
        return 1.0f;
    }

    public void setItemInMainHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getItemInOffHandDropChance() {
        return 1.0f;
    }

    public void setItemInOffHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getHelmetDropChance() {
        return 1.0f;
    }

    public void setHelmetDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getChestplateDropChance() {
        return 1.0f;
    }

    public void setChestplateDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getLeggingsDropChance() {
        return 1.0f;
    }

    public void setLeggingsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getBootsDropChance() {
        return 1.0f;
    }

    public void setBootsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public void setExtraContents(ItemStack @Nullable [] items) {
        if (items == null) {
            throw new NullPointerException("ItemStack was null");
        }
        if (items.length > 1) {
            throw new IllegalArgumentException("ItemStack array too large (max: 4, was: " + items.length + ")");
        }
        items = items.length == 1 ? items : Arrays.copyOf(items, 1);
        this.setItem(40, items[0]);
    }

    public void setHelmet(ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    public void setHelmet(@Nullable ItemStack helmet, boolean silent) {
        this.setItem(39, helmet);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    public void setChestplate(@Nullable ItemStack chestplate, boolean silent) {
        this.setItem(38, chestplate);
    }

    public void setLeggings(ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    public void setLeggings(@Nullable ItemStack leggings, boolean silent) {
        this.setItem(37, leggings);
    }

    public void setBoots(ItemStack boots) {
        this.setBoots(boots, false);
    }

    public void setBoots(@Nullable ItemStack boots, boolean silent) {
        this.setItem(36, boots);
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        return this.notNull(this.getItem(9 + this.mainHandSlot));
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    public void setItemInMainHand(@Nullable ItemStack item, boolean silent) {
        this.setItem(9 + this.mainHandSlot, item);
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        return this.notNull(this.getItem(40));
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    public void setItemInOffHand(@Nullable ItemStack item, boolean silent) {
        this.setItem(40, item);
    }

    @Deprecated
    @NotNull
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Deprecated
    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> this.getChestplate();
            case EquipmentSlot.FEET -> this.getBoots();
            case EquipmentSlot.HAND -> this.getItemInMainHand();
            case EquipmentSlot.HEAD -> this.getHelmet();
            case EquipmentSlot.LEGS -> this.getLeggings();
            case EquipmentSlot.OFF_HAND -> this.getItemInOffHand();
            default -> new ItemStack(Material.AIR);
        };
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        this.setItem(slot, item, false);
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item, boolean silent) {
        switch (slot) {
            case CHEST: {
                this.setChestplate(item);
                break;
            }
            case FEET: {
                this.setBoots(item);
                break;
            }
            case HAND: {
                this.setItemInMainHand(item);
                break;
            }
            case HEAD: {
                this.setHelmet(item);
                break;
            }
            case LEGS: {
                this.setLeggings(item);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item);
                break;
            }
        }
    }

    public int getHeldItemSlot() {
        return this.mainHandSlot;
    }

    public void setHeldItemSlot(int slot) {
        if (slot < 0 || slot > 8) {
            throw new ArrayIndexOutOfBoundsException("Slot should be within [0-8] (was: " + slot + ")");
        }
        this.mainHandSlot = slot;
    }

    public float getDropChance(@NotNull EquipmentSlot slot) {
        return 1.0f;
    }

    public void setDropChance(@NotNull EquipmentSlot slot, float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    @NotNull
    private ItemStack notNull(@Nullable ItemStack itemStack) {
        return itemStack == null ? new ItemStack(Material.AIR) : itemStack;
    }
}

