/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import java.util.Objects;
import org.bukkit.Color;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapMetaMock
extends ItemMetaMock
implements MapMeta {
    private static final byte SCALING_EMPTY = 0;
    private static final byte SCALING_TRUE = 1;
    private static final byte SCALING_FALSE = 2;
    private Integer mapId;
    @Nullable
    private MapView mapView;
    @Nullable
    private Color color;
    private byte scaling = 0;

    public MapMetaMock() {
    }

    public MapMetaMock(@NotNull MapMeta meta) {
        super((ItemMeta)meta);
        int n;
        if (meta.hasMapId()) {
            this.mapId = meta.getMapId();
        }
        this.mapView = meta.getMapView();
        this.color = meta.getColor();
        if (meta instanceof MapMetaMock) {
            MapMetaMock metaMock = (MapMetaMock)meta;
            n = metaMock.scaling;
        } else {
            n = meta.isScaling() ? 1 : 2;
        }
        this.scaling = (byte)n;
    }

    public boolean hasMapId() {
        return this.mapId != null;
    }

    public int getMapId() {
        if (this.mapId == null) {
            throw new IllegalStateException("Map ID is not set. Are you checking #hasMapId() first?");
        }
        return this.mapId;
    }

    public void setMapId(int id) {
        this.mapId = id;
    }

    public boolean hasMapView() {
        return this.mapView != null;
    }

    @Nullable
    public MapView getMapView() {
        return this.mapView;
    }

    public void setMapView(MapView map) {
        this.mapView = map;
    }

    public boolean isScaling() {
        return this.scaling == 1;
    }

    public void setScaling(boolean scaling) {
        this.scaling = (byte)(scaling ? 1 : 2);
    }

    public boolean hasLocationName() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public String getLocationName() {
        throw new UnimplementedOperationException();
    }

    public void setLocationName(@Nullable String name) {
        throw new UnimplementedOperationException();
    }

    public boolean hasColor() {
        return this.color != null;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    public void setColor(@Nullable Color color) {
        this.color = color;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.mapId == null ? 0 : this.mapId.hashCode());
        result = 31 * result + (this.mapView == null ? 0 : this.mapView.hashCode());
        result = 31 * result + this.scaling;
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MapMeta)) return false;
        MapMeta meta = (MapMeta)obj;
        if (!super.equals(obj)) return false;
        if (this.hasMapId() || meta.hasMapId()) {
            if (!Objects.equals(this.mapId, meta.getMapId())) return false;
        }
        if (!Objects.equals(this.mapView, meta.getMapView())) return false;
        if (!Objects.equals(this.color, meta.getColor())) return false;
        if (meta instanceof MapMetaMock) {
            MapMetaMock mapMeta = (MapMetaMock)meta;
            if (this.scaling != mapMeta.scaling) return false;
            return true;
        } else if (meta.isScaling()) {
            if (this.scaling != 1) return false;
            return true;
        } else if (this.scaling != 2) return false;
        return true;
    }

    @Override
    @NotNull
    public MapMetaMock clone() {
        MapMetaMock clone = (MapMetaMock)super.clone();
        clone.color = this.color;
        clone.mapId = this.mapId;
        clone.mapView = this.mapView;
        clone.scaling = this.scaling;
        return clone;
    }
}

