/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MetadataTable
implements Metadatable {
    @NotNull
    private final Map<String, Map<Plugin, MetadataValue>> metadata;

    public MetadataTable() {
        this.metadata = new HashMap<String, Map<Plugin, MetadataValue>>();
    }

    public MetadataTable(@NotNull MetadataTable table) {
        this.metadata = new HashMap<String, Map<Plugin, MetadataValue>>(table.metadata);
    }

    public void setMetadata(String metadataKey, @NotNull MetadataValue newMetadataValue) {
        Map values = this.metadata.computeIfAbsent(metadataKey, key -> new HashMap());
        values.put(newMetadataValue.getOwningPlugin(), newMetadataValue);
    }

    @NotNull
    public List<MetadataValue> getMetadata(String metadataKey) {
        return new ArrayList<MetadataValue>(this.metadata.get(metadataKey).values());
    }

    public boolean hasMetadata(String metadataKey) {
        return this.metadata.containsKey(metadataKey) && this.metadata.get(metadataKey).size() > 0;
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        if (this.metadata.containsKey(metadataKey)) {
            this.metadata.get(metadataKey).remove(owningPlugin);
        }
    }
}

