/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.plugin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ListenerEntry {
    private final Plugin plugin;
    private final Listener listener;
    @NotNull
    private final Method method;

    public ListenerEntry(Plugin plugin, Listener listener, @NotNull Method method) {
        this.plugin = plugin;
        this.listener = listener;
        this.method = method;
        method.setAccessible(true);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Listener getListener() {
        return this.listener;
    }

    @NotNull
    public Method getMethod() {
        return this.method;
    }

    public void invoke(Event event) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.method.invoke((Object)this.listener, event);
    }

    public void invokeUnsafe(Event event) {
        try {
            this.method.invoke((Object)this.listener, event);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCompatibleFor(Event event) {
        return this.method.getParameterCount() == 1 && this.method.getParameters()[0].getType().isInstance(event);
    }
}

