/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.profile;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerProfileMock
implements PlayerProfile {
    @Nullable
    private String name;
    @Nullable
    private UUID uuid;
    @NotNull
    private final Set<ProfileProperty> properties;

    public PlayerProfileMock(@NotNull OfflinePlayer player) {
        this(player.getName(), player.getUniqueId());
    }

    public PlayerProfileMock(@Nullable String name, @Nullable UUID uuid) {
        this.name = name;
        this.uuid = uuid;
        this.properties = new HashSet<ProfileProperty>();
    }

    public PlayerProfileMock(@NotNull PlayerProfileMock profile) {
        this.name = profile.getName();
        this.uuid = profile.getUniqueId();
        this.properties = new HashSet<ProfileProperty>(profile.getProperties());
    }

    @Deprecated
    @Nullable
    public UUID getUniqueId() {
        return this.getId();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public String setName(@Nullable String name) {
        String oldName = this.name;
        this.name = name;
        return oldName;
    }

    @Nullable
    public UUID getId() {
        return this.uuid;
    }

    @Nullable
    public UUID setId(@Nullable UUID uuid) {
        UUID oldUuid = this.uuid;
        this.uuid = uuid;
        return oldUuid;
    }

    @NotNull
    public PlayerTextures getTextures() {
        throw new UnimplementedOperationException();
    }

    public void setTextures(@Nullable PlayerTextures textures) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<ProfileProperty> getProperties() {
        return this.properties;
    }

    public boolean hasProperty(@Nullable String property) {
        return this.properties.stream().anyMatch(p -> p.getName().equals(property));
    }

    public void setProperty(@NotNull ProfileProperty property) {
        this.properties.add(property);
    }

    public void setProperties(@NotNull Collection<ProfileProperty> properties) {
        this.properties.addAll(properties);
    }

    public boolean removeProperty(@Nullable String property) {
        return this.properties.removeIf(p -> p.getName().equals(property));
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public boolean isComplete() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public CompletableFuture<PlayerProfile> update() {
        throw new UnimplementedOperationException();
    }

    public boolean completeFromCache() {
        throw new UnimplementedOperationException();
    }

    public boolean completeFromCache(boolean onlineMode) {
        throw new UnimplementedOperationException();
    }

    public boolean completeFromCache(boolean lookupUUID, boolean onlineMode) {
        throw new UnimplementedOperationException();
    }

    public boolean complete(boolean textures) {
        throw new UnimplementedOperationException();
    }

    public boolean complete(boolean textures, boolean onlineMode) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.getId() != null) {
            map.put("uniqueId", this.getId().toString());
        }
        if (this.getName() != null) {
            map.put("name", this.getName());
        }
        if (!this.properties.isEmpty()) {
            ArrayList<Map<String, Object>> propertiesData = new ArrayList<Map<String, Object>>();
            for (ProfileProperty property : this.properties) {
                propertiesData.add(PlayerProfileMock.serialize(property));
            }
            map.put("properties", propertiesData);
        }
        return map;
    }

    private static Map<String, Object> serialize(@NotNull ProfileProperty property) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", property.getName());
        map.put("value", property.getValue());
        if (property.isSigned()) {
            map.put("signature", property.getSignature());
        }
        return map;
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlayerProfileMock)) {
            return false;
        }
        PlayerProfileMock otherProfile = (PlayerProfileMock)obj;
        return Objects.equals(this.name, otherProfile.name) && this.uuid.equals(otherProfile.uuid) && this.properties.equals(otherProfile.properties);
    }

    @NotNull
    public String toString() {
        return "CraftPlayerProfile [uniqueId=" + this.getId() + ", name=" + this.getName() + "]";
    }

    public @NotNull org.bukkit.profile.PlayerProfile clone() {
        return new PlayerProfileMock(this);
    }

    public static void validateSkullProfile(@NotNull PlayerProfileMock profile) {
        boolean isValidSkullProfile = profile.getName() != null;
        Preconditions.checkArgument((boolean)isValidSkullProfile, (Object)"The skull profile is missing a name or textures!");
    }
}

