/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scheduler;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduledTask
implements BukkitTask {
    private final int id;
    private final Plugin plugin;
    private final boolean isSync;
    private boolean isCancelled = false;
    private long scheduledTick;
    private boolean running;
    @Nullable
    private final Runnable runnable;
    @Nullable
    private final Consumer<BukkitTask> consumer;
    private final List<Runnable> cancelListeners = new LinkedList<Runnable>();

    public ScheduledTask(int id, Plugin plugin, boolean isSync, long scheduledTick, @NotNull Runnable runnable) {
        this(id, plugin, isSync, scheduledTick, runnable, null);
        Preconditions.checkNotNull((Object)runnable, (Object)"Runnable cannot be null");
    }

    public ScheduledTask(int id, Plugin plugin, boolean isSync, long scheduledTick, @NotNull Consumer<BukkitTask> consumer) {
        this(id, plugin, isSync, scheduledTick, null, consumer);
        Preconditions.checkNotNull(consumer, (Object)"Consumer cannot be null");
    }

    private ScheduledTask(int id, Plugin plugin, boolean isSync, long scheduledTick, @Nullable Runnable runnable, @Nullable Consumer<BukkitTask> consumer) {
        this.id = id;
        this.plugin = plugin;
        this.isSync = isSync;
        this.scheduledTick = scheduledTick;
        this.runnable = runnable;
        this.consumer = consumer;
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public long getScheduledTick() {
        return this.scheduledTick;
    }

    protected void setScheduledTick(long scheduledTick) {
        this.scheduledTick = scheduledTick;
    }

    @Nullable
    public Runnable getRunnable() {
        return this.runnable;
    }

    @Nullable
    public Consumer<BukkitTask> getConsumer() {
        return this.consumer;
    }

    public void run() {
        if (!this.isCancelled()) {
            if (this.runnable != null) {
                this.runnable.run();
            }
            if (this.consumer != null) {
                this.consumer.accept(this);
            }
        } else {
            throw new CancellationException("Task is cancelled");
        }
    }

    public int getTaskId() {
        return this.id;
    }

    @NotNull
    public Plugin getOwner() {
        return this.plugin;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        this.isCancelled = true;
        this.cancelListeners.forEach(Runnable::run);
    }

    public void addOnCancelled(Runnable callback) {
        this.cancelListeners.add(callback);
    }
}

