/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scoreboard.ObjectiveMock;
import be.seeseemelk.mockbukkit.scoreboard.TeamMock;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardMock
implements Scoreboard {
    @NotNull
    private final Map<String, ObjectiveMock> objectives = new HashMap<String, ObjectiveMock>();
    @NotNull
    private final Map<DisplaySlot, ObjectiveMock> objectivesByDisplaySlot = new EnumMap<DisplaySlot, ObjectiveMock>(DisplaySlot.class);
    @NotNull
    private final Map<String, Team> teams = new HashMap<String, Team>();

    @Deprecated
    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull String criteria) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, name, RenderType.INTEGER);
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String name, @NotNull String criteria, @Nullable Component displayName) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String name, @NotNull String criteria, @Nullable Component displayName, @NotNull RenderType renderType) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String name, @NotNull Criteria criteria, @Nullable Component displayName) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String name, @NotNull Criteria criteria, @Nullable Component displayName, @NotNull RenderType renderType) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull String criteria, @NotNull String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @Deprecated
    @NotNull
    public ObjectiveMock registerNewObjective(@NotNull String name, @NotNull String criteria, @NotNull String displayName, @NotNull RenderType renderType) throws IllegalArgumentException {
        if (this.objectives.containsKey(name)) {
            throw new IllegalArgumentException("An objective of name '" + name + "' already exists");
        }
        ObjectiveMock objective = new ObjectiveMock(this, name, displayName, criteria, renderType);
        this.objectives.put(name, objective);
        return objective;
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String name, @NotNull Criteria criteria, @NotNull String displayName) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Objective registerNewObjective(@NotNull String name, @NotNull Criteria criteria, @NotNull String displayName, @NotNull RenderType renderType) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public ObjectiveMock getObjective(String name) throws IllegalArgumentException {
        return this.objectives.get(name);
    }

    @NotNull
    public Set<Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        return this.objectives.values().stream().filter(objective -> objective.getCriteria().equals(criteria)).collect(Collectors.toSet());
    }

    @NotNull
    public Set<Objective> getObjectivesByCriteria(@NotNull Criteria criteria) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<Objective> getObjectives() {
        return Collections.unmodifiableSet(new HashSet<ObjectiveMock>(this.objectives.values()));
    }

    public ObjectiveMock getObjective(DisplaySlot slot) throws IllegalArgumentException {
        return this.objectivesByDisplaySlot.get(slot);
    }

    @NotNull
    public Set<Score> getScores(@NotNull OfflinePlayer player) throws IllegalArgumentException {
        return this.getScores(player.getName());
    }

    @NotNull
    public Set<Score> getScores(@NotNull String entry) throws IllegalArgumentException {
        HashSet<Score> scores = new HashSet<Score>();
        for (Objective objective : this.objectives.values()) {
            scores.add(objective.getScore(entry));
        }
        return scores;
    }

    public void resetScores(@NotNull OfflinePlayer player) throws IllegalArgumentException {
        this.resetScores(player.getName());
    }

    public void resetScores(@NotNull String entry) throws IllegalArgumentException {
        for (Objective objective : this.objectives.values()) {
            objective.getScore(entry).setScore(0);
        }
    }

    public Team getPlayerTeam(@NotNull OfflinePlayer player) throws IllegalArgumentException {
        return this.getEntryTeam(player.getName());
    }

    public Team getEntryTeam(@NotNull String entry) throws IllegalArgumentException {
        for (Team t : this.teams.values()) {
            if (!t.hasEntry(entry)) continue;
            return t;
        }
        return null;
    }

    public Team getTeam(String teamName) throws IllegalArgumentException {
        return this.teams.get(teamName);
    }

    @NotNull
    public Set<Team> getTeams() {
        return Collections.unmodifiableSet(new HashSet<Team>(this.teams.values()));
    }

    @NotNull
    public Team registerNewTeam(@NotNull String name) throws IllegalArgumentException {
        if (this.teams.containsKey(name)) {
            throw new IllegalArgumentException("Team name '" + name + "' is already in use");
        }
        TeamMock team = new TeamMock(name, this);
        this.teams.put(name, team);
        return team;
    }

    @Deprecated
    @NotNull
    public Set<OfflinePlayer> getPlayers() {
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (Team t : this.teams.values()) {
            players.addAll(t.getPlayers());
        }
        return players;
    }

    @NotNull
    public Set<String> getEntries() {
        HashSet<String> entries = new HashSet<String>();
        for (Team t : this.teams.values()) {
            entries.addAll(t.getEntries());
        }
        return entries;
    }

    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        this.objectivesByDisplaySlot.remove(slot);
    }

    @NotNull
    public Set<Score> getScoresFor(@NotNull Entity entity) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    public void resetScoresFor(@NotNull Entity entity) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Team getEntityTeam(@NotNull Entity entity) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    protected void setDisplaySlot(@NotNull ObjectiveMock objective, DisplaySlot slot) {
        this.objectivesByDisplaySlot.put(slot, objective);
    }

    protected void unregister(@NotNull ObjectiveMock objectiveMock) {
        if (objectiveMock.getDisplaySlot() != null) {
            this.objectivesByDisplaySlot.remove(objectiveMock.getDisplaySlot());
        }
        this.objectives.remove(objectiveMock.getName());
    }

    protected void unregister(@NotNull TeamMock teamMock) {
        this.teams.remove(teamMock.getName());
    }
}

