/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.ChunkCoordinate;
import org.jetbrains.annotations.NotNull;

public class Coordinate {
    public final int x;
    public final int y;
    public final int z;

    public Coordinate(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coordinate() {
        this(0, 0, 0);
    }

    @NotNull
    public ChunkCoordinate toChunkCoordinate() {
        return new ChunkCoordinate(this.x >> 4, this.z >> 4);
    }

    @NotNull
    public Coordinate toLocalCoordinate() {
        return new Coordinate(this.x & 0xF, this.y, this.z & 0xF);
    }

    public int hashCode() {
        return this.x + (this.y << 8) + (this.z << 16);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coordinate) {
            Coordinate c = (Coordinate)obj;
            return this.x == c.x && this.y == c.y && this.z == c.z;
        }
        return false;
    }

    public String toString() {
        return "Coordinate{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }
}

