/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.MockBanList;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.BanList;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPlayerList {
    private int maxPlayers = Integer.MAX_VALUE;
    private final Set<PlayerMock> onlinePlayers = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<OfflinePlayer> offlinePlayers = Collections.synchronizedSet(new HashSet());
    private final Map<UUID, Long> lastLogins = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Long> lastSeen = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Long> firstPlayed = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Boolean> hasPlayedBefore = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final BanList ipBans = new MockBanList();
    @NotNull
    private final BanList profileBans = new MockBanList();
    private final Set<UUID> operators = Collections.synchronizedSet(new HashSet());

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @NotNull
    public BanList getIPBans() {
        return this.ipBans;
    }

    @NotNull
    public BanList getProfileBans() {
        return this.profileBans;
    }

    @ApiStatus.Internal
    public void addPlayer(@NotNull PlayerMock player) {
        this.firstPlayed.putIfAbsent(player.getUniqueId(), System.currentTimeMillis());
        this.lastLogins.put(player.getUniqueId(), System.currentTimeMillis());
        this.onlinePlayers.add(player);
        this.offlinePlayers.add((OfflinePlayer)player);
        this.hasPlayedBefore.put(player.getUniqueId(), this.hasPlayedBefore.containsKey(player.getUniqueId()));
    }

    @ApiStatus.Internal
    public void disconnectPlayer(@NotNull PlayerMock player) {
        this.lastSeen.put(player.getUniqueId(), System.currentTimeMillis());
        this.onlinePlayers.remove(player);
    }

    public boolean hasPlayedBefore(@NotNull UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID cannot be null");
        return this.hasPlayedBefore.getOrDefault(uuid, false);
    }

    @ApiStatus.Internal
    public void addOfflinePlayer(@NotNull OfflinePlayer player) {
        this.offlinePlayers.add(player);
    }

    public long getFirstPlayed(UUID uuid) {
        return this.firstPlayed.getOrDefault(uuid, 0L);
    }

    public void setFirstPlayed(UUID uuid, long firstPlayed) {
        Preconditions.checkArgument((firstPlayed > 0L ? 1 : 0) != 0, (Object)"First played time must be non-negative");
        this.firstPlayed.put(uuid, firstPlayed);
    }

    public long getLastSeen(UUID uuid) {
        OfflinePlayer player = this.getOfflinePlayer(uuid);
        if (player != null && player.isOnline()) {
            return System.currentTimeMillis();
        }
        return this.lastSeen.getOrDefault(uuid, 0L);
    }

    public void setLastSeen(UUID uuid, long lastSeen) {
        Preconditions.checkArgument((lastSeen > 0L ? 1 : 0) != 0, (Object)"Last seen time must be non-negative");
        this.lastSeen.put(uuid, lastSeen);
    }

    public long getLastLogin(UUID uuid) {
        return this.lastLogins.getOrDefault(uuid, 0L);
    }

    public void setLastLogin(UUID uuid, long lastLogin) {
        Preconditions.checkArgument((lastLogin > 0L ? 1 : 0) != 0, (Object)"Last login time must be non-negative");
        this.lastLogins.put(uuid, lastLogin);
    }

    @NotNull
    public Set<OfflinePlayer> getOperators() {
        return this.operators.stream().map(this::getOfflinePlayer).collect(Collectors.toSet());
    }

    @NotNull
    public Collection<PlayerMock> getOnlinePlayers() {
        return Collections.unmodifiableSet(this.onlinePlayers);
    }

    @NotNull
    public @NotNull OfflinePlayer @NotNull [] getOfflinePlayers() {
        return this.offlinePlayers.toArray(new OfflinePlayer[0]);
    }

    public boolean isSomeoneOnline() {
        return !this.onlinePlayers.isEmpty();
    }

    @NotNull
    public List<Player> matchPlayer(@NotNull String name) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        return this.onlinePlayers.stream().filter(player -> player.getName().toLowerCase(Locale.ENGLISH).startsWith(nameLower)).collect(Collectors.toList());
    }

    @Nullable
    public Player getPlayerExact(@NotNull String name) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        return this.onlinePlayers.stream().filter(player -> player.getName().toLowerCase(Locale.ENGLISH).equals(nameLower)).findFirst().orElse(null);
    }

    @Nullable
    public Player getPlayer(@NotNull String name) {
        Player player = this.getPlayerExact(name);
        if (player != null) {
            return player;
        }
        String lowercase = name.toLowerCase(Locale.ENGLISH);
        int delta = Integer.MAX_VALUE;
        for (Player player2 : this.onlinePlayers) {
            int currentDelta;
            if (!player2.getName().toLowerCase(Locale.ENGLISH).startsWith(lowercase) || (currentDelta = Math.abs(player2.getName().length() - lowercase.length())) >= delta) continue;
            delta = currentDelta;
            player = player2;
        }
        return player;
    }

    @Nullable
    public Player getPlayer(@NotNull UUID id) {
        for (Player player : this.onlinePlayers) {
            if (!id.equals(player.getUniqueId())) continue;
            return player;
        }
        return null;
    }

    @NotNull
    public PlayerMock getPlayer(int index) {
        return List.copyOf(this.onlinePlayers).get(index);
    }

    @NotNull
    public OfflinePlayer getOfflinePlayer(@NotNull String name) {
        Player player = this.getPlayer(name);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!name.equals(offlinePlayer.getName())) continue;
            return offlinePlayer;
        }
        return new OfflinePlayerMock(name);
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer(@NotNull UUID id) {
        Player player = this.getPlayer(id);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer offlinePlayer : this.getOfflinePlayers()) {
            if (!offlinePlayer.getUniqueId().equals(id)) continue;
            return offlinePlayer;
        }
        return null;
    }

    public void clearOnlinePlayers() {
        this.onlinePlayers.clear();
    }

    public void clearOfflinePlayers() {
        this.offlinePlayers.clear();
    }

    public void addOperator(UUID operator) {
        this.operators.add(operator);
    }

    public void removeOperator(UUID operator) {
        this.operators.remove(operator);
    }
}

