/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.data;

import be.seeseemelk.mockbukkit.block.data.BlockDataMock;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Switch;
import org.jetbrains.annotations.NotNull;

public class SwitchMock
extends BlockDataMock
implements Switch {
    public SwitchMock(@NotNull Material type) {
        super(type);
        Set possibleTypes = Tag.BUTTONS.getValues();
        possibleTypes.add(Material.LEVER);
        this.checkType(type, possibleTypes.toArray(new Material[0]));
        super.set("face", FaceAttachable.AttachedFace.WALL);
        super.set("facing", BlockFace.NORTH);
        super.set("powered", false);
    }

    public boolean isPowered() {
        return (Boolean)super.get("powered");
    }

    public void setPowered(boolean powered) {
        super.set("powered", powered);
    }

    @NotNull
    public FaceAttachable.AttachedFace getAttachedFace() {
        return (FaceAttachable.AttachedFace)super.get("face");
    }

    public void setAttachedFace(@NotNull FaceAttachable.AttachedFace face) {
        Preconditions.checkNotNull((Object)face, (Object)"AttachedFace cannot be null");
        super.set("face", face);
    }

    @NotNull
    public BlockFace getFacing() {
        return (BlockFace)super.get("facing");
    }

    public void setFacing(@NotNull BlockFace facing) {
        Preconditions.checkNotNull((Object)facing, (Object)"BlockFace cannot be null");
        Preconditions.checkArgument((boolean)this.getFaces().contains(facing), (Object)("Invalid face. Must be one of " + this.getFaces()));
        super.set("facing", facing);
    }

    @NotNull
    public Set<BlockFace> getFaces() {
        return Set.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    }

    @NotNull
    public Switch.Face getFace() {
        return Switch.Face.valueOf((String)this.getAttachedFace().name());
    }

    public void setFace(@NotNull Switch.Face face) {
        Preconditions.checkNotNull((Object)face, (Object)"BlockFace cannot be null");
        this.setAttachedFace(FaceAttachable.AttachedFace.valueOf((String)face.name()));
    }
}

