/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block.state;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.state.ContainerMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import be.seeseemelk.mockbukkit.inventory.ShulkerBoxInventoryMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerBoxMock
extends ContainerMock
implements ShulkerBox {
    @Nullable
    private final DyeColor color;
    private boolean isOpen = false;

    public ShulkerBoxMock(@NotNull Material material) {
        super(material);
        this.checkType(material, (Tag<Material>)Tag.SHULKER_BOXES);
        this.color = this.getFromMaterial(material);
    }

    protected ShulkerBoxMock(@NotNull Block block) {
        super(block);
        this.checkType(block, (Tag<Material>)Tag.SHULKER_BOXES);
        this.color = this.getFromMaterial(block.getType());
    }

    protected ShulkerBoxMock(@NotNull ShulkerBoxMock state) {
        super(state);
        this.color = state.color;
        this.isOpen = state.isOpen;
    }

    @Nullable
    private DyeColor getFromMaterial(@NotNull Material type) {
        Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null");
        return switch (type) {
            case Material.SHULKER_BOX -> null;
            case Material.WHITE_SHULKER_BOX -> DyeColor.WHITE;
            case Material.ORANGE_SHULKER_BOX -> DyeColor.ORANGE;
            case Material.MAGENTA_SHULKER_BOX -> DyeColor.MAGENTA;
            case Material.LIGHT_BLUE_SHULKER_BOX -> DyeColor.LIGHT_BLUE;
            case Material.YELLOW_SHULKER_BOX -> DyeColor.YELLOW;
            case Material.LIME_SHULKER_BOX -> DyeColor.LIME;
            case Material.PINK_SHULKER_BOX -> DyeColor.PINK;
            case Material.GRAY_SHULKER_BOX -> DyeColor.GRAY;
            case Material.LIGHT_GRAY_SHULKER_BOX -> DyeColor.LIGHT_GRAY;
            case Material.CYAN_SHULKER_BOX -> DyeColor.CYAN;
            case Material.PURPLE_SHULKER_BOX -> DyeColor.PURPLE;
            case Material.BLUE_SHULKER_BOX -> DyeColor.BLUE;
            case Material.BROWN_SHULKER_BOX -> DyeColor.BROWN;
            case Material.GREEN_SHULKER_BOX -> DyeColor.GREEN;
            case Material.RED_SHULKER_BOX -> DyeColor.RED;
            case Material.BLACK_SHULKER_BOX -> DyeColor.BLACK;
            default -> throw new IllegalArgumentException(type.name() + " is not a Shulker Box!");
        };
    }

    public void setLootTable(LootTable table) {
        throw new UnimplementedOperationException();
    }

    public LootTable getLootTable() {
        throw new UnimplementedOperationException();
    }

    public void setSeed(long seed) {
        throw new UnimplementedOperationException();
    }

    public long getSeed() {
        throw new UnimplementedOperationException();
    }

    public void open() {
        this.isOpen = true;
    }

    public void close() {
        this.isOpen = false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    @NotNull
    protected InventoryMock createInventory() {
        return new ShulkerBoxInventoryMock((InventoryHolder)this);
    }

    @Override
    @NotNull
    public BlockState getSnapshot() {
        return new ShulkerBoxMock(this);
    }

    @NotNull
    public DyeColor getColor() {
        if (this.color == null) {
            throw new NullPointerException("This Shulker Box has not been dyed");
        }
        return this.color;
    }

    public boolean isRefillEnabled() {
        throw new UnimplementedOperationException();
    }

    public boolean hasBeenFilled() {
        throw new UnimplementedOperationException();
    }

    public boolean hasPlayerLooted(@NotNull UUID player) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Long getLastLooted(@NotNull UUID player) {
        throw new UnimplementedOperationException();
    }

    public boolean setHasPlayerLooted(@NotNull UUID player, boolean looted) {
        throw new UnimplementedOperationException();
    }

    public boolean hasPendingRefill() {
        throw new UnimplementedOperationException();
    }

    public long getLastFilled() {
        throw new UnimplementedOperationException();
    }

    public long getNextRefill() {
        throw new UnimplementedOperationException();
    }

    public long setNextRefill(long refillAt) {
        throw new UnimplementedOperationException();
    }
}

