/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.MonsterMock;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.entity.AbstractSkeleton;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractSkeletonMock
extends MonsterMock
implements AbstractSkeleton {
    private boolean shouldBurnInDay = true;
    private boolean isChargingAttack = false;
    private final Map<LivingEntity, Pair<Float, Boolean>> attackedMobs = new HashMap<LivingEntity, Pair<Float, Boolean>>();

    protected AbstractSkeletonMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    @Deprecated
    public void setSkeletonType(Skeleton.SkeletonType type) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean shouldBurnInDay() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    public boolean isChargingAttack() {
        return this.isChargingAttack;
    }

    public void rangedAttack(@NotNull LivingEntity target, float charge) {
        Preconditions.checkNotNull((Object)target, (Object)"Entity cannot be null");
        Preconditions.checkArgument((charge < 1.0f && charge > 0.0f ? 1 : 0) != 0, (Object)"Charge needs to be between 0 and 1");
        this.attackedMobs.put(target, (Pair<Float, Boolean>)Pair.of((Object)Float.valueOf(charge), (Object)this.isChargingAttack));
    }

    public void setChargingAttack(boolean raiseHands) {
        this.isChargingAttack = raiseHands;
    }

    public void assertAttacked(LivingEntity entity, float charge) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        Preconditions.checkArgument((charge >= 0.0f && charge <= 1.0f ? 1 : 0) != 0, (Object)"Charge must be between 0 and 1");
        if (!this.attackedMobs.containsKey(entity) || ((Float)this.attackedMobs.get(entity).getLeft()).floatValue() != charge) {
            Assertions.fail();
        }
    }

    public void assertAggressiveAttack(LivingEntity entity, float charge) {
        this.assertAttacked(entity, charge);
        if (!((Boolean)this.attackedMobs.get(entity).getRight()).booleanValue()) {
            Assertions.fail();
        }
    }

    @Deprecated(forRemoval=true)
    public void assertAgressiveAttack(LivingEntity entity, float charge) {
        this.assertAggressiveAttack(entity, charge);
    }
}

