/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.AsyncCatcher;
import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.attribute.AttributeInstanceMock;
import be.seeseemelk.mockbukkit.entity.HumanEntityMock;
import be.seeseemelk.mockbukkit.entity.data.EntityState;
import be.seeseemelk.mockbukkit.map.MapViewMock;
import be.seeseemelk.mockbukkit.sound.AudioExperience;
import be.seeseemelk.mockbukkit.sound.SoundReceiver;
import be.seeseemelk.mockbukkit.statistic.StatisticsMock;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.Title;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.entity.RelativeTeleportFlag;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.util.TriState;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameEvent;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Instrument;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.Tag;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.event.world.GenericGameEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;

public class PlayerMock
extends HumanEntityMock
implements Player,
SoundReceiver {
    private static final Component DEFAULT_KICK_COMPONENT = Component.text((String)"You are not whitelisted on this server!");
    @NotNull
    private GameMode gamemode;
    @NotNull
    private GameMode previousGamemode;
    private boolean online;
    @Nullable
    private Component displayName;
    @Nullable
    private Component playerListName;
    @Nullable
    private Component playerListHeader;
    @Nullable
    private Component playerListFooter;
    private int expTotal;
    private float exp;
    private boolean sneaking;
    private boolean sprinting;
    private boolean allowFlight;
    private boolean flying;
    private boolean scaledHealth;
    private double healthScale;
    private Location compassTarget;
    @Nullable
    private Location bedSpawnLocation;
    @Nullable
    private InetSocketAddress address;
    private final PlayerSpigotMock playerSpigotMock;
    private final List<AudioExperience> heardSounds;
    private final Map<UUID, Set<Plugin>> hiddenPlayers;
    private final Set<UUID> hiddenPlayersDeprecated;
    private final Queue<String> title;
    private final Queue<String> subitles;
    private Scoreboard scoreboard;
    private final StatisticsMock statistics;
    private final Set<String> channels;
    private final List<ItemStack> consumedItems;

    public PlayerMock(@NotNull ServerMock server, @NotNull String name) {
        this(server, name, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)));
        this.online = false;
        this.scoreboard = server.getScoreboardManager().getMainScoreboard();
    }

    public PlayerMock(@NotNull ServerMock server, @NotNull String name, @NotNull UUID uuid) {
        super(server, uuid);
        this.previousGamemode = this.gamemode = GameMode.SURVIVAL;
        this.displayName = null;
        this.playerListName = null;
        this.playerListHeader = null;
        this.playerListFooter = null;
        this.expTotal = 0;
        this.exp = 0.0f;
        this.sneaking = false;
        this.sprinting = false;
        this.allowFlight = false;
        this.flying = false;
        this.scaledHealth = false;
        this.healthScale = 20.0;
        this.playerSpigotMock = new PlayerSpigotMock();
        this.heardSounds = new LinkedList<AudioExperience>();
        this.hiddenPlayers = new HashMap<UUID, Set<Plugin>>();
        this.hiddenPlayersDeprecated = new HashSet<UUID>();
        this.title = new LinkedTransferQueue<String>();
        this.subitles = new LinkedTransferQueue<String>();
        this.statistics = new StatisticsMock();
        this.channels = new HashSet<String>();
        this.consumedItems = new LinkedList<ItemStack>();
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.setName(name);
        this.setDisplayName(name);
        this.online = true;
        if (Bukkit.getWorlds().isEmpty()) {
            MockBukkit.getMock().addSimpleWorld("world");
        }
        this.setLocation(((World)Bukkit.getWorlds().get(0)).getSpawnLocation().clone());
        this.setCompassTarget(this.getLocation());
        this.closeInventory();
        ((AttributeInstanceMock)this.attributes.get(Attribute.GENERIC_MOVEMENT_SPEED)).setBaseValue(0.1f);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.address = new InetSocketAddress("192.0.2." + ((Random)random).nextInt(255), random.nextInt(32768, 65535));
        this.scoreboard = server.getScoreboardManager().getMainScoreboard();
    }

    public boolean disconnect() {
        if (!this.online) {
            return false;
        }
        this.online = false;
        Component message = MiniMessage.miniMessage().deserialize("<name> has left the Server!", (TagResolver)Placeholder.component((String)"name", (ComponentLike)this.displayName()));
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)this, message, PlayerQuitEvent.QuitReason.DISCONNECTED);
        Bukkit.getPluginManager().callEvent((Event)playerQuitEvent);
        this.server.getPlayerList().disconnectPlayer(this);
        return true;
    }

    public boolean reconnect() {
        if (Arrays.stream(this.server.getPlayerList().getOfflinePlayers()).noneMatch(it -> it.getUniqueId().equals(this.getUniqueId()))) {
            throw new IllegalStateException("Player was never online");
        }
        if (this.server.hasWhitelist() && !this.server.getWhitelistedPlayers().contains(this)) {
            return false;
        }
        if (this.online) {
            return false;
        }
        this.online = true;
        this.server.addPlayer(this);
        return true;
    }

    public void simulateConsumeItem(@NotNull ItemStack consumable) {
        Preconditions.checkNotNull((Object)consumable, (Object)"Consumed Item can't be null");
        Preconditions.checkArgument((boolean)consumable.getType().isEdible(), (Object)"Item is not Consumable");
        GenericGameEvent consumeStartEvent = new GenericGameEvent(GameEvent.ITEM_INTERACT_START, this.getLocation(), (Entity)this, 16, !Bukkit.isPrimaryThread());
        Bukkit.getPluginManager().callEvent((Event)consumeStartEvent);
        PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((Player)this, consumable);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            GenericGameEvent stopConsumeEvent = new GenericGameEvent(GameEvent.ITEM_INTERACT_FINISH, this.getLocation(), (Entity)this, 16, !Bukkit.isPrimaryThread());
            Bukkit.getPluginManager().callEvent((Event)stopConsumeEvent);
        }
        this.consumedItems.add(consumable);
    }

    public void assertItemConsumed(@NotNull ItemStack consumable) {
        Preconditions.checkNotNull((Object)consumable, (Object)"Consumed Item can't be null");
        if (!this.consumedItems.contains(consumable)) {
            Assertions.fail();
        }
    }

    @Override
    @NotNull
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @NotNull
    protected BlockDamageEvent simulateBlockDamagePure(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        BlockDamageEvent event = new BlockDamageEvent((Player)this, block, this.getItemInHand(), false);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Nullable
    public BlockDamageEvent simulateBlockDamage(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        if (this.gamemode != GameMode.SURVIVAL) {
            return null;
        }
        BlockDamageEvent event = this.simulateBlockDamagePure(block);
        if (event.getInstaBreak()) {
            BlockBreakEvent breakEvent = new BlockBreakEvent(block, (Player)this);
            Bukkit.getPluginManager().callEvent((Event)breakEvent);
            if (!breakEvent.isCancelled()) {
                block.setType(Material.AIR);
            }
        }
        return event;
    }

    @Nullable
    public BlockBreakEvent simulateBlockBreak(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        if (this.gamemode == GameMode.SPECTATOR || this.gamemode == GameMode.ADVENTURE || this.gamemode == GameMode.SURVIVAL && this.simulateBlockDamagePure(block).isCancelled()) {
            return null;
        }
        BlockBreakEvent event = new BlockBreakEvent(block, (Player)this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            block.setType(Material.AIR);
        }
        return event;
    }

    @Nullable
    public BlockPlaceEvent simulateBlockPlace(@NotNull Material material, @NotNull Location location) {
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        if (this.gamemode == GameMode.ADVENTURE || this.gamemode == GameMode.SPECTATOR) {
            return null;
        }
        Block block = location.getBlock();
        BlockState blockState = block.getState();
        block.setType(material);
        BlockPlaceEvent event = new BlockPlaceEvent(block, blockState, null, this.getItemInHand(), (Player)this, true, EquipmentSlot.HAND);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !event.canBuild()) {
            blockState.update(true, false);
        }
        return event;
    }

    @NotNull
    public InventoryClickEvent simulateInventoryClick(int slot) {
        return this.simulateInventoryClick(this.getOpenInventory(), slot);
    }

    @NotNull
    public InventoryClickEvent simulateInventoryClick(@NotNull InventoryView inventoryView, int slot) {
        return this.simulateInventoryClick(inventoryView, ClickType.LEFT, slot);
    }

    @NotNull
    public InventoryClickEvent simulateInventoryClick(@NotNull InventoryView inventoryView, @NotNull ClickType clickType, int slot) {
        Preconditions.checkNotNull((Object)inventoryView, (Object)"InventoryView cannot be null");
        InventoryClickEvent inventoryClickEvent = new InventoryClickEvent(inventoryView, InventoryType.SlotType.CONTAINER, slot, clickType, InventoryAction.UNKNOWN);
        Bukkit.getPluginManager().callEvent((Event)inventoryClickEvent);
        return inventoryClickEvent;
    }

    public void respawn() {
        Location respawnLocation = this.getBedSpawnLocation();
        boolean isBedSpawn = respawnLocation != null;
        boolean isAnchorSpawn = false;
        if (!isBedSpawn) {
            respawnLocation = this.getLocation().getWorld().getSpawnLocation();
        }
        PlayerRespawnEvent event = new PlayerRespawnEvent((Player)this, respawnLocation, isBedSpawn, isAnchorSpawn);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.setHealth(this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        this.setLocation(event.getRespawnLocation().clone());
        this.alive = true;
    }

    @NotNull
    public PlayerMoveEvent simulatePlayerMove(@NotNull Location moveLocation) {
        Preconditions.checkNotNull((Object)moveLocation, (Object)"Location cannot be null");
        PlayerMoveEvent event = new PlayerMoveEvent((Player)this, this.getLocation(), moveLocation);
        this.setLocation(event.getTo());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.setLocation(event.getFrom());
        }
        return event;
    }

    @Override
    @NotNull
    public GameMode getGameMode() {
        return this.gamemode;
    }

    @Override
    public void setGameMode(@NotNull GameMode mode) {
        Preconditions.checkNotNull((Object)mode, (Object)"GameMode cannot be null");
        if (this.gamemode == mode) {
            return;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this, mode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        if (!event.callEvent()) {
            return;
        }
        this.previousGamemode = this.gamemode;
        this.gamemode = mode;
    }

    public boolean isWhitelisted() {
        return this.server.getWhitelistedPlayers().contains(this);
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getWhitelistedPlayers().add((OfflinePlayer)this);
        } else {
            this.server.getWhitelistedPlayers().remove(this);
        }
    }

    public Player getPlayer() {
        return this.isOnline() ? this : null;
    }

    public boolean isOnline() {
        return this.getServer().getPlayer(this.getUniqueId()) != null;
    }

    public boolean isBanned() {
        return MockBukkit.getMock().getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    public void assertInventoryView(String message, InventoryType type, @NotNull Predicate<Inventory> predicate) {
        InventoryView view = this.getOpenInventory();
        if (view.getType() == type && predicate.test(view.getTopInventory())) {
            return;
        }
        Assertions.fail((String)message);
    }

    public void assertInventoryView(InventoryType type, @NotNull Predicate<Inventory> predicate) {
        this.assertInventoryView("The InventoryView Assertion has failed", type, predicate);
    }

    public void assertInventoryView(InventoryType type) {
        this.assertInventoryView("The InventoryView Assertion has failed", type, inv -> true);
    }

    public void assertInventoryView(String message, InventoryType type) {
        this.assertInventoryView(message, type, inv -> true);
    }

    public void updateInventory() {
    }

    public boolean performCommand(@NotNull String command) {
        Preconditions.checkNotNull((Object)command, (Object)"Command cannot be null");
        return Bukkit.dispatchCommand((CommandSender)this, (String)command);
    }

    public void showDemoScreen() {
        throw new UnimplementedOperationException();
    }

    public boolean isAllowingServerListings() {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getEyeHeight() {
        return this.getEyeHeight(false);
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (this.isSneaking() && !ignorePose) {
            return 1.54;
        }
        return 1.62;
    }

    @Override
    public int getNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public EntityEquipment getEquipment() {
        return (EntityEquipment)this.getInventory();
    }

    public boolean isConversing() {
        throw new UnimplementedOperationException();
    }

    public void acceptConversationInput(@NotNull String input) {
        throw new UnimplementedOperationException();
    }

    public boolean beginConversation(@NotNull Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(@NotNull Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    public void abandonConversation(@NotNull Conversation conversation, @NotNull ConversationAbandonedEvent details) {
        throw new UnimplementedOperationException();
    }

    public long getFirstPlayed() {
        return this.server.getPlayerList().getFirstPlayed(this.getUniqueId());
    }

    @Deprecated
    public long getLastPlayed() {
        return this.getLastSeen();
    }

    public boolean hasPlayedBefore() {
        return this.server.getPlayerList().hasPlayedBefore(this.getUniqueId());
    }

    @Deprecated(forRemoval=true)
    public void setLastPlayed(long time) {
        throw new UnsupportedOperationException("Deprecated; Does not do anything");
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public void sendPluginMessage(@NotNull Plugin source, @NotNull String channel, byte[] message) {
        Preconditions.checkNotNull((Object)source, (Object)"Source cannot be null");
        Preconditions.checkNotNull((Object)channel, (Object)"Channel cannot be null");
        StandardMessenger.validatePluginMessage((Messenger)this.getServer().getMessenger(), (Plugin)source, (String)channel, (byte[])message);
    }

    @NotNull
    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    @NotNull
    public Component displayName() {
        return this.displayName;
    }

    public void displayName(@Nullable Component displayName) {
        this.displayName = displayName;
    }

    @Deprecated
    @NotNull
    public String getDisplayName() {
        return LegacyComponentSerializer.legacySection().serialize(this.displayName);
    }

    @Deprecated
    public void setDisplayName(@NotNull String name) {
        this.displayName = LegacyComponentSerializer.legacySection().deserialize(name);
    }

    @Override
    @NotNull
    public String getScoreboardEntry() {
        return this.getName();
    }

    public void playerListName(@Nullable Component name) {
        this.playerListName = name;
    }

    @NotNull
    public Component playerListName() {
        return this.playerListName == null ? this.name() : this.playerListName;
    }

    @Nullable
    public Component playerListHeader() {
        return this.playerListHeader;
    }

    @Nullable
    public Component playerListFooter() {
        return this.playerListFooter;
    }

    @Deprecated
    @NotNull
    public String getPlayerListName() {
        return this.playerListName == null ? this.getName() : LegacyComponentSerializer.legacySection().serialize(this.playerListName);
    }

    @Deprecated
    public void setPlayerListName(@Nullable String name) {
        this.playerListName = name == null ? null : LegacyComponentSerializer.legacySection().deserialize(name);
    }

    public void setCompassTarget(@NotNull Location loc) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        this.compassTarget = loc;
    }

    @NotNull
    public Location getCompassTarget() {
        return this.compassTarget;
    }

    public void setAddress(@Nullable InetSocketAddress address) {
        this.address = address;
    }

    @Nullable
    public InetSocketAddress getAddress() {
        return this.isOnline() ? this.address : null;
    }

    public int getProtocolVersion() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public InetSocketAddress getVirtualHost() {
        throw new UnimplementedOperationException();
    }

    public void sendRawMessage(@Nullable String message) {
        throw new UnimplementedOperationException();
    }

    public void sendRawMessage(@Nullable UUID sender, @NotNull String message) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void kickPlayer(String message) {
        this.kick((Component)Component.text((String)message));
    }

    public void kick() {
        this.kick(DEFAULT_KICK_COMPONENT);
    }

    public void kick(@Nullable Component message) {
        this.kick(message, PlayerKickEvent.Cause.PLUGIN);
    }

    public void kick(@Nullable Component message, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PlayerKickEvent.Cause cause) {
        AsyncCatcher.catchOp("player kick");
        if (!this.isOnline()) {
            return;
        }
        PlayerKickEvent event = new PlayerKickEvent((Player)this, (Component)Component.text((String)"Plugin"), (Component)(message == null ? Component.empty() : message), cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.server.getPlayerList().disconnectPlayer(this);
    }

    public void chat(@NotNull String msg) {
        Preconditions.checkNotNull((Object)msg, (Object)"Message cannot be null");
        HashSet players = new HashSet(Bukkit.getOnlinePlayers());
        AsyncPlayerChatEvent asyncEvent = new AsyncPlayerChatEvent(true, (Player)this, msg, players);
        AsyncChatEvent asyncChatEvent = new AsyncChatEvent(true, (Player)this, new HashSet(Bukkit.getOnlinePlayers()), ChatRenderer.defaultRenderer(), (Component)Component.text((String)msg), (Component)Component.text((String)msg), SignedMessage.system((String)msg, (ComponentLike)Component.text((String)msg)));
        PlayerChatEvent syncEvent = new PlayerChatEvent((Player)this, msg);
        this.server.getScheduler().executeAsyncEvent((Event)asyncChatEvent);
        this.server.getScheduler().executeAsyncEvent((Event)asyncEvent);
        this.server.getPluginManager().callEvent((Event)syncEvent);
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @NotNull
    public PlayerToggleSneakEvent simulateSneak(boolean sneak) {
        PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this, sneak);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.sneaking = event.isSneaking();
        }
        return event;
    }

    public boolean isSprinting() {
        return this.sprinting;
    }

    public void setSprinting(boolean sprinting) {
        this.sprinting = sprinting;
    }

    @NotNull
    public PlayerToggleSprintEvent simulateSprint(boolean sprint) {
        PlayerToggleSprintEvent event = new PlayerToggleSprintEvent((Player)this, sprint);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.sprinting = event.isSprinting();
        }
        return event;
    }

    public void saveData() {
        throw new UnimplementedOperationException();
    }

    public void loadData() {
        throw new UnimplementedOperationException();
    }

    public boolean isSleepingIgnored() {
        throw new UnimplementedOperationException();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void playNote(@NotNull Location loc, byte instrument, byte note) {
        this.playNote(loc, Instrument.getByType((byte)instrument), note);
    }

    public void playNote(@NotNull Location loc, @NotNull Instrument instrument, @NotNull Note note) {
        this.playNote(loc, instrument, note.getId());
    }

    private void playNote(@NotNull Location loc, @NotNull Instrument instrument, byte note) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)instrument, (Object)"Instrument cannot be null");
        org.bukkit.Sound sound = switch (instrument) {
            default -> throw new IncompatibleClassChangeError();
            case Instrument.BANJO -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_BANJO;
            case Instrument.BASS_DRUM -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_BASEDRUM;
            case Instrument.BASS_GUITAR -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_BASS;
            case Instrument.BELL -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_BELL;
            case Instrument.BIT -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_BIT;
            case Instrument.CHIME -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_CHIME;
            case Instrument.COW_BELL -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_COW_BELL;
            case Instrument.DIDGERIDOO -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_DIDGERIDOO;
            case Instrument.FLUTE -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_FLUTE;
            case Instrument.GUITAR -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_GUITAR;
            case Instrument.IRON_XYLOPHONE -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE;
            case Instrument.PIANO -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_HARP;
            case Instrument.PLING -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_PLING;
            case Instrument.SNARE_DRUM -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_SNARE;
            case Instrument.STICKS -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_HAT;
            case Instrument.XYLOPHONE -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_XYLOPHONE;
            case Instrument.ZOMBIE -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_IMITATE_ZOMBIE;
            case Instrument.SKELETON -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_IMITATE_SKELETON;
            case Instrument.CREEPER -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_IMITATE_CREEPER;
            case Instrument.DRAGON -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_IMITATE_ENDER_DRAGON;
            case Instrument.WITHER_SKELETON -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_IMITATE_WITHER_SKELETON;
            case Instrument.PIGLIN -> org.bukkit.Sound.BLOCK_NOTE_BLOCK_IMITATE_PIGLIN;
            case Instrument.CUSTOM_HEAD -> org.bukkit.Sound.UI_BUTTON_CLICK;
        };
        float pitch = (float)Math.pow(2.0, ((double)note - 12.0) / 12.0);
        this.playSound(loc, sound, SoundCategory.RECORDS, 3.0f, pitch);
    }

    public void playSound(@NotNull Location location, @NotNull String sound, float volume, float pitch) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        this.heardSounds.add(new AudioExperience(sound, SoundCategory.MASTER, location, volume, pitch));
    }

    public void playSound(@NotNull Location location, @NotNull org.bukkit.Sound sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Entity entity, @NotNull org.bukkit.Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(@NotNull Location location, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        Preconditions.checkNotNull((Object)category, (Object)"Category cannot be null");
        this.heardSounds.add(new AudioExperience(sound, category, location, volume, pitch));
    }

    public void playSound(@NotNull Location location, @NotNull org.bukkit.Sound sound, @NotNull SoundCategory category, float volume, float pitch) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        Preconditions.checkNotNull((Object)category, (Object)"Category cannot be null");
        this.heardSounds.add(new AudioExperience(sound, category, location, volume, pitch));
    }

    public void playSound(@NotNull Entity entity, @NotNull org.bukkit.Sound sound, @NotNull SoundCategory category, float volume, float pitch) {
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null");
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        Preconditions.checkNotNull((Object)category, (Object)"Category cannot be null");
        this.heardSounds.add(new AudioExperience(sound, category, entity.getLocation(), volume, pitch));
    }

    public void playSound(@NotNull Sound sound) {
        this.playSound(sound, Sound.Emitter.self());
    }

    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        this.heardSounds.add(new AudioExperience(sound, new Location(this.getWorld(), x, y, z)));
    }

    public void playSound(@NotNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        Preconditions.checkNotNull((Object)emitter, (Object)"Emitter cannot be null");
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
        if (emitter == Sound.Emitter.self()) {
            emitter = this;
        }
        Preconditions.checkArgument((boolean)(emitter instanceof Entity), (Object)"Sound emitter must be an Entity or self()");
        this.heardSounds.add(new AudioExperience(sound, ((Entity)emitter).getLocation()));
    }

    @Override
    @NotNull
    public List<AudioExperience> getHeardSounds() {
        return this.heardSounds;
    }

    @Override
    public void addHeardSound(@NotNull AudioExperience audioExperience) {
        Preconditions.checkNotNull((Object)audioExperience, (Object)"AudioExperience cannot be null");
        SoundReceiver.super.addHeardSound(audioExperience);
    }

    public void stopSound(@NotNull org.bukkit.Sound sound) {
        this.stopSound(sound, SoundCategory.MASTER);
    }

    public void stopSound(@NotNull String sound) {
        this.stopSound(sound, SoundCategory.MASTER);
    }

    public void stopSound(@NotNull org.bukkit.Sound sound, @Nullable SoundCategory category) {
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
    }

    public void stopSound(@NotNull String sound, @Nullable SoundCategory category) {
        Preconditions.checkNotNull((Object)sound, (Object)"Sound cannot be null");
    }

    public void stopSound(@NotNull SoundCategory category) {
    }

    public void stopAllSounds() {
    }

    @Deprecated
    public void playEffect(@NotNull Location loc, @NotNull Effect effect, int data) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)effect, (Object)"Effect cannot be null");
    }

    public <T> void playEffect(@NotNull Location loc, @NotNull Effect effect, @Nullable T data) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)effect, (Object)"Effect cannot be null");
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (Object)"Wrong kind of data for this effect!");
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (Object)"Wrong kind of data for this effect!");
        }
    }

    public boolean breakBlock(@NotNull Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals(this.getWorld()), (Object)"Cannot break blocks across worlds");
        BlockBreakEvent event = new BlockBreakEvent(block, (Player)this);
        boolean swordNoBreak = this.getGameMode() == GameMode.CREATIVE && this.getEquipment().getItemInMainHand().getType().name().contains("SWORD");
        event.setCancelled(swordNoBreak);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            block.setType(Material.AIR);
        }
        return !event.isCancelled();
    }

    @Deprecated
    public void sendBlockChange(@NotNull Location loc, @NotNull Material material, byte data) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)material, (Object)"Material cannot be null");
    }

    public void sendBlockChange(@NotNull Location loc, @NotNull BlockData block) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null");
    }

    public void sendBlockChanges(@NotNull Collection<BlockState> blocks, boolean suppressLightUpdates) {
    }

    public void sendSignChange(@NotNull Location loc, @Nullable List<Component> lines, @NotNull DyeColor dyeColor, boolean hasGlowingText) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)dyeColor, (Object)"DyeColor cannot be null");
        if (lines == null) {
            lines = new ArrayList<Component>(4);
        }
        if (lines.size() < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
    }

    @Deprecated
    public void sendSignChange(@NotNull Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    public void sendSignChange(@NotNull Location loc, String[] lines, @NotNull DyeColor dyeColor) throws IllegalArgumentException {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    public void sendSignChange(@NotNull Location loc, @Nullable @Nullable String @Nullable [] lines, @NotNull DyeColor dyeColor, boolean hasGlowingText) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)dyeColor, (Object)"DyeColor cannot be null");
        if (lines == null) {
            lines = new String[4];
        }
        if (lines.length < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
    }

    public void sendMap(@NotNull MapView map) {
        Preconditions.checkNotNull((Object)map, (Object)"Map cannot be null");
        if (!(map instanceof MapViewMock)) {
            return;
        }
        MapViewMock mapView = (MapViewMock)map;
        mapView.render(this);
    }

    @Deprecated
    public void sendActionBar(@NotNull String message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
    }

    @Deprecated
    public void sendActionBar(char alternateChar, @NotNull String message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
    }

    @Deprecated
    public void sendActionBar(BaseComponent ... message) {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
    }

    @Deprecated
    public void setPlayerListHeaderFooter(BaseComponent @NotNull [] header, BaseComponent @NotNull [] footer) {
        this.playerListHeader = BungeeComponentSerializer.get().deserialize((BaseComponent[])Arrays.stream(header).filter(Objects::nonNull).toArray(BaseComponent[]::new));
        this.playerListFooter = BungeeComponentSerializer.get().deserialize((BaseComponent[])Arrays.stream(footer).filter(Objects::nonNull).toArray(BaseComponent[]::new));
    }

    @Deprecated
    public void setPlayerListHeaderFooter(@Nullable BaseComponent header, @Nullable BaseComponent footer) {
        this.playerListHeader = BungeeComponentSerializer.get().deserialize(new BaseComponent[]{header});
        this.playerListFooter = BungeeComponentSerializer.get().deserialize(new BaseComponent[]{footer});
    }

    @Deprecated
    public void setTitleTimes(int fadeInTicks, int stayTicks, int fadeOutTicks) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setSubtitle(BaseComponent[] subtitle) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setSubtitle(BaseComponent subtitle) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void showTitle(@Nullable BaseComponent[] title) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void showTitle(@Nullable BaseComponent title) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void showTitle(@Nullable BaseComponent[] title, @Nullable BaseComponent[] subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void showTitle(@Nullable BaseComponent title, @Nullable BaseComponent subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void sendTitle(@NotNull Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
    }

    @Deprecated
    public void updateTitle(@NotNull Title title) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void hideTitle() {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public GameMode getPreviousGameMode() {
        return this.previousGamemode;
    }

    public void incrementStatistic(@NotNull Statistic statistic) {
        this.statistics.incrementStatistic(statistic, 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic) {
        this.statistics.decrementStatistic(statistic, 1);
    }

    public void incrementStatistic(@NotNull Statistic statistic, int amount) {
        this.statistics.incrementStatistic(statistic, amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, int amount) {
        this.statistics.decrementStatistic(statistic, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, int newValue) {
        this.statistics.setStatistic(statistic, newValue);
    }

    public int getStatistic(@NotNull Statistic statistic) {
        return this.statistics.getStatistic(statistic);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        this.statistics.incrementStatistic(statistic, material, 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        this.statistics.decrementStatistic(statistic, material, 1);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull Material material) {
        return this.statistics.getStatistic(statistic, material);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        this.statistics.incrementStatistic(statistic, material, amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull Material material, int amount) {
        this.statistics.decrementStatistic(statistic, material, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull Material material, int newValue) {
        this.statistics.setStatistic(statistic, material, newValue);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        this.statistics.incrementStatistic(statistic, entityType, 1);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        this.statistics.decrementStatistic(statistic, entityType, 1);
    }

    public int getStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType) {
        return this.statistics.getStatistic(statistic, entityType);
    }

    public void incrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int amount) {
        this.statistics.incrementStatistic(statistic, entityType, amount);
    }

    public void decrementStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int amount) {
        this.statistics.decrementStatistic(statistic, entityType, amount);
    }

    public void setStatistic(@NotNull Statistic statistic, @NotNull EntityType entityType, int newValue) {
        this.statistics.setStatistic(statistic, entityType, newValue);
    }

    public void setPlayerTime(long time, boolean relative) {
        throw new UnimplementedOperationException();
    }

    public long getPlayerTime() {
        throw new UnimplementedOperationException();
    }

    public long getPlayerTimeOffset() {
        throw new UnimplementedOperationException();
    }

    public boolean isPlayerTimeRelative() {
        throw new UnimplementedOperationException();
    }

    public void resetPlayerTime() {
        throw new UnimplementedOperationException();
    }

    public WeatherType getPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    public void setPlayerWeather(@NotNull WeatherType type) {
        throw new UnimplementedOperationException();
    }

    public void resetPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    public void giveExp(int amount) {
        this.exp += (float)amount / (float)this.getExpToLevel();
        this.setTotalExperience(this.expTotal + amount);
        while (this.exp < 0.0f) {
            float total = this.exp * (float)this.getExpToLevel();
            boolean shouldContinue = this.expLevel > 0;
            this.giveExpLevels(-1);
            if (!shouldContinue) continue;
            this.exp = 1.0f + total / (float)this.getExpToLevel();
        }
        while (this.exp >= 1.0f) {
            this.exp = (this.exp - 1.0f) * (float)this.getExpToLevel();
            this.giveExpLevels(1);
            this.exp /= (float)this.getExpToLevel();
        }
    }

    public void giveExp(int amount, boolean applyMending) {
        throw new UnimplementedOperationException();
    }

    public int applyMending(int amount) {
        throw new UnimplementedOperationException();
    }

    public void giveExpLevels(int amount) {
        int oldLevel = this.expLevel;
        this.expLevel += amount;
        if (this.expLevel < 0) {
            this.expLevel = 0;
            this.exp = 0.0f;
        }
        if (oldLevel != this.expLevel) {
            PlayerLevelChangeEvent event = new PlayerLevelChangeEvent((Player)this, oldLevel, this.expLevel);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }

    public float getExp() {
        return this.exp;
    }

    public void setExp(float exp) {
        if ((double)exp < 0.0 || (double)exp > 1.0) {
            throw new IllegalArgumentException("Experience progress must be between 0.0 and 1.0");
        }
        this.exp = exp;
    }

    public int getLevel() {
        return this.expLevel;
    }

    public void setLevel(int level) {
        this.expLevel = level;
    }

    public int getTotalExperience() {
        return this.expTotal;
    }

    public void setTotalExperience(int exp) {
        this.expTotal = Math.max(0, exp);
    }

    @Nullable
    public Location getBedSpawnLocation() {
        return this.bedSpawnLocation;
    }

    public long getLastLogin() {
        return this.server.getPlayerList().getLastLogin(this.getUniqueId());
    }

    public long getLastSeen() {
        return this.server.getPlayerList().getLastSeen(this.getUniqueId());
    }

    public void setBedSpawnLocation(@Nullable Location loc) {
        this.setBedSpawnLocation(loc, false);
    }

    public void setBedSpawnLocation(@Nullable Location loc, boolean force) {
        if (force || loc == null || Tag.BEDS.isTagged((Keyed)loc.getBlock().getType())) {
            this.bedSpawnLocation = loc;
        }
    }

    public boolean getAllowFlight() {
        return this.allowFlight;
    }

    public void setAllowFlight(boolean flight) {
        if (this.isFlying() && !flight) {
            this.flying = false;
        }
        this.allowFlight = flight;
    }

    public void setFlyingFallDamage(@NotNull TriState flyingFallDamage) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public TriState hasFlyingFallDamage() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void hidePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.hiddenPlayersDeprecated.add(player.getUniqueId());
    }

    public void hidePlayer(@NotNull Plugin plugin, @NotNull Player player) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.hiddenPlayers.putIfAbsent(player.getUniqueId(), new HashSet());
        Set<Plugin> blockingPlugins = this.hiddenPlayers.get(player.getUniqueId());
        blockingPlugins.add(plugin);
    }

    @Deprecated
    public void showPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.hiddenPlayersDeprecated.remove(player.getUniqueId());
    }

    public void showPlayer(@NotNull Plugin plugin, @NotNull Player player) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        if (this.hiddenPlayers.containsKey(player.getUniqueId())) {
            Set<Plugin> blockingPlugins = this.hiddenPlayers.get(player.getUniqueId());
            blockingPlugins.remove(plugin);
            if (blockingPlugins.isEmpty()) {
                this.hiddenPlayers.remove(player.getUniqueId());
            }
        }
    }

    public boolean canSee(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        return !this.hiddenPlayers.containsKey(player.getUniqueId()) && !this.hiddenPlayersDeprecated.contains(player.getUniqueId());
    }

    @ApiStatus.Experimental
    public void hideEntity(@NotNull Plugin plugin, @NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    @ApiStatus.Experimental
    public void showEntity(@NotNull Plugin plugin, @NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    public boolean canSee(@NotNull Entity entity) {
        throw new UnimplementedOperationException();
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean value) {
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.flying = value;
    }

    @NotNull
    public PlayerToggleFlightEvent simulateToggleFlight(boolean fly) {
        PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this, fly);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.flying = event.isFlying();
        }
        return event;
    }

    public float getFlySpeed() {
        throw new UnimplementedOperationException();
    }

    public void setFlySpeed(float value) {
        throw new UnimplementedOperationException();
    }

    public float getWalkSpeed() {
        return (float)(((AttributeInstanceMock)this.attributes.get(Attribute.GENERIC_MOVEMENT_SPEED)).getValue() * 2.0);
    }

    public void setWalkSpeed(float value) {
        Preconditions.checkArgument((value > -1.0f ? 1 : 0) != 0, (Object)(value + " is too low"));
        Preconditions.checkArgument((value < 1.0f ? 1 : 0) != 0, (Object)(value + " is too high"));
        ((AttributeInstanceMock)this.attributes.get(Attribute.GENERIC_MOVEMENT_SPEED)).setBaseValue(value / 2.0f);
    }

    @Deprecated
    public void setTexturePack(@NotNull String url) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setResourcePack(@NotNull String url) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, byte[] hash) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setResourcePack(@NotNull String url, @Nullable byte[] hash, @Nullable String prompt) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, byte[] hash, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setResourcePack(@NotNull String url, @Nullable byte[] hash, @Nullable String prompt, boolean force) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, byte @Nullable [] hash, @Nullable Component prompt, boolean force) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public void setScoreboard(@NotNull Scoreboard scoreboard) {
        Preconditions.checkNotNull((Object)scoreboard, (Object)"Scoreboard cannot be null");
        this.scoreboard = scoreboard;
    }

    @Nullable
    public WorldBorder getWorldBorder() {
        throw new UnimplementedOperationException();
    }

    public void setWorldBorder(@Nullable WorldBorder border) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setHealth(double health) {
        if (health > 0.0) {
            this.health = Math.min(health, this.getMaxHealth());
            return;
        }
        this.health = 0.0;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(Arrays.asList(this.getInventory().getContents()));
        PlayerDeathEvent event = new PlayerDeathEvent((Player)this, drops, 0, this.getName() + " got killed");
        Bukkit.getPluginManager().callEvent((Event)event);
        this.closeInventory();
        if (!((Boolean)this.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY)).booleanValue()) {
            this.getInventory().clear();
        }
        this.setLevel(0);
        this.setExp(0.0f);
        this.setFoodLevel(0);
        this.alive = false;
    }

    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
    }

    public double getHealthScale() {
        return this.healthScale;
    }

    public void setHealthScale(double scale) {
        Preconditions.checkArgument((scale >= 0.0 ? 1 : 0) != 0, (Object)"Must be greater than 0");
        Preconditions.checkArgument((scale != Double.NaN ? 1 : 0) != 0, (Object)(scale + " is not a number!"));
        this.healthScale = scale;
        this.scaledHealth = true;
    }

    public void sendHealthUpdate(double health, int foodLevel, float saturationLevel) {
    }

    public void sendHealthUpdate() {
    }

    public Entity getSpectatorTarget() {
        throw new UnimplementedOperationException();
    }

    public void setSpectatorTarget(Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void sendTitle(String title, String subtitle) {
        this.title.add(title);
        this.subitles.add(subtitle);
    }

    @Deprecated
    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.sendTitle(title, subtitle);
    }

    @Nullable
    public String nextTitle() {
        return this.title.poll();
    }

    @Nullable
    public String nextSubTitle() {
        return this.subitles.poll();
    }

    public void resetTitle() {
        throw new UnimplementedOperationException();
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data) {
        Preconditions.checkNotNull((Object)particle, (Object)"Particle cannot be null");
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
    }

    @NotNull
    public AdvancementProgress getAdvancementProgress(@NotNull Advancement advancement) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public String getLocale() {
        throw new UnimplementedOperationException();
    }

    public boolean getAffectsSpawning() {
        throw new UnimplementedOperationException();
    }

    public void setAffectsSpawning(boolean affects) {
        throw new UnimplementedOperationException();
    }

    public int getViewDistance() {
        throw new UnimplementedOperationException();
    }

    public void setViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public int getSimulationDistance() {
        throw new UnimplementedOperationException();
    }

    public void setSimulationDistance(int simulationDistance) {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public int getNoTickViewDistance() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    public void setNoTickViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public int getSendViewDistance() {
        throw new UnimplementedOperationException();
    }

    public void setSendViewDistance(int viewDistance) {
        throw new UnimplementedOperationException();
    }

    public String getPlayerListHeader() {
        return LegacyComponentSerializer.legacySection().serialize(this.playerListHeader);
    }

    public void setPlayerListHeader(@Nullable String header) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
    }

    public String getPlayerListFooter() {
        return LegacyComponentSerializer.legacySection().serialize(this.playerListFooter);
    }

    public void setPlayerListFooter(@Nullable String footer) {
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
    }

    public void setPlayerListHeaderFooter(@Nullable String header, @Nullable String footer) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
    }

    public void updateCommands() {
        throw new UnimplementedOperationException();
    }

    public int getClientViewDistance() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Locale locale() {
        throw new UnimplementedOperationException();
    }

    public void openBook(@NotNull ItemStack book) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required) {
        throw new UnimplementedOperationException();
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required, @Nullable Component resourcePackPrompt) {
        throw new UnimplementedOperationException();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PlayerResourcePackStatusEvent.Status getResourcePackStatus() {
        throw new UnimplementedOperationException();
    }

    @Deprecated
    @Nullable
    public String getResourcePackHash() {
        throw new UnimplementedOperationException();
    }

    public boolean hasResourcePack() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PlayerProfile getPlayerProfile() {
        throw new UnimplementedOperationException();
    }

    public void setPlayerProfile(@NotNull PlayerProfile profile) {
        throw new UnimplementedOperationException();
    }

    public float getCooldownPeriod() {
        throw new UnimplementedOperationException();
    }

    public float getCooledAttackStrength(float adjustTicks) {
        throw new UnimplementedOperationException();
    }

    public void resetCooldown() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public <T> T getClientOption(@NotNull ClientOption<T> option) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public Firework boostElytra(@NotNull ItemStack firework) {
        throw new UnimplementedOperationException();
    }

    public void sendOpLevel(byte level) {
        throw new UnimplementedOperationException();
    }

    public void addAdditionalChatCompletions(@NotNull Collection<String> completions) {
        throw new UnimplementedOperationException();
    }

    public void removeAdditionalChatCompletions(@NotNull Collection<String> completions) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public String getClientBrandName() {
        throw new UnimplementedOperationException();
    }

    public boolean teleport(@NotNull Location location, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PlayerTeleportEvent.TeleportCause cause, boolean ignorePassengers, boolean dismount, RelativeTeleportFlag ... teleportFlags) {
        throw new UnimplementedOperationException();
    }

    public void lookAt(double x, double y, double z, @NotNull LookAnchor playerAnchor) {
        throw new UnimplementedOperationException();
    }

    public void lookAt(@NotNull Entity entity, @NotNull LookAnchor playerAnchor, @NotNull LookAnchor entityAnchor) {
        throw new UnimplementedOperationException();
    }

    public void showElderGuardian(boolean silent) {
        throw new UnimplementedOperationException();
    }

    public int getWardenWarningCooldown() {
        throw new UnimplementedOperationException();
    }

    public void setWardenWarningCooldown(int cooldown) {
        throw new UnimplementedOperationException();
    }

    public int getWardenTimeSinceLastWarning() {
        throw new UnimplementedOperationException();
    }

    public void setWardenTimeSinceLastWarning(int time) {
        throw new UnimplementedOperationException();
    }

    public int getWardenWarningLevel() {
        throw new UnimplementedOperationException();
    }

    public void setWardenWarningLevel(int warningLevel) {
        throw new UnimplementedOperationException();
    }

    public void increaseWardenWarningLevel() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void attack(@NotNull Entity target) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void broadcastSlotBreak(@NotNull EquipmentSlot slot) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void broadcastSlotBreak(@NotNull EquipmentSlot slot, @NotNull Collection<Player> players) {
        throw new UnimplementedOperationException();
    }

    @Override
    @NotNull
    public ItemStack damageItemStack(@NotNull ItemStack stack, int amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void damageItemStack(@NotNull EquipmentSlot slot, int amount) {
        throw new UnimplementedOperationException();
    }

    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
    }

    public void sendBlockDamage(@NotNull Location loc, float progress) {
        Preconditions.checkNotNull((Object)loc, (Object)"Location cannot be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
    }

    public void sendBlockDamage(@NotNull Location loc, float progress, int destroyerIdentity) {
        throw new UnimplementedOperationException();
    }

    public void sendMultiBlockChange(@NotNull Map<Location, BlockData> blockChanges) {
        Preconditions.checkNotNull(blockChanges, (Object)"BlockChanges cannot be null");
    }

    public void sendMultiBlockChange(@NotNull Map<Location, BlockData> blockChanges, boolean suppressLightUpdates) {
        Preconditions.checkNotNull(blockChanges, (Object)"BlockChanges cannot be null");
    }

    public int getPing() {
        return 0;
    }

    @Override
    public boolean teleport(@NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause cause, boolean ignorePassengers, boolean dismount) {
        Preconditions.checkNotNull((Object)location, (Object)"Location cannot be null");
        Preconditions.checkNotNull((Object)location.getWorld(), (Object)"World cannot be null");
        Preconditions.checkNotNull((Object)cause, (Object)"Cause cannot be null");
        location.checkFinite();
        if (this.isDead() || !ignorePassengers && this.hasPassengers()) {
            return false;
        }
        if (location.getWorld() != this.getWorld() && (ignorePassengers && this.hasPassengers() || !dismount && this.isInsideVehicle())) {
            return false;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)this, this.getLocation(), location, cause);
        if (!event.callEvent()) {
            return false;
        }
        if (this.getOpenInventory().getType() != InventoryType.CRAFTING) {
            this.closeInventory(InventoryCloseEvent.Reason.TELEPORT);
        }
        World previousWorld = this.getWorld();
        this.teleportWithoutEvent(event.getTo(), cause);
        if (!location.getWorld().equals(previousWorld)) {
            new PlayerChangedWorldEvent((Player)this, previousWorld).callEvent();
        }
        return true;
    }

    public void sendEquipmentChange(@NotNull LivingEntity entity, @NotNull EquipmentSlot slot, @NotNull ItemStack item) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity must not be null");
        Preconditions.checkNotNull((Object)slot, (Object)"slot must not be null");
        Preconditions.checkNotNull((Object)item, (Object)"item must not be null");
    }

    @Override
    public boolean isOp() {
        return this.server.getPlayerList().getOperators().stream().anyMatch(op -> op.getPlayer() == this);
    }

    @Override
    public void setOp(boolean isOperator) {
        if (isOperator) {
            this.server.getPlayerList().addOperator(this.getUniqueId());
        } else {
            this.server.getPlayerList().removeOperator(this.getUniqueId());
        }
    }

    @Override
    protected EntityState getEntityState() {
        if (this.isSneaking()) {
            return EntityState.SNEAKING;
        }
        if (this.isGliding()) {
            return EntityState.GLIDING;
        }
        if (this.isSwimming()) {
            return EntityState.SWIMMING;
        }
        if (this.isSleeping()) {
            return EntityState.SLEEPING;
        }
        return super.getEntityState();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Player.Spigot spigot() {
        return this.playerSpigotMock;
    }

    public class PlayerSpigotMock
    extends Player.Spigot {
        @Deprecated
        public void sendMessage(BaseComponent ... components) {
            this.sendMessage(ChatMessageType.CHAT, components);
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, BaseComponent ... components) {
            Preconditions.checkNotNull((Object)position, (Object)"Position must not be null");
            Preconditions.checkNotNull((Object)components, (Object)"Component must not be null");
            Component comp = BungeeComponentSerializer.get().deserialize(components);
            PlayerMock.this.sendMessage(comp);
        }

        @Deprecated
        public void sendMessage(@NotNull BaseComponent component) {
            this.sendMessage(ChatMessageType.CHAT, component);
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, @NotNull BaseComponent component) {
            this.sendMessage(position, new BaseComponent[]{component});
        }
    }
}

