/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import com.google.common.base.Preconditions;
import java.util.Random;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class PlayerMockFactory {
    @NotNull
    private final ServerMock server;
    private final Random random = new Random();
    private int currentNameIndex;

    public PlayerMockFactory(@NotNull ServerMock server) {
        Preconditions.checkNotNull((Object)((Object)server), (Object)"Server cannot be null");
        this.currentNameIndex = 0;
        this.server = server;
    }

    @NotNull
    private String getUniqueRandomName() {
        String name;
        if ((name = "Player" + this.currentNameIndex++).length() > 16) {
            throw new IllegalStateException("Maximum number of player names reached");
        }
        return name;
    }

    @NotNull
    public PlayerMock createRandomPlayer() {
        String name = this.getUniqueRandomName();
        UUID uuid = new UUID(this.random.nextLong(), this.random.nextLong());
        return new PlayerMock(this.server, name, uuid);
    }

    @NotNull
    public OfflinePlayerMock createRandomOfflinePlayer() {
        return new OfflinePlayerMock(this.getUniqueRandomName());
    }

    @NotNull
    public OfflinePlayerMock createOfflinePlayer(@NotNull UUID uuid) {
        return new OfflinePlayerMock(uuid, this.getUniqueRandomName());
    }
}

