/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.AnimalsMock;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Tameable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TameableAnimalMock
extends AnimalsMock
implements Tameable,
Creature {
    @Nullable
    private UUID owner;
    private boolean tamed;
    private boolean sitting;

    public TameableAnimalMock(@NotNull ServerMock server, @NotNull UUID uuid) {
        super(server, uuid);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.owner = uuid;
    }

    public AnimalTamer getOwner() {
        if (this.getOwnerUniqueId() == null) {
            return null;
        }
        Player tamer = this.getServer().getPlayer(this.getOwnerUniqueId());
        if (tamer == null) {
            tamer = this.getServer().getOfflinePlayer(this.getOwnerUniqueId());
        }
        return tamer;
    }

    public boolean isTamed() {
        return this.tamed;
    }

    public void setOwner(@Nullable AnimalTamer tamer) {
        if (tamer != null) {
            this.setTamed(true);
            this.setOwnerUUID(tamer.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public void setTamed(boolean tame) {
        this.tamed = tame;
        if (!tame) {
            this.setOwnerUUID(null);
        }
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return this.owner;
    }

    public boolean isSitting() {
        Preconditions.checkState((boolean)(this instanceof Sittable), (Object)"Not sittable");
        return this.sitting;
    }

    public void setSitting(boolean sitting) {
        Preconditions.checkState((boolean)(this instanceof Sittable), (Object)"Not sittable");
        this.sitting = sitting;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{owner=" + this.getOwner() + ",tamed=" + this.isTamed() + "}";
    }
}

