/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleMetaMock
extends ItemMetaMock
implements BundleMeta {
    private List<ItemStack> items;

    public BundleMetaMock() {
        this.items = new ArrayList<ItemStack>();
    }

    public BundleMetaMock(@NotNull BundleMeta meta) {
        super((ItemMeta)meta);
        this.items = new ArrayList<ItemStack>(meta.getItems());
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    @NotNull
    public List<ItemStack> getItems() {
        return ImmutableList.copyOf(this.items);
    }

    public void setItems(@Nullable List<ItemStack> items) {
        this.items.clear();
        if (items == null) {
            return;
        }
        for (ItemStack i : items) {
            this.addItem(i);
        }
    }

    public void addItem(@NotNull ItemStack item) {
        Preconditions.checkArgument((item != null && !item.getType().isAir() ? 1 : 0) != 0, (Object)"item is null or air");
        this.items.add(item);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.items.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BundleMeta)) {
            return false;
        }
        BundleMeta meta = (BundleMeta)obj;
        return super.equals(obj) && this.getItems().equals(meta.getItems());
    }

    @Override
    @NotNull
    public BundleMetaMock clone() {
        BundleMetaMock clone = (BundleMetaMock)super.clone();
        clone.items = new ArrayList<ItemStack>(this.items);
        return clone;
    }
}

