/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrossbowMetaMock
extends ItemMetaMock
implements CrossbowMeta {
    private List<ItemStack> projectiles;

    public CrossbowMetaMock() {
        this.projectiles = new ArrayList<ItemStack>();
    }

    public CrossbowMetaMock(@NotNull CrossbowMeta meta) {
        super((ItemMeta)meta);
        if (meta.hasChargedProjectiles()) {
            this.projectiles = new ArrayList<ItemStack>(meta.getChargedProjectiles());
        }
    }

    public boolean hasChargedProjectiles() {
        return !this.projectiles.isEmpty();
    }

    @NotNull
    public List<ItemStack> getChargedProjectiles() {
        return ImmutableList.copyOf(this.projectiles);
    }

    public void setChargedProjectiles(@Nullable List<ItemStack> projectiles) {
        this.projectiles.clear();
        if (projectiles == null) {
            return;
        }
        for (ItemStack i : projectiles) {
            this.addChargedProjectile(i);
        }
    }

    public void addChargedProjectile(@NotNull ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"item");
        Preconditions.checkArgument((item.getType() == Material.FIREWORK_ROCKET || item.getType().name().contains("ARROW") ? 1 : 0) != 0, (String)"Item %s is not an arrow or firework rocket", (Object)item);
        this.projectiles.add(item);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.projectiles.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CrossbowMeta)) {
            return false;
        }
        CrossbowMeta meta = (CrossbowMeta)obj;
        return super.equals(obj) && Objects.equals(this.getChargedProjectiles(), meta.getChargedProjectiles());
    }

    @Override
    @NotNull
    public CrossbowMetaMock clone() {
        CrossbowMetaMock clone = (CrossbowMetaMock)super.clone();
        clone.projectiles = new ArrayList<ItemStack>(this.projectiles);
        return clone;
    }
}

