/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import com.destroystokyo.paper.Namespaced;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMetaMock
implements ItemMeta,
Damageable,
Repairable {
    @Nullable
    private String displayName = null;
    @Nullable
    private String localizedName = null;
    @Nullable
    private List<String> lore = null;
    private int damage = 0;
    private int repairCost = 0;
    @Nullable
    private Map<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private Set<ItemFlag> hideFlags = EnumSet.noneOf(ItemFlag.class);
    private PersistentDataContainerMock persistentDataContainer = new PersistentDataContainerMock();
    private boolean unbreakable = false;
    @Nullable
    private Integer customModelData = null;

    public ItemMetaMock() {
    }

    public ItemMetaMock(@NotNull ItemMeta meta) {
        this.unbreakable = meta.isUnbreakable();
        this.enchants = new HashMap<Enchantment, Integer>(meta.getEnchants());
        this.customModelData = meta.hasCustomModelData() ? Integer.valueOf(meta.getCustomModelData()) : null;
        this.hideFlags.addAll(meta.getItemFlags());
        if (meta.hasDisplayName()) {
            this.displayName = (String)GsonComponentSerializer.gson().serialize(meta.displayName());
        }
        if (meta.hasLore()) {
            this.lore = meta.lore().stream().map(c -> (String)GsonComponentSerializer.gson().serialize(c)).collect(Collectors.toList());
        }
        if (meta instanceof Damageable) {
            Damageable d = (Damageable)meta;
            this.damage = d.getDamage();
        }
        if (meta instanceof Repairable) {
            Repairable r = (Repairable)meta;
            this.repairCost = r.getRepairCost();
        }
        if (meta instanceof ItemMetaMock) {
            ItemMetaMock m = (ItemMetaMock)meta;
            this.persistentDataContainer = m.persistentDataContainer;
        }
        if (meta.hasAttributeModifiers()) {
            this.attributeModifiers = LinkedHashMultimap.create((Multimap)meta.getAttributeModifiers());
        }
    }

    static boolean checkConflictingEnchants(@Nullable Map<Enchantment, Integer> enchantments, @NotNull Enchantment ench) {
        Enchantment enchant;
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        Iterator<Enchantment> var2 = enchantments.keySet().iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!(enchant = var2.next()).conflictsWith(ench));
        return true;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    @Nullable
    public Component displayName() {
        return this.displayName == null ? null : GsonComponentSerializer.gson().deserialize((Object)this.displayName);
    }

    public void displayName(@Nullable Component displayName) {
        this.displayName = (String)GsonComponentSerializer.gson().serialize(displayName);
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName == null ? null : LegacyComponentSerializer.legacySection().serialize(GsonComponentSerializer.gson().deserialize((Object)this.displayName));
    }

    @NotNull
    public @NotNull BaseComponent @NotNull [] getDisplayNameComponent() {
        return BungeeComponentSerializer.get().serialize(GsonComponentSerializer.gson().deserialize((Object)this.displayName));
    }

    public void setDisplayName(@Nullable String name) {
        this.displayName = name == null ? null : (String)GsonComponentSerializer.gson().serialize((Component)LegacyComponentSerializer.legacySection().deserialize(name));
    }

    public void setDisplayNameComponent(BaseComponent @NotNull [] components) {
        this.displayName = (String)GsonComponentSerializer.gson().serialize(BungeeComponentSerializer.get().deserialize((BaseComponent[])Arrays.stream(components).filter(Objects::nonNull).toArray(BaseComponent[]::new)));
    }

    private boolean isLoreEquals(@NotNull ItemMeta meta) {
        if (this.lore == null) {
            return !meta.hasLore();
        }
        if (!meta.hasLore()) {
            return false;
        }
        List otherLore = meta.lore();
        if (this.lore.size() == otherLore.size()) {
            for (int i = 0; i < this.lore.size(); ++i) {
                if (GsonComponentSerializer.gson().deserialize((Object)this.lore.get(i)).equals(otherLore.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isDisplayNameEqual(@NotNull ItemMeta meta) {
        if (this.displayName != null) {
            if (meta.hasDisplayName()) {
                return GsonComponentSerializer.gson().deserialize((Object)this.displayName).equals(meta.displayName());
            }
            return false;
        }
        return !meta.hasDisplayName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.lore == null ? 0 : this.lore.hashCode());
        result = 31 * result + (this.customModelData == null ? 0 : this.customModelData.hashCode());
        result = 31 * result + (this.enchants.isEmpty() ? 0 : this.enchants.hashCode());
        result = 31 * result + (this.hasRepairCost() ? this.repairCost : 0);
        result = 31 * result + (!this.persistentDataContainer.isEmpty() ? this.persistentDataContainer.hashCode() : 0);
        result = 31 * result + (this.hideFlags.isEmpty() ? 0 : this.hideFlags.hashCode());
        result = 31 * result + Boolean.hashCode(this.unbreakable);
        result = 31 * result + (this.hasDamage() ? this.damage : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemMeta)) {
            return false;
        }
        ItemMeta meta = (ItemMeta)obj;
        if (!this.isDisplayNameEqual(meta)) {
            return false;
        }
        if (!this.isLoreEquals(meta)) {
            return false;
        }
        if (obj instanceof Damageable) {
            Damageable damageable = (Damageable)obj;
            if (this.hasDamage() != damageable.hasDamage() || this.hasDamage() && this.getDamage() != damageable.getDamage()) {
                return false;
            }
        } else if (this.hasDamage()) {
            return false;
        }
        if (!this.enchants.equals(meta.getEnchants())) {
            return false;
        }
        if (!this.hideFlags.equals(meta.getItemFlags())) {
            return false;
        }
        if (!this.persistentDataContainer.equals(meta.getPersistentDataContainer())) {
            return false;
        }
        if (this.unbreakable != meta.isUnbreakable()) {
            return false;
        }
        return this.hasCustomModelData() == meta.hasCustomModelData() && (!this.hasCustomModelData() || this.getCustomModelData() == meta.getCustomModelData());
    }

    @NotNull
    public ItemMetaMock clone() {
        try {
            ItemMetaMock meta = (ItemMetaMock)super.clone();
            meta.displayName = this.displayName;
            if (this.lore != null) {
                meta.lore = new ArrayList<String>(this.lore);
            }
            meta.unbreakable = this.unbreakable;
            meta.customModelData = this.customModelData;
            meta.enchants = new HashMap<Enchantment, Integer>(this.enchants);
            meta.persistentDataContainer = new PersistentDataContainerMock(this.persistentDataContainer);
            meta.damage = this.damage;
            meta.repairCost = this.repairCost;
            meta.hideFlags = EnumSet.copyOf(this.hideFlags);
            return meta;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Material> getCanDestroy() {
        throw new UnimplementedOperationException();
    }

    public void setCanDestroy(Set<Material> canDestroy) {
        throw new UnimplementedOperationException();
    }

    public Set<Material> getCanPlaceOn() {
        throw new UnimplementedOperationException();
    }

    public void setCanPlaceOn(Set<Material> canPlaceOn) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<Namespaced> getDestroyableKeys() {
        throw new UnimplementedOperationException();
    }

    public void setDestroyableKeys(@NotNull Collection<Namespaced> canDestroy) {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public Set<Namespaced> getPlaceableKeys() {
        throw new UnimplementedOperationException();
    }

    public void setPlaceableKeys(@NotNull Collection<Namespaced> canPlaceOn) {
        throw new UnimplementedOperationException();
    }

    public boolean hasPlaceableKeys() {
        throw new UnimplementedOperationException();
    }

    public boolean hasDestroyableKeys() {
        throw new UnimplementedOperationException();
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    @Nullable
    public List<Component> lore() {
        return this.lore.stream().map(s -> GsonComponentSerializer.gson().deserialize(s)).collect(Collectors.toList());
    }

    public void lore(@Nullable List<Component> lore) {
        this.lore = lore != null && !lore.isEmpty() ? new ArrayList<String>(lore.stream().map(s -> (String)GsonComponentSerializer.gson().serialize(s)).toList()) : null;
    }

    @Nullable
    public List<String> getLore() {
        return this.lore == null ? null : this.lore.stream().map(s -> LegacyComponentSerializer.legacySection().serialize(GsonComponentSerializer.gson().deserialize(s))).collect(Collectors.toList());
    }

    @Nullable
    public List<BaseComponent[]> getLoreComponents() {
        return this.lore.stream().map(c -> BungeeComponentSerializer.get().serialize(GsonComponentSerializer.gson().deserialize(c))).collect(Collectors.toList());
    }

    public void setLore(@Nullable List<String> lore) {
        this.lore = lore != null && !lore.isEmpty() ? lore.stream().map(s -> (String)GsonComponentSerializer.gson().serialize(LegacyComponentSerializer.legacySection().deserialize(s).asComponent())).collect(Collectors.toList()) : null;
    }

    public void setLoreComponents(@Nullable List<BaseComponent[]> lore) {
        this.lore(lore == null ? null : lore.stream().map(c -> BungeeComponentSerializer.get().deserialize(c)).toList());
    }

    public void assertLore(@NotNull List<String> lines) {
        this.assertComponentLore(lines.stream().map(s -> LegacyComponentSerializer.legacySection().deserialize(s).asComponent()).toList());
    }

    public void assertComponentLore(@NotNull List<Component> lines) {
        if (this.lore == null) {
            throw new AssertionError((Object)"No lore was set");
        }
        if (this.lore.size() != lines.size()) {
            throw new AssertionError((Object)("Lore size mismatch: expected " + lines.size() + " but was " + this.lore.size()));
        }
        for (int i = 0; i < this.lore.size(); ++i) {
            if (!GsonComponentSerializer.gson().deserialize((Object)this.lore.get(i)).equals(lines.get(i))) {
                throw new AssertionError((Object)String.format("Line %d should be '%s' but was '%s'", i, lines.get(i), this.lore.get(i)));
            }
        }
    }

    public void assertLore(String ... lines) {
        this.assertLore(Arrays.asList(lines));
    }

    public void assertHasNoLore() throws AssertionError {
        if (this.hasLore()) {
            throw new AssertionError((Object)"Lore was set but shouldn't have been set");
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.displayName != null) {
            map.put("display-name", this.displayName);
        }
        if (this.localizedName != null) {
            map.put("loc-name", this.localizedName);
        }
        if (this.lore != null) {
            map.put("lore", this.lore);
        }
        if (this.customModelData != null) {
            map.put("custom-model-data", this.customModelData);
        }
        map.put("enchants", this.enchants);
        if (this.hasAttributeModifiers()) {
            map.put("attribute-modifiers", this.attributeModifiers);
        }
        map.put("repair-cost", this.repairCost);
        map.put("ItemFlags", this.hideFlags);
        map.put("Unbreakable", this.unbreakable);
        map.put("Damage", this.damage);
        map.put("PublicBukkitValues", this.persistentDataContainer.serialize());
        return map;
    }

    @NotNull
    public static ItemMetaMock deserialize(@NotNull Map<String, Object> args) {
        ItemMetaMock serialMock = new ItemMetaMock();
        serialMock.displayName = (String)args.get("display-name");
        serialMock.lore = (List)args.get("lore");
        serialMock.localizedName = (String)args.get("loc-name");
        serialMock.enchants = (Map)args.get("enchants");
        serialMock.hideFlags = (Set)args.get("ItemFlags");
        serialMock.unbreakable = (Boolean)args.get("Unbreakable");
        serialMock.setAttributeModifiers((Multimap<Attribute, AttributeModifier>)((Multimap)args.get("AttributeModifiers")));
        serialMock.customModelData = (Integer)args.get("custom-model-data");
        Map map = (Map)args.get("PublicBukkitValues");
        serialMock.persistentDataContainer = PersistentDataContainerMock.deserialize(map);
        serialMock.damage = (Integer)args.get("Damage");
        serialMock.repairCost = (Integer)args.get("repair-cost");
        return serialMock;
    }

    public boolean hasLocalizedName() {
        return this.localizedName != null;
    }

    @NotNull
    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(@Nullable String name) {
        this.localizedName = name;
    }

    public boolean hasEnchants() {
        return !this.enchants.isEmpty();
    }

    public boolean hasEnchant(Enchantment ench) {
        return this.enchants.containsKey(ench);
    }

    public int getEnchantLevel(Enchantment ench) {
        return this.hasEnchant(ench) ? this.enchants.get(ench) : 0;
    }

    @NotNull
    public Map<Enchantment, Integer> getEnchants() {
        return Collections.unmodifiableMap(this.enchants);
    }

    public boolean addEnchant(@NotNull Enchantment ench, int level, boolean ignoreLevelRestriction) {
        Integer existingLevel = this.enchants.get(ench);
        if (Objects.nonNull(existingLevel) && existingLevel.equals(level)) {
            return false;
        }
        if (ignoreLevelRestriction || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            this.enchants.put(ench, level);
            return true;
        }
        return false;
    }

    public boolean removeEnchant(Enchantment ench) {
        return Objects.nonNull(this.enchants.remove(ench));
    }

    public boolean hasConflictingEnchant(Enchantment ench) {
        boolean b;
        boolean bl = b = this.hasEnchants() && this.enchants.remove(ench) != null;
        if (this.enchants != null && this.enchants.isEmpty()) {
            this.enchants = null;
        }
        return b;
    }

    public void addItemFlags(ItemFlag ... itemFlags) {
        this.hideFlags.addAll(Arrays.asList(itemFlags));
    }

    public void removeItemFlags(ItemFlag ... itemFlags) {
        this.hideFlags.removeAll(Arrays.asList(itemFlags));
    }

    @NotNull
    public Set<ItemFlag> getItemFlags() {
        return Collections.unmodifiableSet(this.hideFlags);
    }

    public boolean hasItemFlag(ItemFlag flag) {
        return this.hideFlags.contains(flag);
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean hasDamage() {
        return this.damage > 0;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    private void checkAttributeMap() {
        if (this.attributeModifiers == null) {
            this.attributeModifiers = LinkedHashMultimap.create();
        }
    }

    public boolean hasAttributeModifiers() {
        return this.attributeModifiers != null && !this.attributeModifiers.isEmpty();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.hasAttributeModifiers() ? ImmutableMultimap.copyOf(this.attributeModifiers) : null;
    }

    public void setAttributeModifiers(@Nullable Multimap<Attribute, AttributeModifier> attributeModifiers) {
        if (attributeModifiers == null || attributeModifiers.isEmpty()) {
            this.attributeModifiers = LinkedHashMultimap.create();
            return;
        }
        this.checkAttributeMap();
        this.attributeModifiers.clear();
        attributeModifiers.entries().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).forEach(entry -> this.attributeModifiers.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue())));
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot) {
        this.checkAttributeMap();
        LinkedHashMultimap result = LinkedHashMultimap.create();
        this.attributeModifiers.entries().stream().filter(entry -> ((AttributeModifier)entry.getValue()).getSlot() != null && ((AttributeModifier)entry.getValue()).getSlot() == slot).forEach(arg_0 -> ItemMetaMock.lambda$getAttributeModifiers$12((SetMultimap)result, arg_0));
        return result;
    }

    public Collection<AttributeModifier> getAttributeModifiers(@NotNull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        return this.attributeModifiers.containsKey((Object)attribute) ? ImmutableList.copyOf((Collection)this.attributeModifiers.get((Object)attribute)) : null;
    }

    public boolean addAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeMap();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            Preconditions.checkArgument((!((AttributeModifier)entry.getValue()).getUniqueId().equals(modifier.getUniqueId()) ? 1 : 0) != 0, (String)"Cannot register AttributeModifier. Modifier is already applied! %s", (Object)modifier);
        }
        return this.attributeModifiers.put((Object)attribute, (Object)modifier);
    }

    public boolean removeAttributeModifier(@NotNull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        this.checkAttributeMap();
        return !this.attributeModifiers.removeAll((Object)attribute).isEmpty();
    }

    public boolean removeAttributeModifier(@NotNull EquipmentSlot slot) {
        this.checkAttributeMap();
        return this.attributeModifiers.entries().removeIf(entry -> ((AttributeModifier)entry.getValue()).getSlot() == null || ((AttributeModifier)entry.getValue()).getSlot() == slot);
    }

    public boolean removeAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeMap();
        return this.attributeModifiers.entries().removeIf(entry -> entry.getKey() == null || entry.getValue() == null || entry.getKey() == attribute && ((AttributeModifier)entry.getValue()).getUniqueId().equals(modifier.getUniqueId()));
    }

    @NotNull
    public String getAsString() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public CustomItemTagContainer getCustomTagContainer() {
        throw new UnimplementedOperationException();
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public boolean hasCustomModelData() {
        return this.customModelData != null;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public void setCustomModelData(@Nullable Integer data) {
        this.customModelData = data;
    }

    public void setVersion(int version) {
        throw new UnimplementedOperationException();
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$12(SetMultimap result, Map.Entry entry) {
        result.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
    }
}

