/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeatherArmorMetaMock
extends ItemMetaMock
implements LeatherArmorMeta {
    private Color color;

    public LeatherArmorMetaMock() {
        this.color = Bukkit.getItemFactory().getDefaultLeatherColor();
    }

    public LeatherArmorMetaMock(@NotNull LeatherArmorMeta meta) {
        super((ItemMeta)meta);
        this.color = meta.getColor();
    }

    @Override
    @NotNull
    public LeatherArmorMetaMock clone() {
        LeatherArmorMetaMock mock = (LeatherArmorMetaMock)super.clone();
        mock.setColor(this.color);
        return mock;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.color.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LeatherArmorMeta)) {
            return false;
        }
        LeatherArmorMeta other = (LeatherArmorMeta)obj;
        return Objects.equals(this.color, other.getColor());
    }

    @NotNull
    public Color getColor() {
        return this.color;
    }

    public void setColor(@Nullable Color color) {
        this.color = color == null ? Bukkit.getItemFactory().getDefaultLeatherColor() : color;
    }
}

