/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.map;

import be.seeseemelk.mockbukkit.map.MapViewMock;
import java.awt.Color;
import java.awt.Image;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.NotNull;

public class MapCanvasMock
implements MapCanvas {
    private static final int MAP_SIZE = 128;
    private final MapViewMock mapView;
    private final byte[][] pixels = new byte[128][128];
    private byte[][] base;
    @NotNull
    private MapCursorCollection cursors = new MapCursorCollection();

    protected MapCanvasMock(MapViewMock mapView) {
        this.mapView = mapView;
        Arrays.stream(this.pixels).forEach(x -> Arrays.fill(x, (byte)-1));
    }

    @NotNull
    public MapView getMapView() {
        return this.mapView;
    }

    @NotNull
    public MapCursorCollection getCursors() {
        return this.cursors;
    }

    public void setCursors(@NotNull MapCursorCollection cursors) {
        this.cursors = cursors;
    }

    public void setPixelColor(int x, int y, @NotNull Color color) {
        this.pixels[x][y] = MapPalette.matchColor((Color)color);
    }

    @NotNull
    public Color getPixelColor(int x, int y) {
        return MapPalette.getColor((byte)this.pixels[x][y]);
    }

    @NotNull
    public Color getBasePixelColor(int x, int y) {
        return MapPalette.getColor((byte)this.base[x][y]);
    }

    public void setPixel(int x, int y, byte color) {
        this.pixels[x][y] = color;
    }

    public byte getPixel(int x, int y) {
        return this.pixels[x][y];
    }

    public byte getBasePixel(int x, int y) {
        return this.base[x][y];
    }

    public void setBase(byte[][] base) {
        this.base = base;
    }

    public void drawImage(int x, int y, @NotNull Image image) {
        byte[] bytes = MapPalette.imageToBytes((Image)image);
        for (int imgX = 0; imgX < image.getWidth(null); ++imgX) {
            for (int imgY = 0; imgY < image.getHeight(null); ++imgY) {
                this.setPixel(x + imgX, y + imgY, bytes[imgY * image.getWidth(null) + imgX]);
            }
        }
    }

    public void drawText(int x, int y, @NotNull MapFont font, @NotNull String text) {
        if (!font.isValid(text)) {
            throw new IllegalArgumentException("text contains invalid characters");
        }
        int initX = x;
        byte color = 44;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                x = initX;
                y += font.getHeight() + 1;
                continue;
            }
            if (c == '\u00a7') {
                int idx = text.indexOf(59, i);
                if (idx == -1) {
                    throw new IllegalArgumentException("Text contains unterminated color string");
                }
                try {
                    color = Byte.parseByte(text.substring(i + 1, idx));
                    i = idx;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MapFont.CharacterSprite sprite = font.getChar(text.charAt(i));
            for (int h = 0; h < font.getHeight(); ++h) {
                for (int w = 0; w < sprite.getWidth(); ++w) {
                    if (!sprite.get(h, w)) continue;
                    this.setPixel(x + w, y + h, color);
                }
            }
            x += sprite.getWidth() + 1;
        }
    }

    public static void executeForAllPixels(@NotNull BiConsumer<Integer, Integer> consumer) {
        for (int x = 0; x < 128; ++x) {
            for (int y = 0; y < 128; ++y) {
                consumer.accept(x, y);
            }
        }
    }
}

