/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.map;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import be.seeseemelk.mockbukkit.map.MapCanvasMock;
import be.seeseemelk.mockbukkit.map.MapRendererMock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapViewMock
implements MapView {
    private World world;
    private final int id;
    @NotNull
    private final List<MapRenderer> renderers;
    private final Map<MapRenderer, Map<PlayerMock, MapCanvasMock>> canvases = new HashMap<MapRenderer, Map<PlayerMock, MapCanvasMock>>();
    private MapView.Scale scale;
    private boolean locked;

    @ApiStatus.Internal
    public MapViewMock(World world, int id) {
        this.world = world;
        this.id = id;
        this.renderers = new ArrayList<MapRenderer>();
        this.scale = MapView.Scale.NORMAL;
        this.locked = false;
    }

    public int getId() {
        return this.id;
    }

    public boolean isVirtual() {
        return !this.renderers.isEmpty() && !(this.renderers.get(0) instanceof MapRendererMock);
    }

    @NotNull
    public MapView.Scale getScale() {
        return this.scale;
    }

    public void setScale(@NotNull MapView.Scale scale) {
        this.scale = scale;
    }

    public int getCenterX() {
        throw new UnimplementedOperationException();
    }

    public int getCenterZ() {
        throw new UnimplementedOperationException();
    }

    public void setCenterX(int x) {
        throw new UnimplementedOperationException();
    }

    public void setCenterZ(int z) {
        throw new UnimplementedOperationException();
    }

    @Nullable
    public World getWorld() {
        return this.world;
    }

    public void setWorld(@NotNull World world) {
        this.world = world;
    }

    @NotNull
    public List<MapRenderer> getRenderers() {
        return new ArrayList<MapRenderer>(this.renderers);
    }

    public void addRenderer(@NotNull MapRenderer renderer) {
        if (!this.renderers.contains(renderer)) {
            this.renderers.add(renderer);
            this.canvases.put(renderer, new HashMap());
            renderer.initialize((MapView)this);
        }
    }

    public boolean removeRenderer(@Nullable MapRenderer renderer) {
        if (!this.renderers.contains(renderer)) {
            return false;
        }
        this.renderers.remove(renderer);
        for (MapCanvasMock canvas : this.canvases.get(renderer).values()) {
            MapCanvasMock.executeForAllPixels((x, y) -> canvas.setPixel((int)x, (int)y, (byte)-1));
        }
        this.canvases.remove(renderer);
        return true;
    }

    public void render(@NotNull PlayerMock player) {
        Iterator<MapRenderer> iterator = this.renderers.iterator();
        while (iterator.hasNext()) {
            MapRenderer renderer;
            MapCanvasMock canvas = this.canvases.get(renderer).get((renderer = iterator.next()).isContextual() ? player : null);
            if (canvas == null) {
                canvas = new MapCanvasMock(this);
                this.canvases.get(renderer).put(renderer.isContextual() ? player : null, canvas);
            }
            try {
                renderer.render((MapView)this, (MapCanvas)canvas, (Player)player);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isTrackingPosition() {
        throw new UnimplementedOperationException();
    }

    public void setTrackingPosition(boolean trackingPosition) {
        throw new UnimplementedOperationException();
    }

    public boolean isUnlimitedTracking() {
        throw new UnimplementedOperationException();
    }

    public void setUnlimitedTracking(boolean unlimited) {
        throw new UnimplementedOperationException();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }
}

